/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.quota;

import java.math.BigDecimal;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class QTLineDetailNumHelper {
    private static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ123456789";
    private static final int MAX_LENG = 13;
    public static final String PRE_DETAIL_NUM = "QU-";
    private static Log LOGGER = LogFactory.getLog(QTLineDetailNumHelper.class);

    public static String convertNum(Long detailId) {
        String postId = "";
        try {
            while (detailId > 0L) {
                long remainder = detailId % 34L;
                detailId = (detailId - remainder) / 34L;
                postId = alphabet.charAt((int)remainder) + postId;
            }
        }
        catch (Exception ex) {
            LOGGER.error("id:{} convertnum is fail {}", (Object)detailId, (Object)ex);
        }
        if (postId.length() < 13) {
            int zero = 13 - postId.length();
            for (int i = 0; i < zero; ++i) {
                postId = "0" + postId;
            }
        }
        return PRE_DETAIL_NUM + postId;
    }

    public static Long convertId(String numString) {
        BigDecimal decimal = new BigDecimal(0);
        numString = numString.replace(PRE_DETAIL_NUM, "");
        for (int i = 0; i < numString.length(); ++i) {
            char c = numString.charAt(i);
            int num = alphabet.indexOf(c);
            if (num <= 0) continue;
            decimal = decimal.add(new BigDecimal(num).multiply(new BigDecimal(34).pow(numString.length() - 1 - i)));
        }
        return decimal.longValue();
    }
}

