/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.ruleenging;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtp.common.constants.RuleEngingConstants;

public class RuleEngingHelper
implements RuleEngingConstants {
    private static final String PAGE_BRMSCENE = "brm_scene";

    public static DynamicObject queryScene(String sceneNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(PAGE_BRMSCENE);
        return helper.loadDynamicObject(new QFilter("number", "=", (Object)sceneNumber));
    }

    public static DynamicObject queryPolicyDataByPlanId(long planId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_ruleassociation");
        return helper.queryOne("policyid, ruleset", new QFilter[]{new QFilter("planid", "=", (Object)planId)});
    }

    public static DynamicObject queryRuleEngingByPlanId(Object policyId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("brm_policy_edit");
        return helper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", policyId)});
    }

    public static void saveRuleAssociation(DynamicObject pageDy) {
        DynamicObject ruleAssociationDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtp_ruleassociation"));
        ruleAssociationDy.set("planid", (Object)pageDy.getLong("id"));
        ruleAssociationDy.set("policyid", (Object)pageDy.getLong("policyid"));
        ruleAssociationDy.set("ruleset", (Object)pageDy.getString("ruleset"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_ruleassociation");
        helper.saveOne(ruleAssociationDy);
    }

    public static String queryAppIdByNumber(String number) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_devportal_bizapp");
        DynamicObject dy = helper.queryOriginalOne("id", new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (dy != null) {
            return dy.getString("id");
        }
        return "0";
    }

    public static Set<Long> whetherToUseRuleEngine(List<Long> planIdList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_ruleassociation");
        DynamicObject[] dys = helper.queryOriginalArray("planid, ruleset", new QFilter[]{new QFilter("planid", "in", planIdList)});
        return Arrays.stream(dys).filter(dy -> "2".equals(dy.getString("ruleset"))).map(dy -> dy.getLong("planid")).collect(Collectors.toSet());
    }
}

