/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.ruleenging;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.ext.hr.ruleengine.controls.DefaultResult;
import kd.bos.ext.hr.ruleengine.infos.ResultInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.DateUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.toolkit.utils.SerializationUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.cache.IWTCAppCache;
import kd.wtc.wtbs.common.cache.WTCCache;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.overtime.OverworkRuleUtil;
import kd.wtc.wtp.business.ruleenging.RuleEngineValidator;
import kd.wtc.wtp.business.ruleenging.RuleEngineValidatorEnum;
import kd.wtc.wtp.business.ruleenging.RuleEngingHelper;
import kd.wtc.wtp.business.ruleenging.RulePreviewUtil;
import kd.wtc.wtp.common.constants.RuleEngingConstants;
import kd.wtc.wtp.common.ruleengine.RuleEngineValidatorVo;
import kd.wtc.wtp.constants.timecut.TimeCutConstants;

public class RuleEngingService
implements RuleEngingConstants {
    private static final Log log = LogFactory.getLog(RuleEngingService.class);
    private static final String RULEENGING = "ruleenging";

    public static RuleEngingService getInstance() {
        return Instance.instance;
    }

    public static String getPolicyName(String planName) {
        String dateStr = DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM-dd"});
        String code = RuleEngingService.getCountStr(dateStr);
        return planName + "_" + code;
    }

    public static String getCodeRuleNumber() {
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        MainEntityType wttePairTimeType = MetadataServiceHelper.getDataEntityType((String)"wtp_ruleenging");
        DynamicObject pairTimeDynamicObject = new DynamicObject((DynamicObjectType)wttePairTimeType);
        return coderule.getNumber("wtp_ruleenging", pairTimeDynamicObject, null);
    }

    public static String getRuleName() {
        String dateStr = "WTC_RULE_" + DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM-dd"});
        String code = RuleEngingService.getCountStr(dateStr);
        return dateStr + code;
    }

    private static String getCountStr(String dateStr) {
        String countStr;
        IWTCAppCache wtcCache;
        try {
            wtcCache = WTCCache.get((String)"wtp");
            countStr = (String)wtcCache.get(RULEENGING + dateStr, String.class);
        }
        catch (Exception e) {
            return String.valueOf(DB.genGlobalLongId()).substring(0, 4);
        }
        DecimalFormat dft = new DecimalFormat("0000");
        int count = HRStringUtils.isEmpty((String)countStr) ? 1 : Integer.parseInt(countStr) + 1;
        String code = dft.format(count);
        wtcCache.put(RULEENGING + dateStr, (Object)code);
        return code;
    }

    public static void genShowRuleEngingPage(IFormView view) {
        DynamicObject pageDy = view.getModel().getDataEntity();
        Object policyid = pageDy.get("policyid");
        String planFlag = RuleEngingConstants.Plan.getPlanFlagByFormId((String)view.getFormShowParameter().getFormId());
        boolean removeOldOtScene = false;
        if (RuleEngingConstants.Plan.otp.getPlanFlag().equals(planFlag)) {
            if (OverworkRuleUtil.policyidIsOt3(policyid)) {
                planFlag = RuleEngingConstants.Plan.otp3.getPlanFlag();
            } else if (!WTCHisService.isLock((IFormView)view)) {
                planFlag = RuleEngingConstants.Plan.otp3.getPlanFlag();
                removeOldOtScene = true;
            }
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.setFormId("wtp_ruleenging");
        parameters.getOpenStyle().setTargetKey("flexpanelap1");
        parameters.getOpenStyle().setShowType(ShowType.InContainer);
        parameters.setShowTitle(false);
        parameters.setCustomParam("planFlag", (Object)planFlag);
        parameters.setCustomParam("ruleset", (Object)pageDy.getString("setruleway"));
        parameters.setCustomParam("policy", policyid);
        parameters.setCustomParam("removeOldOtScene", (Object)removeOldOtScene);
        parameters.setCustomParam("iscopy", view.getFormShowParameter().getCustomParam("iscopy"));
        parameters.setStatus(RuleEngingService.getFormStatus(view, false));
        parameters.setParentPageId(view.getPageId());
        view.showForm(parameters);
        view.getPageCache().put("childpageid", parameters.getPageId());
    }

    public static void setPolicyNumberAndName(IDataModel model) {
        long policyId = DB.genGlobalLongId();
        model.setValue("policyid", (Object)policyId);
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        dataModel.beginInit();
        dataModel.clearNoDataRow();
        dataModel.endInit();
    }

    public static void initViewAndEidtData(IFormView view, DefaultResult defaultResult) {
        FormShowParameter parameter = view.getFormShowParameter();
        String association = (String)parameter.getCustomParam("ruleset");
        if (!"2".equals(association)) {
            return;
        }
        DynamicObject policyDy = RuleEngingHelper.queryRuleEngingByPlanId(parameter.getCustomParam("policy"));
        if (policyDy == null) {
            return;
        }
        RuleEngingService.removeOldOtScene(parameter, policyDy);
        RuleEngingService.setViewAndEidtInitData(policyDy, view, defaultResult);
    }

    private static void setViewAndEidtInitData(DynamicObject policyDy, IFormView view, DefaultResult defaultResult) {
        DynamicObject pageDy = view.getModel().getDataEntity();
        pageDy.set("policy", (Object)policyDy.getString("name"));
        boolean isRetrunDefault = policyDy.getBoolean("retrundefault");
        pageDy.set("retrundefault", (Object)isRetrunDefault);
        String defaultResultStr = policyDy.getString("results");
        if (isRetrunDefault && HRStringUtils.isNotEmpty((String)defaultResultStr) && defaultResult != null) {
            defaultResult.setValue(defaultResultStr);
        }
        view.getModel().deleteEntryData("entryrulelist");
        DynamicObjectCollection entryDys = policyDy.getDynamicObjectCollection("entryrulelist");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)view.getModel();
        abstractFormDataModel.beginInit();
        for (int i = 0; i < entryDys.size(); ++i) {
            DynamicObject entryDy = (DynamicObject)entryDys.get(i);
            TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
            tableValueSetter.set("rulenumber", (Object)entryDy.getString("rulenumber"), i);
            tableValueSetter.set("rulename", (Object)entryDy.getString("rulename"), i);
            tableValueSetter.set("ruledescript", (Object)entryDy.getString("ruledescription"), i);
            tableValueSetter.set("ruleenable", (Object)entryDy.getBoolean("ruleenable"), i);
            tableValueSetter.set("ruleorder", (Object)entryDy.getInt("ruleorder"), i);
            tableValueSetter.set("filtercondition", (Object)entryDy.getString("filtercondition"), i);
            tableValueSetter.set("filterresult", (Object)entryDy.getString("filterresult"), i);
            tableValueSetter.set("filterconditionpreview", (Object)RulePreviewUtil.getConditionPreviewStr(entryDy.getString("filtercondition")), i);
            tableValueSetter.set("filterresultpreview", (Object)RulePreviewUtil.getResultPreviewStr(entryDy.getString("filterresult")), i);
        }
        abstractFormDataModel.clearNoDataRow();
        abstractFormDataModel.batchCreateNewEntryRow("entryrulelist", vs);
        abstractFormDataModel.endInit();
        view.updateView("entryrulelist");
    }

    public static IWTCAppCache getCache() {
        return WTCCache.get((String)"wtp");
    }

    public static boolean checkRuleEngingEnableSet() {
        return false;
    }

    public static boolean checkRuleEngingAssociation(long id) {
        if (id == 0L) {
            return false;
        }
        DynamicObject dy = RuleEngingHelper.queryPolicyDataByPlanId(id);
        return dy != null && "2".equals(dy.getString("ruleset"));
    }

    public static DynamicObject parseDynamicObjectJson(String data, String formId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        DynamicObject dataEntity = (DynamicObject)entityType.createInstance();
        if (StringUtils.isNotBlank((CharSequence)data)) {
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            dataEntity = (DynamicObject)jser.deserializeFromString(data, (Object)dataEntity);
        }
        return dataEntity;
    }

    public static String convertDynamicObjectToJson(DynamicObject dataEntity) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        return jser.serializeToString((Object)dataEntity, null);
    }

    public static boolean validRuleResult(IFormView view, BeforeDoOperationEventArgs args, String resultJson) {
        RuleValidateInfo info = RuleValidateUtil.validRuleResult((String)resultJson);
        return RuleEngingService.showErrorNotification(view, args, info);
    }

    public static boolean validDefaultResult(IFormView view, BeforeDoOperationEventArgs args, String resultJson) {
        RuleValidateInfo info = RuleValidateUtil.validDefaultResult((String)resultJson);
        return RuleEngingService.showErrorNotification(view, args, info);
    }

    public static boolean validCondition(IFormView view, BeforeDoOperationEventArgs args, String conditionJson) {
        RuleValidateInfo info = RuleValidateUtil.validCondition((String)conditionJson);
        return RuleEngingService.showErrorNotification(view, args, info);
    }

    private static boolean showErrorNotification(IFormView view, BeforeDoOperationEventArgs args, RuleValidateInfo info) {
        if (!info.isSuccess()) {
            if (args != null) {
                args.setCancel(true);
                args.setCancelMessage(info.getMsgList().toString());
            }
            view.showErrorNotification(info.getMsgList().toString());
        }
        return info.isSuccess();
    }

    public static Map<String, Object> validDefaultResult(String conditionJson) {
        RuleValidateInfo ruleValidateInfo = RuleValidateUtil.validDefaultResult((String)conditionJson);
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("isSuccess", ruleValidateInfo.isSuccess());
        map.put("msg", ruleValidateInfo.getMsgList());
        return map;
    }

    public static OperationStatus getFormStatus(IFormView view, boolean isAfterDo) {
        OperationStatus i;
        String status = view.getModel().getDataEntity().getString("status");
        String fromPage = (String)view.getFormShowParameter().getCustomParams().get("fromPage");
        switch (status) {
            case "A": {
                i = OperationStatus.EDIT;
                break;
            }
            case "B": {
                i = OperationStatus.VIEW;
                break;
            }
            case "C": {
                i = OperationStatus.VIEW;
                break;
            }
            default: {
                i = OperationStatus.ADDNEW;
            }
        }
        if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
            i = isAfterDo ? OperationStatus.VIEW : OperationStatus.EDIT;
        } else if (HRStringUtils.equals((String)fromPage, (String)"openVersionPage")) {
            i = OperationStatus.VIEW;
        }
        return i;
    }

    public static String compareBsedWithPlanFirstBsed(String resultJson, Date bsed, String ruleFormId, String planName, String tipTitle) {
        DynamicObject[] ruleDataDys;
        if (bsed == null || HRStringUtils.isEmpty((String)ruleFormId) || HRStringUtils.isEmpty((String)resultJson)) {
            return "";
        }
        RuleResultInfo ruleResultInfo = (RuleResultInfo)SerializationUtils.fromJsonString((String)resultJson, RuleResultInfo.class);
        List collect = ruleResultInfo.getResultList().stream().filter(resultInfo -> resultInfo.getParam().contains(ruleFormId)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return "";
        }
        String value = ((ResultInfo)collect.get(0)).getValue();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ruleFormId);
        String[] idArrays = value.split(",");
        List idList = Arrays.stream(idArrays).map(Long::valueOf).collect(Collectors.toList());
        for (DynamicObject ruleDataDy : ruleDataDys = helper.queryOriginalArray("firstbsed, name", new QFilter[]{new QFilter("id", "in", idList)})) {
            Date firstBsed = ruleDataDy.getDate("firstbsed");
            Date date = firstBsed = firstBsed == null ? bsed : firstBsed;
            if (bsed.compareTo(firstBsed) >= 0) continue;
            return String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u665a\u4e8e\u5f53\u524d%3$s\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"RuleEngingService_1", (String)"wtc-wtp-business", (Object[])new Object[0]), tipTitle, ruleDataDy.getString("name"), planName);
        }
        return "";
    }

    public String customValidator(String resultJson, String planFlag, Date startDate) {
        RuleEngineValidatorEnum engineValidatorEnum = RuleEngineValidatorEnum.getEnumByPlanType(planFlag);
        if (engineValidatorEnum != null) {
            RuleEngineValidator validator;
            try {
                Class<?> validatorClass = Class.forName(engineValidatorEnum.getClassName());
                validator = (RuleEngineValidator)validatorClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error("ruleenine.customvalidator error.", (Throwable)e);
                return "ruleenine.customvalidator error.";
            }
            RuleEngineValidatorVo engineValidatorVo = new RuleEngineValidatorVo();
            engineValidatorVo.setBsed(startDate);
            RuleResultInfo ruleResultInfo = (RuleResultInfo)SerializationUtils.fromJsonString((String)resultJson, RuleResultInfo.class);
            List resultInfoList = ruleResultInfo.getResultList();
            return validator.validator(resultInfoList, engineValidatorVo);
        }
        return "";
    }

    private static void removeOldOtScene(FormShowParameter parameter, DynamicObject policyDy) {
        if (parameter.getCustomParam("removeOldOtScene") != null && ((Boolean)parameter.getCustomParam("removeOldOtScene")).booleanValue()) {
            boolean returnDefault = policyDy.getBoolean("retrundefault");
            String defaultResultStr = policyDy.getString("results");
            if (returnDefault && HRStringUtils.isNotEmpty((String)defaultResultStr)) {
                policyDy.set("results", (Object)RuleEngingService.cleanOldOtSceneByRuleStr(defaultResultStr));
            }
            DynamicObjectCollection entryDys = policyDy.getDynamicObjectCollection("entryrulelist");
            for (DynamicObject entryDy : entryDys) {
                entryDy.set("filterresult", (Object)RuleEngingService.cleanOldOtSceneByRuleStr(entryDy.getString("filterresult")));
            }
        }
    }

    private static String cleanOldOtSceneByRuleStr(String ruleJsonStr) {
        if (WTCStringUtils.isEmpty((String)ruleJsonStr)) {
            return ruleJsonStr;
        }
        JSONArray resultList = JSONObject.parseObject((String)ruleJsonStr).getJSONArray("resultList");
        for (Object ruleEntryResult : resultList) {
            Integer oldSceneType;
            String oldScene;
            String[] oldSceneValues;
            List oldSceneList;
            JSONObject ruleEntry2 = (JSONObject)ruleEntryResult;
            if (!"otscene".equals(ruleEntry2.getString("param")) || !WTCCollections.isNotEmpty(oldSceneList = Arrays.stream(oldSceneValues = (oldScene = ruleEntry2.getString("value")).split(",")).filter(WTCStringUtils::isNotEmpty).map(scene -> Integer.valueOf(scene)).collect(Collectors.toList())) || oldSceneList.size() != 1 || !TimeCutConstants.OLD_AND_NEW_MAP.containsKey(oldSceneType = (Integer)oldSceneList.get(0))) continue;
            Long timeCutId = (Long)TimeCutConstants.OLD_AND_NEW_MAP.get(oldSceneType);
            DynamicObject timeCutDy = HRBaseServiceHelper.create((String)"wtp_timecut").loadSingle((Object)timeCutId);
            ruleEntry2.put("displayParam", (Object)ResManager.loadKDString((String)"\u5de5\u65f6\u5207\u5206\u914d\u7f6e", (String)"RuleEngingService_2", (String)"wtc-wtp-business", (Object[])new Object[0]));
            ruleEntry2.put("param", (Object)"timecut.wtp_timecut.id");
            ruleEntry2.put("paramType", (Object)"dynamicObject");
            ruleEntry2.put("displayValue", (Object)timeCutDy.getString("name"));
            ruleEntry2.put("value", (Object)timeCutDy.getString("id"));
        }
        resultList.removeIf(ruleEntry -> "otscene".equals(((JSONObject)ruleEntry).getString("param")));
        if (WTCCollections.isEmpty((Collection)resultList)) {
            return "";
        }
        for (int i = 0; i < resultList.size(); ++i) {
            JSONObject entry = (JSONObject)resultList.get(i);
            entry.put("index", (Object)i);
        }
        JSONObject result = new JSONObject();
        result.put("resultList", (Object)resultList);
        return JSONObject.toJSONString((Object)result);
    }

    private static class Instance {
        private static RuleEngingService instance = new RuleEngingService();

        private Instance() {
        }
    }
}

