/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.ruleenging;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.business.ruleenging.RuleOrder;

public class RuleOrderTool {
    public static final int ORDER_START = 100;
    public static final int ORDER_STEP = 100;
    public static final int MIN_STEP = 3;

    public void init(DynamicObjectCollection ruleEntry, IPageCache pageCache) {
        int backSpace = Integer.MAX_VALUE;
        RuleOrder lastOne = null;
        ArrayList entryRowList = Lists.newArrayListWithCapacity((int)ruleEntry.size());
        for (DynamicObject rule : ruleEntry) {
            RuleOrder ruleOrder = new RuleOrder();
            int currentOrder = rule.getInt("ruleorder");
            ruleOrder.setOrder(rule.getInt("ruleorder"));
            ruleOrder.setRuleNumber(rule.getString("rulenumber"));
            ruleOrder.setBackwardSpace(backSpace);
            if (lastOne != null) {
                lastOne.setBackwardSpace(currentOrder - lastOne.getOrder());
            }
            entryRowList.add(ruleOrder);
            lastOne = ruleOrder;
        }
        this.setEntryRowListToCache(entryRowList, pageCache);
    }

    private int getNewestOrder(ArrayList<RuleOrder> entryRowList) {
        return entryRowList.size() == 0 ? 100 : entryRowList.get(entryRowList.size() - 1).getOrder() + 100;
    }

    public void deleteRuleOrder(int[] rowIndexArray, IPageCache pageCache) {
        ArrayList<RuleOrder> entryRowList = this.getEntryRowList(pageCache);
        if (entryRowList.size() == 0) {
            return;
        }
        for (int i = 0; i < rowIndexArray.length; ++i) {
            RuleOrder lastOne;
            int rowIndex = rowIndexArray[i];
            int realIndex = i != 0 ? rowIndex - i : rowIndex;
            if (realIndex == 0) {
                entryRowList.remove(realIndex);
                continue;
            }
            if (realIndex == entryRowList.size() - 1) {
                lastOne = entryRowList.get(realIndex - 1);
                lastOne.setBackwardSpace(Integer.MAX_VALUE);
            } else {
                lastOne = entryRowList.get(realIndex - 1);
                RuleOrder nextOne = entryRowList.get(realIndex + 1);
                int lastOrder = lastOne.getOrder();
                int nextOrder = nextOne.getOrder();
                int space = nextOrder - lastOrder;
                lastOne.setBackwardSpace(space);
            }
            entryRowList.remove(realIndex);
        }
        this.setEntryRowListToCache(entryRowList, pageCache);
    }

    public int addNewRuleOrder(DynamicObject rule, IPageCache pageCache) {
        ArrayList<RuleOrder> entryRowList = this.getEntryRowList(pageCache);
        RuleOrder ruleOrder = new RuleOrder();
        ruleOrder.setRuleNumber(rule.getString("rulenumber"));
        int newOrder = this.getNewestOrder(entryRowList);
        ruleOrder.setOrder(newOrder);
        ruleOrder.setBackwardSpace(Integer.MAX_VALUE);
        RuleOrder lastOne = this.getLast(entryRowList);
        if (lastOne != null) {
            int lastOrder = lastOne.getOrder();
            lastOne.setBackwardSpace(newOrder - lastOrder);
        }
        entryRowList.add(ruleOrder);
        this.setEntryRowListToCache(entryRowList, pageCache);
        return newOrder;
    }

    public int insertNewRuleOrder(int currentRow, DynamicObject rule, IPageCache pageCache) {
        ArrayList<RuleOrder> entryRowList = this.getEntryRowList(pageCache);
        if (currentRow == 0) {
            RuleOrder nextOne = entryRowList.get(currentRow);
            int currentOrder = nextOne.getOrder() >> 1;
            RuleOrder newOrder = new RuleOrder();
            newOrder.setOrder(currentOrder);
            newOrder.setRuleNumber(rule.getString("rulenumber"));
            newOrder.setBackwardSpace(nextOne.getOrder() - currentOrder);
            entryRowList.add(0, newOrder);
            this.setEntryRowListToCache(entryRowList, pageCache);
            return currentOrder;
        }
        RuleOrder lastOne = entryRowList.get(currentRow - 1);
        RuleOrder nextOne = entryRowList.get(currentRow);
        int lastOrder = lastOne.getOrder();
        int nextOrder = nextOne.getOrder();
        int currentOrder = lastOrder + nextOrder >> 1;
        RuleOrder newOrder = new RuleOrder();
        newOrder.setOrder(currentOrder);
        newOrder.setRuleNumber(rule.getString("rulenumber"));
        int forwardSpace = currentOrder - lastOrder;
        int backwardSpace = nextOrder - currentOrder;
        newOrder.setBackwardSpace(backwardSpace);
        lastOne.setBackwardSpace(forwardSpace);
        entryRowList.add(currentRow, newOrder);
        this.setEntryRowListToCache(entryRowList, pageCache);
        return currentOrder;
    }

    public void moveUpRuleOrder(int rowIndex, IPageCache pageCache) {
        ArrayList<RuleOrder> entryRowList = this.getEntryRowList(pageCache);
        RuleOrder currentRow = entryRowList.get(rowIndex);
        RuleOrder lastOne = entryRowList.get(rowIndex - 1);
        int lastOrder = lastOne.getOrder();
        if (rowIndex == 1) {
            int newOrder = lastOrder >> 1;
            currentRow.setOrder(newOrder);
            int newSpace = lastOrder - newOrder;
            currentRow.setBackwardSpace(newSpace);
            lastOne.setBackwardSpace(Integer.MAX_VALUE);
        } else {
            RuleOrder lastLastOne = entryRowList.get(rowIndex - 2);
            int lastLastOrder = lastLastOne.getOrder();
            int newOrder = lastOrder + lastLastOrder >> 1;
            currentRow.setOrder(newOrder);
            int lastLastSpace = newOrder - lastLastOrder;
            lastLastOne.setBackwardSpace(lastLastSpace);
            int lastSpace = lastOrder - newOrder;
            currentRow.setBackwardSpace(lastSpace);
            lastOne.setBackwardSpace(Integer.MAX_VALUE);
        }
        if (rowIndex < entryRowList.size() - 1) {
            RuleOrder nextOne = entryRowList.get(rowIndex + 1);
            int nextOrder = nextOne.getOrder();
            int nextSpace = nextOrder - lastOrder;
            lastOne.setBackwardSpace(nextSpace);
        }
        entryRowList.set(rowIndex - 1, currentRow);
        entryRowList.set(rowIndex, lastOne);
        this.setEntryRowListToCache(entryRowList, pageCache);
    }

    public void moveDownRuleOrder(int rowIndex, IPageCache pageCache) {
        ArrayList<RuleOrder> entryRowList = this.getEntryRowList(pageCache);
        RuleOrder currentRow = entryRowList.get(rowIndex);
        RuleOrder nextOne = entryRowList.get(rowIndex + 1);
        int nextOrder = nextOne.getOrder();
        if (rowIndex == entryRowList.size() - 2) {
            int newOrder = nextOrder + 100;
            currentRow.setOrder(newOrder);
            currentRow.setBackwardSpace(Integer.MAX_VALUE);
            nextOne.setBackwardSpace(100);
        } else {
            RuleOrder nextNextOne = entryRowList.get(rowIndex + 2);
            int nextNextOrder = nextNextOne.getOrder();
            int newOrder = nextOrder + nextNextOrder >> 1;
            currentRow.setOrder(newOrder);
            int nextNextSpace = nextNextOrder - newOrder;
            currentRow.setBackwardSpace(nextNextSpace);
            int newNextSpace = newOrder - nextOrder;
            nextOne.setBackwardSpace(newNextSpace);
        }
        if (rowIndex != 0) {
            RuleOrder lastOne = entryRowList.get(rowIndex - 1);
            int lastOrder = lastOne.getOrder();
            int lastSpace = nextOrder - lastOrder;
            lastOne.setBackwardSpace(lastSpace);
        }
        entryRowList.set(rowIndex + 1, currentRow);
        entryRowList.set(rowIndex, nextOne);
        this.setEntryRowListToCache(entryRowList, pageCache);
    }

    public boolean checkAllRowOrder(IPageCache pageCache) {
        ArrayList<RuleOrder> entryRowList = this.getEntryRowList(pageCache);
        for (RuleOrder ruleOrder : entryRowList) {
            if (ruleOrder.getOrder() != 0 && ruleOrder.getBackwardSpace() >= 3) continue;
            return false;
        }
        return true;
    }

    public void resetAllRowOrder(IPageCache pageCache) {
        ArrayList<RuleOrder> entryRowList = this.getEntryRowList(pageCache);
        if (entryRowList.size() == 0) {
            return;
        }
        int newOrder = 0;
        int lastOrder = 0;
        for (RuleOrder ruleOrder : entryRowList) {
            newOrder = newOrder == 0 ? 100 : lastOrder + 100;
            ruleOrder.setOrder(newOrder);
            ruleOrder.setBackwardSpace(100);
            lastOrder = newOrder;
        }
        entryRowList.get(entryRowList.size() - 1).setBackwardSpace(Integer.MAX_VALUE);
        this.setEntryRowListToCache(entryRowList, pageCache);
    }

    private RuleOrder getLast(ArrayList<RuleOrder> entryRowList) {
        return entryRowList.size() > 0 ? entryRowList.get(entryRowList.size() - 1) : null;
    }

    public ArrayList<RuleOrder> getEntryRowList(IPageCache pageCache) {
        List data = (List)SerializationUtils.fromJsonString((String)pageCache.get("entryListByOrder"), ArrayList.class);
        ArrayList entryRowList = Lists.newArrayListWithCapacity((int)data.size());
        data.forEach(row -> {
            RuleOrder ruleOrder = new RuleOrder();
            ruleOrder.setOrder((Integer)row.get("order"));
            ruleOrder.setRuleNumber((String)row.get("ruleNumber"));
            ruleOrder.setBackwardSpace((Integer)row.get("backwardSpace"));
            entryRowList.add(ruleOrder);
        });
        return entryRowList;
    }

    private void setEntryRowListToCache(ArrayList<RuleOrder> entryRowList, IPageCache pageCache) {
        pageCache.put("entryListByOrder", SerializationUtils.toJsonString(entryRowList));
    }
}

