/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.ruleenging;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.enums.RuleOperatorEnum;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.bos.lang.Lang;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class RulePreviewUtil {
    static Set<String> replaceOptSet = new HashSet<String>(10);

    public static String getConditionPreviewStr(String conditions) {
        if (StringUtils.isEmpty((CharSequence)(conditions = RuleUtil.getNewestConditionValue((String)conditions)))) {
            return "";
        }
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        List conditionList = conditionInfo.getConditionList();
        List conditionExpressList = conditionInfo.getConditionExpressList();
        if (CollectionUtils.isEmpty((Collection)conditionExpressList)) {
            return "";
        }
        StringBuilder previewSb = new StringBuilder();
        Map<String, ConditionInfo> conditionInfoMap = conditionList.stream().collect(Collectors.toMap(ConditionInfo::getName, condition -> condition));
        if (!CollectionUtils.isEmpty((Collection)conditionExpressList)) {
            ConditionExpressInfo lastInfo = (ConditionExpressInfo)conditionExpressList.get(conditionExpressList.size() - 1);
            lastInfo.setLogical("");
        }
        conditionExpressList.forEach(conditionExpressInfo -> {
            String logical;
            String leftBracket = conditionExpressInfo.getLeftBracket();
            if (HRStringUtils.isNotEmpty((String)leftBracket)) {
                previewSb.append(leftBracket).append(' ');
            }
            ConditionInfo info = (ConditionInfo)conditionInfoMap.get(conditionExpressInfo.getName());
            previewSb.append(info.getDisplayParam()).append(' ');
            if (RulePreviewUtil.isReplaceOpt(info.getOperators())) {
                String replacement = ResManager.loadKDString((String)"\u6216\u8005\u662f\u3002", (String)"RulePreviewUtil_0", (String)"wtc-wtp-business", (Object[])new Object[0]);
                String name = RuleOperatorEnum.getEnum((String)info.getOperators()).getName();
                String displayValue = HRStringUtils.isEmpty((String)info.getDisplayValue()) ? "" : info.getDisplayValue();
                String content = name.replace("/", replacement.substring(0, replacement.length() - 1)).replace("...", displayValue);
                previewSb.append(content).append(' ');
            } else {
                previewSb.append(RuleOperatorEnum.getEnum((String)info.getOperators()).getName()).append(' ');
                String value = info.getDisplayValue();
                if (HRStringUtils.isNotEmpty((String)value)) {
                    previewSb.append(value).append(' ');
                }
            }
            String rightBracket = conditionExpressInfo.getRightBracket();
            if (HRStringUtils.isNotEmpty((String)rightBracket)) {
                previewSb.append(rightBracket).append(' ');
            }
            if (HRStringUtils.isNotEmpty((String)(logical = conditionExpressInfo.getLogical()))) {
                previewSb.append(RulePreviewUtil.getLogicLocaleStr(logical)).append(' ');
            }
        });
        return previewSb.toString();
    }

    private static boolean isReplaceOpt(String opt) {
        return (Lang.zh_CN.equals((Object)Lang.get()) || Lang.zh_TW.equals((Object)Lang.get())) && replaceOptSet.contains(opt);
    }

    public static String getResultPreviewStr(String results) {
        results = RuleUtil.getNewestResultValue((String)results);
        RuleResultInfo resultInfo = (RuleResultInfo)SerializationUtils.fromJsonString((String)results, RuleResultInfo.class);
        List resultInfoList = resultInfo.getResultList();
        StringBuilder previewSb = new StringBuilder();
        resultInfoList.forEach(info -> {
            previewSb.append(info.getDisplayParam()).append(' ');
            previewSb.append(RuleOperatorEnum.getEnum((String)info.getOperators()).getName()).append(' ');
            previewSb.append(info.getDisplayValue()).append(' ');
            previewSb.append(';').append(' ');
        });
        return previewSb.toString();
    }

    private static String getLogicLocaleStr(String logic) {
        return HRStringUtils.equals((String)logic.trim(), (String)"and") ? ResManager.loadKDString((String)"\u5e76\u4e14", (String)"RulePreviewUtil_1", (String)"wtc-wtp-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6216\u8005", (String)"RulePreviewUtil_2", (String)"wtc-wtp-business", (Object[])new Object[0]);
    }

    static {
        replaceOptSet.add(RuleOperatorEnum.IN.getValue());
        replaceOptSet.add(RuleOperatorEnum.NOT_IN.getValue());
        replaceOptSet.add(RuleOperatorEnum.IS_OR_IS_SUB.getValue());
        replaceOptSet.add(RuleOperatorEnum.STARTS_WITH.getValue());
        replaceOptSet.add(RuleOperatorEnum.ENDS_WITH.getValue());
    }
}

