/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtp.business.coordination.CoordinationTask;
import kd.wtc.wtp.common.model.coordination.CoordinationTaskResponse;
import kd.wtc.wtp.enums.coordination.CoordinationExecutionStatusEnum;

public class CoordinationTaskExecuteTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(CoordinationTaskExecuteTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] logDyArray;
        LOG.debug("CoordinationTaskExecuteTask.execute start");
        HRBaseServiceHelper taskHelper = new HRBaseServiceHelper("wtp_coordinationtask");
        QFilter qFilter = new QFilter("executionstatus", "=", (Object)CoordinationExecutionStatusEnum.EXECUTING.getCode());
        Map<Long, Long> coordinationLogIdMap = Arrays.stream(taskHelper.query("id,coordinationlog", new QFilter[]{qFilter})).collect(Collectors.toMap(d -> d.getLong("coordinationlog"), d -> d.getLong("id"), (a, b) -> a));
        LOG.debug("CoordinationTaskExecuteTask.execute logDyArray size {}", (Object)coordinationLogIdMap.size());
        if (WTCCollections.isNotEmpty(coordinationLogIdMap) && (logDyArray = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtis", (String)"ICoordinationService", (String)"load", (Object[])new Object[]{new ArrayList<Long>(coordinationLogIdMap.keySet())})) != null && logDyArray.length > 0) {
            for (DynamicObject logDy : logDyArray) {
                if (coordinationLogIdMap.get(logDy.getLong("id")) == null || coordinationLogIdMap.get(logDy.getLong("id")) == 0L) continue;
                CoordinationTaskResponse coordinationTaskResponse = new CoordinationTaskResponse();
                coordinationTaskResponse.setTaskId(coordinationLogIdMap.get(logDy.getLong("id")).longValue());
                CoordinationTask.getInstance().execute(coordinationTaskResponse, logDy);
            }
        }
        LOG.debug("CoordinationTaskExecuteTask.execute end");
    }
}

