/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class DepEmpJobSyncTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(DepEmpJobSyncTask.class);
    private static final String VALUE = "-1";
    private static final String BATCH_SIZE = "batchSize";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (LOG.isInfoEnabled()) {
            LOG.info("DepEmpJobSyncTask.execute start");
        }
        ArrayList<DynamicObject> needUpdateDys = new ArrayList<DynamicObject>();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_depempjob");
        QFilter[] filters = new QFilter[]{new QFilter("datastatus", "!=", (Object)VALUE)};
        DynamicObject[] dys = helper.loadDynamicObjectArray(filters);
        if (null == dys || dys.length == 0) {
            return;
        }
        try {
            int batchSize = map.get(BATCH_SIZE) == null ? 1000 : Integer.parseInt((String)map.get(BATCH_SIZE));
            Map<Long, DynamicObject> dyMap = Arrays.stream(dys).collect(Collectors.toMap(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"id"), dy -> dy, (a, b) -> b));
            List partition = Lists.partition(new ArrayList<Long>(dyMap.keySet()), (int)batchSize);
            for (List depEmpIdList : partition) {
                QFilter qFilter = new QFilter("id", "in", (Object)depEmpIdList);
                DynamicObject[] empOrgRelArr = HRPIMServiceImpl.getInstance().listFieldsFilterInfo("id", qFilter, "hrpi_empposorgrel");
                List collectDepEmpIds = Arrays.stream(empOrgRelArr).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"id")).collect(Collectors.toList());
                for (Long depEmpId : depEmpIdList) {
                    if (collectDepEmpIds.contains(depEmpId)) continue;
                    DynamicObject dy2 = dyMap.get(depEmpId);
                    dy2.set("datastatus", (Object)VALUE);
                    needUpdateDys.add(dy2);
                }
            }
            if (WTCCollections.isNotEmpty(needUpdateDys)) {
                helper.update(needUpdateDys.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception ex) {
            LOG.error("DepEmpJobSyncTask.execute error ", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386\u8865\u507f\u5931\u8d25\u3002", (String)"DepEmpJobSyncTask_0", (String)"wtc-wtp-business", (Object[])new Object[0]));
        }
    }
}

