/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtp.business.attperiod.PeriodServiceHelper;
import kd.wtc.wtp.business.task.PerAttPeriodSyncTask;

public class PerAttPeriodRegularCleanTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(PerAttPeriodSyncTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.debug("PerAttPeriodRegularCleanTask start");
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        queryParam.setBusiStatus("0");
        queryParam.setProperties("id");
        List perAttPeriodList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodDy(queryParam);
        if (CollectionUtils.isEmpty((Collection)perAttPeriodList)) {
            LOG.debug("PerAttPeriodRegularCleanTask.invalidPerAttPeriodId is empty.");
            return;
        }
        Object[] array = perAttPeriodList.stream().map(dy -> dy.get("id")).distinct().toArray();
        LOG.debug("PerAttPeriodRegularCleanTask.invalidPerAttPeriodId : " + Arrays.toString(array));
        List<Object> deleteList = PeriodServiceHelper.getInstance().checkPerAttPeriodReferences(array, false);
        if (CollectionUtils.isEmpty(deleteList)) {
            LOG.debug("PerAttPeriodRegularCleanTask.deleteList is empty.");
            return;
        }
        LOG.debug("PerAttPeriodRegularCleanTask.deleteList : " + deleteList.toString());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_perattperiod");
        helper.delete(deleteList.toArray());
        LOG.debug("PerAttPeriodRegularCleanTask end");
    }
}

