/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.task.upgrade.UpgradeTask;
import kd.wtc.wtbs.business.upgrade.WTCUpgradeService;
import kd.wtc.wtp.business.task.upgrade.UpgradeTaskRegister;

public class UpgradeTaskManager
extends WTCUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(UpgradeTask.class);

    public void runTask() {
        ArrayList<UpgradeTask> upgradeTasks = new ArrayList<UpgradeTask>(UpgradeTaskRegister.TASKS.size());
        LOGGER.info("UpgradeTaskManager.runTask total task size: {}", (Object)UpgradeTaskRegister.TASKS.size());
        for (Class<? extends UpgradeTask> task : UpgradeTaskRegister.TASKS) {
            try {
                UpgradeTask upgradeTask = task.newInstance();
                upgradeTasks.add(upgradeTask);
                LOGGER.info("UpgradeTaskManager.runTask task : {}, {}", (Object)task.getName(), (Object)upgradeTask.uniqueTag());
            }
            catch (Exception e) {
                throw new KDBizException("wtp runTask " + task.getName() + " newInstance error");
            }
        }
        HashSet<String> tags = new HashSet<String>(upgradeTasks.size());
        for (UpgradeTask upgradeTask : upgradeTasks) {
            if (tags.contains(upgradeTask.uniqueTag())) {
                throw new KDBizException(upgradeTask.getClass().getName() + " duplicate uniqueTag: " + upgradeTask.uniqueTag());
            }
            tags.add(upgradeTask.uniqueTag());
        }
        for (UpgradeTask upgradeTask : upgradeTasks) {
            if (this.isDeploy(upgradeTask.uniqueTag())) {
                LOGGER.info("UpgradeTaskManager.runTask {} deployed, skip...", (Object)upgradeTask.uniqueTag());
                continue;
            }
            LOGGER.info("UpgradeTaskManager.runTask {} start...", (Object)upgradeTask.uniqueTag());
            boolean success = upgradeTask.upgrade();
            LOGGER.info("UpgradeTaskManager.runTask {} end, result: {}", (Object)upgradeTask.uniqueTag(), (Object)success);
            if (success) {
                this.addDeploy(upgradeTask.uniqueTag());
                continue;
            }
            throw new KDBizException("UpgradeTaskManager runTask interrupt, task: " + upgradeTask.uniqueTag());
        }
    }

    public void upgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
    }
}

