/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.UpgradeTask;
import kd.wtc.wtbs.common.predata.wtp.PreDataAccountSteps;

public class AccountPlanUpgradeV1
implements UpgradeTask {
    private final HRBaseServiceHelper accountService = new HRBaseServiceHelper("wtp_accountplan");

    private List<DynamicObject> selectAccount() {
        DynamicObject[] accounts = this.accountService.loadDynamicObjectArray(new QFilter[]{new QFilter("1", "=", (Object)1)});
        List<DynamicObject> rets = accounts == null ? new ArrayList<DynamicObject>() : Arrays.asList(accounts);
        LOGGER.info("selectAccount rets.size: {}", (Object)rets.size());
        return rets;
    }

    private void upgradeAccount() {
        List<DynamicObject> accounts = this.selectAccount();
        int counter = 0;
        for (DynamicObject account : accounts) {
            boolean deleted = false;
            DynamicObjectCollection phaseDys = account.getDynamicObjectCollection("entryentity");
            for (DynamicObject phaseDy : phaseDys) {
                DynamicObjectCollection stepDys = phaseDy.getDynamicObjectCollection("subentryentity");
                deleted |= stepDys.removeIf(object -> PreDataAccountSteps.PD_AT_1020_S.longValue() == object.getLong("stepid.id"));
            }
            if (!deleted) continue;
            ++counter;
            this.accountService.updateOne(account);
        }
        LOGGER.info("upgradeAccount counter: {}", (Object)counter);
    }

    public String uniqueTag() {
        return "kd_1.5.211_wtp_accountplan_update.task";
    }

    public boolean upgrade() {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            this.upgradeAccount();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            try {
                tx.markRollback();
                LOGGER.error("AccountPlanUpgrade error", (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("", "wtp_accountplan upgrade exception, " + ex.getMessage()), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

