/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.account;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.UpgradeTask;
import kd.wtc.wtbs.common.predata.wtp.PreDataAccountSteps;
import kd.wtc.wtbs.common.util.WTCResManager;

public class AccountStepUpgradeV1
implements UpgradeTask {
    private final String DISCARD_NAME = ResManager.loadKDString((String)"{0}(\u5e9f\u5f03)", (String)"AttAccountUpgrade_0", (String)"wtc-wtp-business", (Object[])new Object[0]);
    private final HRBaseServiceHelper accountStepService = new HRBaseServiceHelper("wtp_accountsteps");

    private void upgradeAccountStep() {
        DynamicObject[] steps = this.accountStepService.loadDynamicObjectArray(new QFilter[]{new QFilter("boid", "=", (Object)PreDataAccountSteps.PD_AT_1020_S)});
        int counter = 0;
        for (DynamicObject step : steps) {
            if (step.getString("name").contains("(")) continue;
            step.set("enable", (Object)"0");
            ILocaleString localeName = step.getLocaleString("name");
            WTCResManager.setLocaleString((ILocaleString)localeName, (String)this.DISCARD_NAME, (String)"AttAccountUpgrade_0", (String)"wtc-wtp-business", (Object[])new Object[]{localeName});
            step.set("name", (Object)localeName.getLocaleValue());
            step.set("name", (Object)localeName);
            ++counter;
        }
        this.accountStepService.update(steps);
        LOGGER.info("upgradeAccountStep counter: {}", (Object)counter);
    }

    public String uniqueTag() {
        return "kd_1.5.211_wtp_accountsteps_update.task";
    }

    public boolean upgrade() {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            this.upgradeAccountStep();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            try {
                tx.markRollback();
                LOGGER.error("AccountStepUpgrade error", (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("", "wtp_accountsteps upgrade exception, " + ex.getMessage()), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

