/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.attend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.UpgradeTask;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class AttendConfigUpgradeV1
implements UpgradeTask {
    private final HRBaseServiceHelper configService = new HRBaseServiceHelper("wtp_attendconfig");

    private List<DynamicObject> selectConfig() {
        QFilter filters = new QFilter("attenddays", "!=", (Object)"A");
        filters.or(new QFilter("attenddaysse", "!=", (Object)"A"));
        DynamicObject[] configs = this.configService.loadDynamicObjectArray(new QFilter[]{filters});
        List<DynamicObject> rets = configs != null ? Arrays.asList(configs) : new ArrayList<DynamicObject>();
        LOGGER.info("selectConfig rets.size: {}", (Object)rets.size());
        return rets;
    }

    public String uniqueTag() {
        return "kd_1.5.211_wtp_attendconfig_update.task";
    }

    public boolean upgrade() {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            List<DynamicObject> configs = this.selectConfig();
            String shiftConditionStr = "{\"conditionList\":[{\"index\":0,\"name\":\"T01\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"shiftcondition.wtbd_daterangestd.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u5de5\u4f5c\u65e5\",\"value\":\"DS-0001\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"}],\"conditionExpressType\":\"0\",\"conditionExpressList\":[{\"name\":\"T01\"}],\"conditionExpressStr\":\"T01\"}";
            for (DynamicObject config : configs) {
                String attenddays = config.getString("attenddays");
                String attenddaysse = config.getString("attenddaysse");
                String shiftconditionjson = config.getString("shiftconditionjson_tag");
                boolean setShiftCondition = false;
                if (!"A".equals(attenddays) && !"A".equals(attenddaysse)) {
                    setShiftCondition = true;
                }
                if ("A".equals(attenddays) && WTCStringUtils.isEmpty((String)shiftconditionjson)) {
                    setShiftCondition = true;
                }
                if ("A".equals(attenddaysse) && WTCStringUtils.isEmpty((String)shiftconditionjson)) {
                    setShiftCondition = true;
                }
                config.set("attenddays", (Object)"A");
                config.set("attenddaysse", (Object)"A");
                if (setShiftCondition) {
                    config.set("shiftconditionjson_tag", (Object)"{\"conditionList\":[{\"index\":0,\"name\":\"T01\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"shiftcondition.wtbd_daterangestd.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u5de5\u4f5c\u65e5\",\"value\":\"DS-0001\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"}],\"conditionExpressType\":\"0\",\"conditionExpressList\":[{\"name\":\"T01\"}],\"conditionExpressStr\":\"T01\"}");
                }
                this.configService.updateOne(config);
                LOGGER.info("upgrade {}, setShiftCondition: {}", (Object)config.getString("name"), (Object)setShiftCondition);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            try {
                tx.markRollback();
                LOGGER.error("AttAccountUpgrade error", (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("", "wtp_attendconfig upgrade exception, " + ex.getMessage()), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

