/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.attend;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DBRoute;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.predata.wtp.PreDataAttendConfig;
import kd.wtc.wtbs.common.predata.wtp.PreDataAttendRule;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.ruleenging.RulePreviewUtil;

public class AttendRuleTimeTaskService {
    private static final Map<String, String> TRANS_RANGE_DATE = new HashMap<String, String>(16);

    public void convertRuleDyToRuleCal(DynamicObject ruleDy, DynamicObject ruleCalDy, int seq, DynamicObject[] dataRangeDys, Map<Long, Long> ruleEntryIdAndCustomAttId) {
        ILocaleString localeString = ruleDy.getLocaleString("name");
        String localeValueZhCn = localeString.getLocaleValue_zh_CN();
        String localeValueZhTw = localeString.getLocaleValue_zh_TW();
        String localeValueEn = localeString.getLocaleValue_en();
        LocaleString ruleLocalString = new LocaleString();
        if (!HRStringUtils.isEmpty((String)localeValueZhCn)) {
            ruleLocalString.setLocaleValue_zh_CN(localeValueZhCn + "_" + seq);
        }
        if (!HRStringUtils.isEmpty((String)localeValueZhTw)) {
            ruleLocalString.setLocaleValue_zh_TW(localeValueZhTw + "_" + seq);
        }
        if (!HRStringUtils.isEmpty((String)localeValueEn)) {
            ruleLocalString.setLocaleValue_en(localeValueEn + "_" + seq);
        }
        ruleCalDy.set("calculatename", (Object)ruleLocalString);
        ruleCalDy.set("attendconfig_id", (Object)PreDataAttendConfig.PD_1010_S);
        DynamicObject dataRangeDy = null;
        for (DynamicObject rangeDy : dataRangeDys) {
            if (rangeDy.getLong("basedataid") != ruleDy.getLong("id")) continue;
            dataRangeDy = rangeDy;
            break;
        }
        if (dataRangeDy != null) {
            String conditions = dataRangeDy.getString("conditions");
            for (Map.Entry<String, String> entry : TRANS_RANGE_DATE.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                conditions = conditions.replaceAll(key, val);
            }
            ruleCalDy.set("daterangecondition", (Object)conditions);
            String conditionPreviewStr = RulePreviewUtil.getConditionPreviewStr(conditions);
            LocaleString rangeDes = new LocaleString();
            rangeDes.setLocaleValue_zh_CN(conditionPreviewStr);
            ruleCalDy.set("daterangedesc", (Object)rangeDes);
        }
        ruleCalDy.set("attendancetime_id", (Object)PreDataAttendRule.PD_AT_1010);
        ruleCalDy.set("attendanceday_id", (Object)PreDataAttendRule.PD_AT_1030);
        MulBasedataDynamicObjectCollection mulColl = new MulBasedataDynamicObjectCollection();
        DynamicObjectCollection entryDys = ruleDy.getDynamicObjectCollection("attendruleentity");
        MulBasedataProp prop = (MulBasedataProp)ruleCalDy.getDynamicObjectType().getProperty("attcustimes");
        for (DynamicObject entryDy : entryDys) {
            Long cusAttId = ruleEntryIdAndCustomAttId.get(entryDy.getLong("id"));
            if (cusAttId == null || cusAttId == 0L) continue;
            DynamicObject newDy = new DynamicObject(prop.getDynamicCollectionItemPropertyType());
            newDy.set("fbasedataid_id", (Object)cusAttId);
            mulColl.add(newDy);
        }
        if (!mulColl.isEmpty()) {
            ruleCalDy.set("attcustimes", (Object)mulColl);
        }
    }

    public DynamicObject[] getDataRangeData(Set<Long> pkId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_daterange");
        QFilter pageFilter = new QFilter("metanumber", "=", (Object)"wtp_attendrule");
        QFilter pkIdFilter = new QFilter("basedataid", "in", pkId);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{pageFilter, pkIdFilter});
    }

    public Map<Long, Long> getEntryIdAndCustomAttId(Set<Long> ruleIds) {
        if (CollectionUtils.isEmpty(ruleIds)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)ruleIds.size());
        Set ruleStrIds = ruleIds.stream().map(ruleId -> ruleId + "").collect(Collectors.toSet());
        String ids = String.join((CharSequence)",", ruleStrIds);
        String sql = "SELECT fentryid, fseq, fattcustimeid, fentryboid, fid FROM t_wtp_attendruleentry where fid in (" + ids + ");";
        HRBaseServiceHelper ruleService = new HRBaseServiceHelper("wtp_attendrule");
        IDataEntityType dataEntityType = ruleService.generateEmptyDynamicObject().getDataEntityType();
        DBRoute dbRoute = DBRoute.of((String)dataEntityType.getDBRouteKey());
        DataSet ruleEntry = HRDBUtil.queryDataSet((String)"getEntryIdAndCustomAttId", (DBRoute)dbRoute, (String)sql, (Object[])new Object[0]);
        for (Row next : ruleEntry) {
            result.put(next.getLong("fentryid"), next.getLong("fattcustimeid"));
        }
        return result;
    }

    static {
        TRANS_RANGE_DATE.put("simpledaterange.wtbd_simpledaterangestd", "shiftcondition.wtbd_daterangestd");
    }
}

