/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.attend;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtp.business.task.upgrade.attend.AttendRuleTimeTaskService;

public class AttendRuleUpgradeService {
    private final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_attendrule");

    public void upgrade() {
        List<DynamicObject> needUpdateRule = this.queryNeedUpdateRule();
        if (CollectionUtils.isEmpty(needUpdateRule)) {
            return;
        }
        AttendRuleTimeTaskService service = new AttendRuleTimeTaskService();
        Set<Long> ruleIdSet = needUpdateRule.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        Map<Long, Long> ruleEntryIAndAttCusTimeId = service.getEntryIdAndCustomAttId(ruleIdSet);
        Set<Long> id = needUpdateRule.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] dataRangeData = service.getDataRangeData(id);
        for (DynamicObject ruleDy : needUpdateRule) {
            DynamicObjectCollection entry = ruleDy.getDynamicObjectCollection("attendruleentity");
            if (entry.isEmpty()) {
                DynamicObject entryDy = entry.addNew();
                entryDy.set("seq", (Object)1);
            }
            for (DynamicObject ruleCalDy : entry) {
                service.convertRuleDyToRuleCal(ruleDy, ruleCalDy, ruleCalDy.getInt("seq"), dataRangeData, ruleEntryIAndAttCusTimeId);
            }
        }
        this.serviceHelper.save(needUpdateRule.toArray(new DynamicObject[0]));
    }

    private List<DynamicObject> queryNeedUpdateRule() {
        DynamicObject[] ruleDys;
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        Date timeLine = new Date();
        QFilter timeQFilter = new QFilter("createtime", "<=", (Object)timeLine);
        QFilter isSysQFilter = new QFilter("issyspreset", "=", (Object)Boolean.FALSE);
        block0: for (DynamicObject attRuleDy : ruleDys = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{timeQFilter, isSysQFilter})) {
            DynamicObjectCollection entry = attRuleDy.getDynamicObjectCollection("attendruleentity");
            if (entry.isEmpty()) {
                result.add(attRuleDy);
                continue;
            }
            for (DynamicObject entryDy : entry) {
                if (!HRStringUtils.isEmpty((String)entryDy.getString("calculatename"))) continue;
                result.add(attRuleDy);
                continue block0;
            }
        }
        return result;
    }
}

