/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.attend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.wtc.wtbs.business.task.upgrade.UpgradeTask;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCResManager;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;

public class AttendRuleUpgradeV1
implements UpgradeTask {
    private static final Set<String> ignores = new HashSet<String>();
    private final String NEWRULE_NAME_SUFFIX = ResManager.loadKDString((String)"{0}_\u51fa\u52e4{1}", (String)"AttendRuleUpgrade_1", (String)"wtc-wtp-business", (Object[])new Object[0]);
    private final String NEWRULE_DESC = ResManager.loadKDString((String)"\u7531\u51fa\u52e4\u89c4\u5219\u201c{0}\u201d({1})\u6570\u636e\u5347\u7ea7\u4ea7\u751f\u3002", (String)"AttendRuleUpgrade_0", (String)"wtc-wtp-business", (Object[])new Object[0]);
    private final HRBaseServiceHelper ruleService = new HRBaseServiceHelper("wtp_attendrule");
    private int numberCounter = 1001;
    private String insertUSql = "INSERT INTO t_wtp_attendrule_u (fdataid, fuseorgid) VALUES(?, ?);";
    private String selectUSql = "SELECT fuseorgid FROM t_wtp_attendrule_u where fdataid = ?";
    private final List<RuleHisWrapper> iuRules = new ArrayList<RuleHisWrapper>();

    private List<DynamicObject> selectRule() {
        QFilter[] filters = new QFilter[]{new QFilter("attendconfigrule", "=", (Object)0), new QFilter("attendancetimerule", "=", (Object)0), new QFilter("attendancedayrule", "=", (Object)0)};
        DynamicObject[] data = this.ruleService.loadDynamicObjectArray(filters);
        List<DynamicObject> rets = data != null ? Arrays.asList(data) : new ArrayList<DynamicObject>();
        LOGGER.info("selectRule rets.size: {}", (Object)rets.size());
        return rets;
    }

    private List<RuleHisWrapper> selectUpgradeRuleWrapper() {
        List<DynamicObject> allRules = this.selectRule();
        if (WTCCollections.isEmpty(allRules)) {
            return Collections.emptyList();
        }
        ArrayList<RuleHisWrapper> ruleHisList = new ArrayList<RuleHisWrapper>(allRules.size());
        ArrayList<String> ruleNames = new ArrayList<String>();
        Map<Long, List<DynamicObject>> partRules = allRules.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        for (Map.Entry<Long, List<DynamicObject>> rulesEntry : partRules.entrySet()) {
            long boid = rulesEntry.getKey();
            List<DynamicObject> rules = rulesEntry.getValue();
            RuleHisWrapper ruleHis = new RuleHisWrapper(false);
            ruleHis.boid = boid;
            ruleHis.rules = rules;
            for (DynamicObject dy2 : ruleHis.rules) {
                boolean fiscurrentversion = dy2.getBoolean("iscurrentversion");
                if (!fiscurrentversion) continue;
                ruleHis.boRule = dy2;
                ruleNames.add(dy2.getString("name"));
                break;
            }
            ruleHisList.add(ruleHis);
        }
        LOGGER.info("selectUpgradeRuleWrapper ruleNames.size: {}, ruleNames: {}", (Object)ruleNames.size(), ruleNames);
        LOGGER.info("selectUpgradeRuleWrapper ruleHisList.size: {}", (Object)ruleHisList.size());
        return ruleHisList;
    }

    private String concatEntryKey(DynamicObject entry) {
        String key = entry.getLong("attendconfig.id") + "-" + entry.getLong("attendancetime.id") + "-" + entry.getLong("attendanceday.id");
        return key;
    }

    private boolean isOldEntry(DynamicObjectCollection entryDys) {
        for (DynamicObject entry : entryDys) {
            if (entry.containsProperty("attendconfig") && entry.containsProperty("attendancetime") && entry.containsProperty("attendanceday")) continue;
            return false;
        }
        return true;
    }

    private void setRuleObjectNewFieldValue(RuleHisWrapper ruleHis, DynamicObject firstEntry) {
        for (DynamicObject rule : ruleHis.rules) {
            rule.set("attendconfigrule", firstEntry.get("attendconfig"));
            rule.set("attendancetimerule", firstEntry.get("attendancetime"));
            rule.set("attendancedayrule", firstEntry.get("attendanceday"));
        }
    }

    private void setNewBoRuleValue(DynamicObject boRule, DynamicObject newBo, boolean moreOne, List<DynamicObject> entryGroupMap, int nameCounter) {
        Date bsed = boRule.getDate("bsed");
        Date blsed = boRule.getDate("bsled");
        Object[] params = new Object[2];
        ILocaleString newLocaleName = newBo.getLocaleString("name");
        ILocaleString localeName = boRule.getLocaleString("name");
        params[0] = localeName;
        params[1] = moreOne ? String.valueOf(nameCounter) : "";
        WTCResManager.setLocaleString((ILocaleString)newLocaleName, (String)this.NEWRULE_NAME_SUFFIX, (String)"AttendRuleUpgrade_1", (String)"wtc-wtp-business", (Object[])params);
        newBo.set("name", (Object)newLocaleName.getLocaleValue());
        newBo.set("name", (Object)newLocaleName);
        newBo.set("number", (Object)("ATUP_" + this.numberCounter++));
        newBo.set("bsled", (Object)blsed);
        newBo.set("bsed", (Object)bsed);
        newBo.set("firstbsed", (Object)boRule.getDate("firstbsed"));
        newBo.set("bred", (Object)boRule.getDate("bred"));
        localeName = boRule.getLocaleString("name");
        ILocaleString newLocaleDesription = newBo.getLocaleString("description");
        WTCResManager.setLocaleString((ILocaleString)newLocaleDesription, (String)this.NEWRULE_DESC, (String)"AttendRuleUpgrade_0", (String)"wtc-wtp-business", (Object[])new Object[]{localeName, boRule.getString("number")});
        newBo.set("description", (Object)newLocaleDesription.getLocaleValue());
        newBo.set("description", (Object)newLocaleDesription);
        newBo.set("enable", (Object)"0");
        newBo.set("status", (Object)"C");
        newBo.set("datastatus", (Object)"1");
        newBo.set("attendconfigrule", WTCCollectionIndexUtil.getEleFromList(entryGroupMap, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList(entryGroupMap, (int)0).get()).get("attendconfig") : null);
        newBo.set("attendancetimerule", WTCCollectionIndexUtil.getEleFromList(entryGroupMap, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList(entryGroupMap, (int)0).get()).get("attendancetime") : null);
        newBo.set("attendancedayrule", WTCCollectionIndexUtil.getEleFromList(entryGroupMap, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList(entryGroupMap, (int)0).get()).get("attendanceday") : null);
    }

    private void setNewEntry(DynamicObject oldEntry, DynamicObject newEntry, long entryBoid, int seq) {
        HRDynamicObjectUtils.copy((DynamicObject)oldEntry, (DynamicObject)newEntry);
        newEntry.set("entryboid", (Object)entryBoid);
        newEntry.set("seq", (Object)seq);
        MulBasedataProp newProp = (MulBasedataProp)newEntry.getDynamicObjectType().getProperty("attcustimes");
        MulBasedataDynamicObjectCollection mulColl = new MulBasedataDynamicObjectCollection();
        DynamicObjectCollection condAttItems = oldEntry.getDynamicObjectCollection("attcustimes");
        for (DynamicObject item : condAttItems) {
            DynamicObject newDy = new DynamicObject(newProp.getDynamicCollectionItemPropertyType());
            newDy.set("fbasedataid", item.get("fbasedataid"));
            newDy.set("fbasedataid_id", (Object)item.getLong("fbasedataid.id"));
            mulColl.add(newDy);
        }
        if (!mulColl.isEmpty()) {
            newEntry.set("attcustimes", (Object)mulColl);
        }
    }

    private List<Long> selectUseOrgs(long boid) {
        ArrayList<Long> results = new ArrayList<Long>();
        if (boid == 0L) {
            return results;
        }
        try {
            HRDBUtil.query((DBRoute)DBRoute.of((String)"wtc"), (String)this.selectUSql, (Object[])new Object[]{boid}, resultSet -> {
                while (resultSet.next()) {
                    results.add(resultSet.getLong("fuseorgid"));
                }
                return results;
            });
            return results;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return results;
        }
    }

    private List<RuleHisWrapper> newRuleObject(DynamicObject boRule, Map<String, List<DynamicObject>> entryGroupMap) {
        ArrayList<RuleHisWrapper> rules = new ArrayList<RuleHisWrapper>(entryGroupMap.size());
        int nameCounter = 0;
        for (Map.Entry<String, List<DynamicObject>> entriesGroupEntry : entryGroupMap.entrySet()) {
            ++nameCounter;
            List<DynamicObject> groupEntries = entriesGroupEntry.getValue();
            if (CollectionUtils.isEmpty(groupEntries) || groupEntries.size() <= 0) continue;
            RuleHisWrapper ruleHis = new RuleHisWrapper(true);
            rules.add(ruleHis);
            DynamicObject newBo = this.ruleService.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)boRule, (DynamicObject)newBo, ignores, (boolean)true);
            this.setNewBoRuleValue(boRule, newBo, entryGroupMap.size() > 1, groupEntries, nameCounter);
            long boid = ID.genLongId();
            newBo.set("boid", (Object)boid);
            newBo.set("iscurrentversion", (Object)"1");
            long cvId = ID.genLongId();
            newBo.set("id", (Object)boid);
            newBo.set("sourcevid", (Object)cvId);
            newBo.set("masterid", (Object)boid);
            DynamicObject cvRule = this.ruleService.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)newBo, (DynamicObject)cvRule, ignores, (boolean)true);
            cvRule.set("iscurrentversion", (Object)"0");
            cvRule.set("sourcevid", (Object)0);
            cvRule.set("id", (Object)cvId);
            cvRule.set("masterid", (Object)cvId);
            cvRule.set("hisversion", (Object)"V0001");
            List<Long> useOrgs = this.selectUseOrgs(boRule.getLong("boid"));
            DynamicObjectCollection newEntries = newBo.getDynamicObjectCollection("attendruleentity");
            DynamicObjectCollection cvEntries = cvRule.getDynamicObjectCollection("attendruleentity");
            for (int i = 0; i < groupEntries.size(); ++i) {
                DynamicObject oldEntry = groupEntries.get(i);
                long entryboid = ID.genLongId();
                DynamicObject entry = newEntries.addNew();
                this.setNewEntry(oldEntry, entry, entryboid, i + 1);
                entry.set("id", (Object)entryboid);
                DynamicObject cvEntry = cvEntries.addNew();
                this.setNewEntry(oldEntry, cvEntry, entryboid, i + 1);
            }
            ruleHis.boRule = newBo;
            ruleHis.rules.add(newBo);
            ruleHis.rules.add(cvRule);
            ruleHis.useOrgs = useOrgs;
        }
        return rules;
    }

    private void removeRuleEntry(RuleHisWrapper ruleHis, DynamicObject boRule, String firstEntryKey) {
        DynamicObjectCollection entries = boRule.getDynamicObjectCollection("attendruleentity");
        entries.removeIf(stringObjectMap -> !this.concatEntryKey((DynamicObject)stringObjectMap).equals(firstEntryKey));
        long sourcevid = boRule.getLong("sourcevid");
        DynamicObject cvRule = null;
        for (DynamicObject rule : ruleHis.rules) {
            if (rule.getLong("id") != sourcevid) continue;
            cvRule = rule;
            break;
        }
        if (cvRule == null) {
            LOGGER.warn("bad rule, sourcevid: {}, ruleHis: {}", (Object)sourcevid, (Object)ruleHis);
        } else {
            entries = cvRule.getDynamicObjectCollection("attendruleentity");
            entries.removeIf(stringObjectMap -> !this.concatEntryKey((DynamicObject)stringObjectMap).equals(firstEntryKey));
        }
    }

    private void prepareAttendRule(RuleHisWrapper ruleHis) {
        DynamicObject boRule = ruleHis.boRule;
        if (boRule == null) {
            LOGGER.warn("upgradeAtttendRule no current version, {}", (Object)ruleHis);
            return;
        }
        DynamicObjectCollection entryDys = boRule.getDynamicObjectCollection("attendruleentity");
        if (WTCCollections.isEmpty((Collection)entryDys)) {
            LOGGER.warn("upgradeAtttendRule bo no entry, {}", (Object)ruleHis);
            return;
        }
        if (!this.isOldEntry(entryDys)) {
            return;
        }
        entryDys.sort(Comparator.comparingInt(o -> o.getInt("seq")));
        DynamicObject firstEntry = (DynamicObject)entryDys.get(0);
        String firstEntryKey = this.concatEntryKey(firstEntry);
        LOGGER.info("{}, firstEntryKey: {}", (Object)boRule.getString("name"), (Object)firstEntryKey);
        Map<String, List<DynamicObject>> entryGroup = entryDys.stream().collect(Collectors.groupingBy(this::concatEntryKey));
        LOGGER.info("{}, entryGroup.size: {}", (Object)boRule.getString("name"), (Object)entryGroup.size());
        entryGroup.remove(firstEntryKey);
        this.setRuleObjectNewFieldValue(ruleHis, firstEntry);
        if (entryGroup.size() > 0) {
            this.removeRuleEntry(ruleHis, boRule, firstEntryKey);
        }
        this.iuRules.add(ruleHis);
        String status = boRule.getString("status");
        if (entryGroup.size() > 0 && "C".equals(status)) {
            List<RuleHisWrapper> newRuleHisList = this.newRuleObject(boRule, entryGroup);
            this.iuRules.addAll(newRuleHisList);
        }
    }

    private void saveUseOrgs(RuleHisWrapper iuRule) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(iuRule.rules.size());
        if (WTCCollections.isEmpty(iuRule.useOrgs)) {
            return;
        }
        for (DynamicObject rule : iuRule.rules) {
            for (Long useOrg : iuRule.useOrgs) {
                Object[] org = new Object[]{rule.getLong("id"), useOrg};
                params.add(org);
            }
        }
        if (params.size() > 0) {
            try {
                HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"wtc"), (String)this.insertUSql, params);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void insertOrUpdateAttendRule() {
        int insertCount = 0;
        int updateCount = 0;
        for (RuleHisWrapper iuRule : this.iuRules) {
            if (iuRule.isNew) {
                this.ruleService.save(iuRule.rules.toArray(new DynamicObject[0]));
                this.saveUseOrgs(iuRule);
                insertCount += iuRule.rules.size();
                continue;
            }
            this.ruleService.update(iuRule.rules.toArray(new DynamicObject[0]));
            updateCount += iuRule.rules.size();
        }
        LOGGER.info("insertOrUpdateAttendRule done, insertCount: {}, updateCount: {}", (Object)insertCount, (Object)updateCount);
    }

    public String uniqueTag() {
        return "kd_1.5.211_wtp_attendrule_update.task";
    }

    public boolean upgrade() {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            List<RuleHisWrapper> ruleWrappers = this.selectUpgradeRuleWrapper();
            if (WTCCollections.isEmpty(ruleWrappers)) {
                boolean bl = true;
                return bl;
            }
            for (RuleHisWrapper ruleWrapper : ruleWrappers) {
                this.prepareAttendRule(ruleWrapper);
            }
            this.insertOrUpdateAttendRule();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            try {
                tx.markRollback();
                LOGGER.error("AttendRuleUpgrade error", (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("", "wtp_attendrule upgrade exception, " + ex.getMessage()), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    static {
        ignores.add("attendruleentity");
        ignores.add("id");
        ignores.add("masterid");
        ignores.add("sourcevid");
    }

    private static class RuleHisWrapper {
        boolean isNew;
        long boid = 0L;
        DynamicObject boRule;
        List<Long> useOrgs;
        List<DynamicObject> rules = new ArrayList<DynamicObject>();

        public RuleHisWrapper(boolean isNew) {
            this.isNew = isNew;
            if (isNew) {
                this.useOrgs = new ArrayList<Long>();
            }
        }

        public String toString() {
            return "RuleHisWrapper{boid=" + this.boid + ", boRule=" + this.boRule + ", rules=" + this.rules + '}';
        }
    }
}

