/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.attfile;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class AttFileStartDateUpgradeImpl
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(AttFileStartDateUpgradeImpl.class);
    private HRBaseServiceHelper serviceHelperHelper = new HRBaseServiceHelper("wtp_attfilebase");

    protected String getJobId() {
        return "4088Y7136EMJ";
    }

    protected String getScheduleId() {
        return "408A9NKUBKQN";
    }

    protected boolean process() {
        DynamicObject[] query;
        LOG.info("AttFileStartDateUpgradeImpl process start ...");
        HashSet fileIdList = Sets.newHashSetWithExpectedSize((int)1000);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dataSet = this.serviceHelperHelper.queryDataSet(((Object)((Object)this)).getClass().getName(), "id,startdate");){
            while (dataSet.hasNext()) {
                int secondsOfDay;
                Row next = dataSet.next();
                Date date = next.getDate("startdate");
                if (date == null || (secondsOfDay = WTCDateUtils.getSecondsOfDay((Date)date)) <= 0) continue;
                fileIdList.add(next.getLong("id"));
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        if (WTCCollections.isNotEmpty((Collection)fileIdList) && (query = this.serviceHelperHelper.query("id,startdate", new QFilter[]{new QFilter("id", "in", (Object)fileIdList)})) != null && query.length > 0) {
            for (DynamicObject dynamicObject : query) {
                Date startDate = dynamicObject.getDate("startdate");
                if (startDate == null) continue;
                dynamicObject.set("startdate", (Object)WTCDateUtils.getZeroDate((Date)startDate));
            }
            this.serviceHelperHelper.update(query);
        }
        LOG.info("AttFileStartDateUpgradeImpl process end ...");
        return true;
    }
}

