/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.attperson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class AttPersonFyUpgrade
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(AttPersonFyUpgrade.class);
    private static final HRBaseServiceHelper attPersonHelper = new HRBaseServiceHelper("wtp_attendperson");
    private static final HRBaseServiceHelper fyServiceHelper = new HRBaseServiceHelper("wtp_fertilityinfo");

    protected String getJobId() {
        return "49E5ROVKZQ+X";
    }

    protected String getScheduleId() {
        return "49E5VXDQLIRW";
    }

    protected boolean process() {
        return true;
    }

    protected boolean process(Map<String, Object> map) {
        LOG.info("AttPersonFyUpgrade process start ...");
        int action = this.upgradeAction(map);
        LOG.info("AttPersonFyUpgrade process {} end ...", (Object)action);
        return true;
    }

    public int upgradeAction(Map<String, Object> paramMap) {
        QFilter[] qFilter = new QFilter[0];
        DynamicObject[] query = attPersonHelper.query("id", qFilter);
        List personListIds = Arrays.stream(query).mapToLong(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"id")).boxed().collect(Collectors.toList());
        if (WTCCollections.isEmpty(personListIds)) {
            return 0;
        }
        int batchSize = paramMap.get("batchSize") == null ? 1000 : Integer.parseInt((String)paramMap.get("batchSize"));
        List partition = Lists.partition(personListIds, (int)batchSize);
        ArrayList resultDyData = Lists.newArrayListWithExpectedSize((int)personListIds.size());
        ArrayList insertDyData = Lists.newArrayListWithExpectedSize((int)personListIds.size());
        ArrayList updateDyData = Lists.newArrayListWithExpectedSize((int)personListIds.size());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"wtp_fertilityinfo");
        for (List currentQueryIds : partition) {
            List map = (List)WTCServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPersonAttachs", (Object[])new Object[]{currentQueryIds, null, "hrpi_fertilityinfo"});
            DynamicObject[] existDys = this.queryFyList(currentQueryIds);
            Map existDyMap = Arrays.stream(existDys).collect(Collectors.toMap(existDy -> existDy.getLong("id"), Function.identity(), (a, b) -> a));
            for (Map objectMap : map) {
                Object id = objectMap.get("id");
                DynamicObject fertilityInfo = new DynamicObject((DynamicObjectType)dataEntityType);
                fertilityInfo.set("id", objectMap.get("id"));
                fertilityInfo.set("person", objectMap.get("person_id"));
                DynamicObject attPersonDy = attPersonHelper.generateEmptyDynamicObject();
                attPersonDy.set("id", objectMap.get("person_id"));
                fertilityInfo.set("attperson", (Object)attPersonDy);
                fertilityInfo.set("fyid", objectMap.get("id"));
                fertilityInfo.set("childrennumber", objectMap.get("childrennumber"));
                fertilityInfo.set("birthday", objectMap.get("birthday"));
                fertilityInfo.set("procreatmode", objectMap.get("procreatmode_id"));
                DynamicObject dynamicObject = (DynamicObject)existDyMap.get(id);
                if (dynamicObject != null) {
                    WtbsBusinessUtils.propertyCopyToDynamicObject((Object)fertilityInfo, (DynamicObject)dynamicObject);
                    updateDyData.add(dynamicObject);
                    continue;
                }
                insertDyData.add(fertilityInfo);
            }
            if (!CollectionUtils.isEmpty((Collection)insertDyData)) {
                fyServiceHelper.save(insertDyData.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)updateDyData)) {
                fyServiceHelper.update(updateDyData.toArray(new DynamicObject[0]));
            }
            resultDyData.addAll(insertDyData);
            resultDyData.addAll(updateDyData);
        }
        return resultDyData.size();
    }

    private DynamicObject[] queryFyList(List<Long> idList) {
        QFilter[] fyIdFilters = new QFilter[]{new QFilter("attperson", "in", idList)};
        return fyServiceHelper.loadDynamicObjectArray(fyIdFilters);
    }
}

