/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.attstateinfo;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;

public class AttStateInfoUpgradeImpl
extends AbstractWtcTaskUpgrade {
    private static final Log LOGGER = LogFactory.getLog(AttStateInfoUpgradeImpl.class);
    private static final String SELECT_WTTE_INFO = "select fid ,fcreatetime ,fcreatorid ,fmodifytime ,fmodifierid ,ffrozenstartdate ,ffrozenenddate ,faccountto , flockto ,fstorageto ,fallowreaccounttime ,ffileboid ,fpersonid from t_wtte_info;";
    private static final String SELECT_WTTE_INFOHIS = "select fvid,fid ,fcreatetime ,fcreatorid,fmodifierid,fmodifytime,fenable,'C',fdatastatus,ffileboid ,fallowreaccounttime from t_wtte_infohis;";
    private static final String INSERT_INTO_ATTSTATEINFO = "insert into t_wtp_attstateinfo (fid ,fcreatetime ,fcreatorid ,fmodifytime ,fmodifierid ,ffrozenstartdate ,ffrozenenddate ,faccountto , flockto ,fstorageto , fallowreaccounttime ,ffileboid ,fpersonid) values(?,?,?,?,?,?,?,?,?,?,?,?,?);";
    private static final String INSERT_INTO_ATTINFOCONFIG = "insert into t_wtp_attinfoconf (fid,fstatus,fcreatorid,fmodifierid,fenable ,fcreatetime ,fmodifytime ,ffileboid,fallowreaccounttime) values(?,?,?,?,?,?,?,?,?);";
    private static final String INSERT_INTO_ATTINFOCONFIGHIS = "insert into t_wtp_attinfoconfhis (fvid,fid ,fcreatetime ,fcreatorid ,fmodifierid,fmodifytime,fenable,fstatus,fdatastatus,ffileboid ,fallowreaccounttime) values(?,?,?,?,?,?,?,?,?,?,?);";
    private static final String SELECT_ATTSTATEINFO = "select fid,ffileboid from t_wtp_attstateinfo;";

    protected String getJobId() {
        return "3E36H0GVLO/F";
    }

    protected String getScheduleId() {
        return "3E36NUJH20OE";
    }

    public boolean process() {
        DBRoute wtteDbRoute = new DBRoute("wtc.wtte");
        DBRoute wtpDbRoute = new DBRoute("wtc");
        try (TXHandle ignored = TX.requiresNew();
             DataSet wtteInfoDataSet = HRDBUtil.queryDataSet((String)"AttStateInfoUpgrade", (DBRoute)wtteDbRoute, (String)SELECT_WTTE_INFO, (Object[])new Object[0]);
             DataSet wtteInfoHisDataSet = HRDBUtil.queryDataSet((String)"AttStateInfoUpgrade", (DBRoute)wtteDbRoute, (String)SELECT_WTTE_INFOHIS, (Object[])new Object[0]);
             DataSet attStateInfoDataSet = HRDBUtil.queryDataSet((String)"AttStateInfo", (DBRoute)wtpDbRoute, (String)SELECT_ATTSTATEINFO, (Object[])new Object[0]);){
            this.processAndSaveData(wtteInfoDataSet, wtteInfoHisDataSet, attStateInfoDataSet);
        }
        catch (Exception exception) {
            LOGGER.error("AttStateInfoUpgrade.upgradeAction error", (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("AttStateInfoUpgradeImpl.process", exception.getMessage()), new Object[0]);
        }
        return true;
    }

    private void processAndSaveData(DataSet wtteInfoDataSet, DataSet wtteInfoHisDataSet, DataSet attStateInfoDataSet) {
        Long id;
        Long fileBoid;
        Row next;
        HashSet<Long> attFileBoIdSet = new HashSet<Long>(16);
        while (attStateInfoDataSet.hasNext()) {
            Row next2 = attStateInfoDataSet.next();
            Long fileBoId = next2.getLong("ffileboid");
            attFileBoIdSet.add(fileBoId);
        }
        ArrayList<Object[]> attStateInfoParamList = new ArrayList<Object[]>(100);
        ArrayList<Object[]> attInfoConfigParamList = new ArrayList<Object[]>(100);
        ArrayList<Object[]> attInfoConfigHisParamList = new ArrayList<Object[]>(100);
        while (wtteInfoDataSet.hasNext()) {
            next = wtteInfoDataSet.next();
            fileBoid = next.getLong("ffileboid");
            if (attFileBoIdSet.contains(fileBoid)) continue;
            id = next.getLong("fid");
            Date createTime = next.getDate("fcreatetime");
            Long creator = next.getLong("fcreatorid");
            Date modifyTime = next.getDate("fmodifytime");
            Long modifier = next.getLong("fmodifierid");
            Date frozenStartDate = next.getDate("ffrozenstartdate");
            Date frozenEndDate = next.getDate("ffrozenenddate");
            Date accountTo = next.getDate("faccountto");
            Date lockTo = next.getDate("flockto");
            Date storageTo = next.getDate("fstorageto");
            Date allowReAccountTime = next.getDate("fallowreaccounttime");
            Long personId = next.getLong("fpersonid");
            attStateInfoParamList.add(new Object[]{id, createTime, creator, modifyTime, modifier, frozenStartDate, frozenEndDate, accountTo, lockTo, storageTo, allowReAccountTime, fileBoid, personId});
            attInfoConfigParamList.add(new Object[]{id, "C", creator, modifier, "1", createTime, modifyTime, fileBoid, allowReAccountTime});
        }
        while (wtteInfoHisDataSet.hasNext()) {
            next = wtteInfoHisDataSet.next();
            fileBoid = next.getLong("ffileboid");
            if (attFileBoIdSet.contains(fileBoid)) continue;
            id = next.getLong("fid");
            Long vid = next.getLong("fvid");
            Date createTime = next.getDate("fcreatetime");
            Long creator = next.getLong("fcreatorid");
            Date modifyTime = next.getDate("fmodifytime");
            Long modifier = next.getLong("fmodifierid");
            String dataStatus = next.getString("fdatastatus");
            Date allowReAccountTime = next.getDate("fallowreaccounttime");
            attInfoConfigHisParamList.add(new Object[]{vid, id, createTime, creator, modifier, modifyTime, "1", "C", dataStatus, fileBoid, allowReAccountTime});
        }
        this.batchSaveData(INSERT_INTO_ATTSTATEINFO, attStateInfoParamList);
        this.batchSaveData(INSERT_INTO_ATTINFOCONFIG, attInfoConfigParamList);
        this.batchSaveData(INSERT_INTO_ATTINFOCONFIGHIS, attInfoConfigHisParamList);
    }

    private void batchSaveData(String saveSql, List<Object[]> paramList) {
        if (!CollectionUtils.isEmpty(paramList)) {
            DBRoute dbRoute = new DBRoute("wtc");
            HRDBUtil.executeBatch((DBRoute)dbRoute, (String)saveSql, paramList);
        }
    }
}

