/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.billcommon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.applybill.ruleengine.PlanRuleEngineHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class BillUpgradeCommonService {
    public List<DynamicObject> queryNeedUpdatePlan(String entity, String fieldNewRuleF7) {
        HRBaseServiceHelper planServiceHelper = new HRBaseServiceHelper(entity);
        Date timeLine = new Date();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        QFilter timeQFilter = new QFilter("createtime", "<=", (Object)timeLine);
        QFilter isSysQFilter = new QFilter("issyspreset", "=", (Object)Boolean.FALSE);
        DynamicObject[] planDys = planServiceHelper.loadDynamicObjectArray(new QFilter[]{timeQFilter, isSysQFilter});
        if (planDys.length == 0) {
            return Collections.emptyList();
        }
        HashSet planIds = Sets.newHashSetWithExpectedSize((int)planDys.length);
        for (DynamicObject planDy : planDys) {
            planIds.add(planDy.getLong("id"));
        }
        List ruleAssociationDyList = PlanRuleEngineHelper.getPolicyByPlanIds((Collection)planIds);
        Set engineePlanVidSet = ruleAssociationDyList.stream().map(ass -> ass.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject planDy : planDys) {
            Long planId = planDy.getLong("id");
            DynamicObject ruleF7 = planDy.getDynamicObject(fieldNewRuleF7);
            if (engineePlanVidSet.contains(planId) || ruleF7 != null) continue;
            result.add(planDy);
        }
        return result;
    }

    public Map<Long, DynamicObject> getCurrentRuleByIds(Set<Long> ruleBoIds, String ruleEntity) {
        if (CollectionUtils.isEmpty(ruleBoIds)) {
            return Collections.emptyMap();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ruleEntity);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter boIdFilter = new QFilter("boid", "in", ruleBoIds);
        DynamicObject[] ruleRuleDys = serviceHelper.loadDynamicObjectArray(new QFilter[]{currentFilter, boIdFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)ruleRuleDys.length);
        for (DynamicObject ruleDy : ruleRuleDys) {
            result.put(ruleDy.getLong("id"), ruleDy);
        }
        return result;
    }

    public DynamicObject genRuleCommonInfo(String ruleEntity, DynamicObject planDy, Long newRuleVid) {
        if (planDy == null) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ruleEntity);
        DynamicObject newRule = serviceHelper.generateEmptyDynamicObject();
        String hisversion = planDy.getString("hisversion");
        Date bsed = planDy.getDate("bsed");
        Date blsed = planDy.getDate("bsled");
        hisversion = HRStringUtils.isEmpty((String)hisversion) ? System.currentTimeMillis() + "" : hisversion;
        String mark = "_" + WTCDateUtils.date2Str((Date)bsed, (String)"yyyy-MM-dd") + "_" + hisversion;
        ILocaleString localeString = planDy.getLocaleString("name");
        String localeValueZhCn = localeString.getLocaleValue_zh_CN();
        String localeValueZhTw = localeString.getLocaleValue_zh_TW();
        String localeValueEn = localeString.getLocaleValue_en();
        LocaleString ruleLocalString = new LocaleString();
        if (!HRStringUtils.isEmpty((String)localeValueZhCn)) {
            ruleLocalString.setLocaleValue_zh_CN(localeValueZhCn + mark);
        }
        if (!HRStringUtils.isEmpty((String)localeValueZhTw)) {
            ruleLocalString.setLocaleValue_zh_TW(localeValueZhTw + mark);
        }
        if (!HRStringUtils.isEmpty((String)localeValueEn)) {
            ruleLocalString.setLocaleValue_en(localeValueEn + mark);
        }
        newRule.set("name", (Object)ruleLocalString);
        newRule.set("number", (Object)(planDy.getString("number") + mark));
        newRule.set("bsled", (Object)blsed);
        newRule.set("bsed", (Object)bsed);
        newRule.set("createorg", (Object)planDy.getLong("createorg.id"));
        newRule.set("org", (Object)planDy.getLong("org.id"));
        newRule.set("firstbsed", (Object)planDy.getDate("firstbsed"));
        newRule.set("useorg", (Object)planDy.getLong("useorg.id"));
        newRule.set("ctrlstrategy", (Object)planDy.getString("ctrlstrategy"));
        newRule.set("enable", (Object)Character.valueOf('1'));
        newRule.set("versionsource", (Object)"1");
        newRule.set("id", (Object)newRuleVid);
        return newRule;
    }
}

