/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.incdec;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.wtp.constants.incdec.IncDecConfigConstants;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfCondService;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfKDStringHelper;

public class IncDecConfUpgradeService
implements IncDecConfigConstants {
    private static final Log LOG = LogFactory.getLog(IncDecConfUpgradeService.class);
    private HRBaseServiceHelper configHelper = new HRBaseServiceHelper("wtp_incdecconf");
    private HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("wtp_incdecrules");
    private final IncDecConfCondService COND_SERVICE = IncDecConfCondService.getInstance();

    public void execute() {
        LOG.info("IncDecConfUpgradeService_begin...");
        DynamicObject[] configDataOfUpgrade = this.getConfigDataOfUpgrade();
        if (configDataOfUpgrade != null && configDataOfUpgrade.length > 0) {
            LOG.info("IncDecConfUpgradeService_config data trans");
            this.transData(configDataOfUpgrade);
            this.configHelper.save(configDataOfUpgrade);
        }
        DynamicObject[] allOldConfigData = this.getAllConfigData(configDataOfUpgrade);
        ArrayList configBoIdList = Lists.newArrayListWithCapacity((int)allOldConfigData.length);
        HashMap boIdAndConfigMap = Maps.newHashMapWithExpectedSize((int)allOldConfigData.length);
        this.getBoIdInfo(allOldConfigData, configBoIdList, boIdAndConfigMap);
        LOG.info("IncDecConfUpgradeService_execute_boIdAndConfigMap.size={}", (Object)boIdAndConfigMap.size());
        DynamicObject[] ruleData = this.getRuleData(configBoIdList);
        if (ruleData != null && ruleData.length > 0) {
            LOG.info("IncDecConfUpgradeService_execute_ruleData size={}", (Object)ruleData.length);
            Set<Long> ruleIdSet = Arrays.stream(ruleData).map(dd -> dd.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] dateRange = this.getDateRange(ruleIdSet);
            if (dateRange != null && dateRange.length > 0) {
                LOG.info("IncDecConfUpgradeService_execute_dateRange size={}", (Object)dateRange.length);
                this.dealWithRule(this.getRuleData(ruleData), dateRange, boIdAndConfigMap);
            }
        }
        LOG.info("IncDecConfUpgradeService_end...");
    }

    private void dealWithRule(DynamicObject[] ruleData, DynamicObject[] dateRange, Map<Long, List<DynamicObject>> boIdAndConfigMap) {
        HashMap ruleMap = Maps.newHashMapWithExpectedSize((int)ruleData.length);
        HashMap ruleBoMap = Maps.newHashMapWithExpectedSize((int)ruleData.length);
        for (DynamicObject ruleDy : ruleData) {
            long ruleBoId = ruleDy.getLong("boid");
            List ruleBoList = (List)ruleMap.get(ruleBoId);
            if (ruleBoList == null) {
                ruleBoList = Lists.newArrayListWithExpectedSize((int)ruleData.length);
            }
            ruleBoList.add(ruleDy);
            ruleMap.put(ruleBoId, ruleBoList);
            boolean isCur = ruleDy.getBoolean("iscurrentversion");
            if (!isCur) continue;
            ruleBoMap.put(ruleBoId, ruleDy);
        }
        HashMap ruleIdAndDateJsonMap = Maps.newHashMapWithExpectedSize((int)dateRange.length);
        for (DynamicObject dateDy : dateRange) {
            ruleIdAndDateJsonMap.put(dateDy.getLong("basedataid"), dateDy.getString("conditions"));
        }
        HashMap confBoIdAndDateJsonMap = Maps.newHashMapWithExpectedSize((int)ruleData.length);
        ArrayList updateRuleList = Lists.newArrayListWithExpectedSize((int)ruleData.length);
        ArrayList insertConfigList = Lists.newArrayListWithExpectedSize((int)ruleData.length);
        ArrayList updateConfigList = Lists.newArrayListWithExpectedSize((int)ruleData.length);
        Set entries = ruleMap.entrySet();
        for (Map.Entry next : entries) {
            List list = (List)next.getValue();
            if (list == null || list.isEmpty()) continue;
            Long ruleBoId = (Long)next.getKey();
            DynamicObject ruleCurVision = (DynamicObject)ruleBoMap.get(ruleBoId);
            for (DynamicObject ruleDy : list) {
                boolean isSys = ruleDy.getBoolean("issyspreset");
                boolean isCur = ruleDy.getBoolean("iscurrentversion");
                if (isCur || isSys) continue;
                this.dealWithEachRule(ruleDy, ruleCurVision, ruleIdAndDateJsonMap, confBoIdAndDateJsonMap, updateRuleList, insertConfigList, boIdAndConfigMap, updateConfigList);
            }
        }
        this.ruleHelper.update(updateRuleList.toArray(new DynamicObject[0]));
        this.configHelper.save(insertConfigList.toArray(new DynamicObject[0]));
        this.configHelper.update(updateConfigList.toArray(new DynamicObject[0]));
    }

    private void dealWithEachRule(DynamicObject ruleDy, DynamicObject ruleCurVision, Map<Long, String> ruleIdAndDateJsonMap, Map<Long, String> confBoIdAndDateJsonMap, List<DynamicObject> updateRuleList, List<DynamicObject> insertConfigList, Map<Long, List<DynamicObject>> boIdAndConfigMap, List<DynamicObject> updateConfigList) {
        long ruleId = ruleDy.getLong("id");
        String dateJson = ruleIdAndDateJsonMap.get(ruleId);
        if (HRStringUtils.isEmpty((String)dateJson)) {
            return;
        }
        boolean isPoint = this.isPoint(ruleCurVision, ruleDy);
        boolean isNeedUpdateRule = false;
        DynamicObjectCollection entityColl = ruleDy.getDynamicObjectCollection("wtp_rulessettingentity");
        for (DynamicObject entity : entityColl) {
            DynamicObject confDy = entity.getDynamicObject("incdecconfig");
            if (HRObjectUtils.isEmpty((Object)confDy)) continue;
            boolean isSysOfConf = confDy.getBoolean("issyspreset");
            long confBoId = confDy.getLong("id");
            String dateJsonOfMap = confBoIdAndDateJsonMap.get(confBoId);
            if (HRStringUtils.isEmpty((String)dateJsonOfMap)) {
                if (isSysOfConf) {
                    isNeedUpdateRule = true;
                    this.copy(boIdAndConfigMap, confBoId, insertConfigList, dateJson, confBoIdAndDateJsonMap, entity);
                    continue;
                }
                confBoIdAndDateJsonMap.put(confBoId, dateJson);
                this.updateDateJson(boIdAndConfigMap, confBoId, dateJson, updateConfigList);
                continue;
            }
            if (!HRStringUtils.equals((String)dateJsonOfMap, (String)dateJson)) {
                isNeedUpdateRule = true;
                this.copy(boIdAndConfigMap, confBoId, insertConfigList, dateJson, confBoIdAndDateJsonMap, entity);
                continue;
            }
            if (isSysOfConf) {
                isNeedUpdateRule = true;
                this.copy(boIdAndConfigMap, confBoId, insertConfigList, dateJson, confBoIdAndDateJsonMap, entity);
                continue;
            }
            confBoIdAndDateJsonMap.put(confBoId, dateJson);
            this.updateDateJson(boIdAndConfigMap, confBoId, dateJson, updateConfigList);
        }
        if (isPoint && isNeedUpdateRule) {
            DynamicObjectCollection vEntityColl = ruleDy.getDynamicObjectCollection("wtp_rulessettingentity");
            HashMap seqAndConfigMap = Maps.newHashMapWithExpectedSize((int)vEntityColl.size());
            for (DynamicObject vEntity : vEntityColl) {
                String seq = vEntity.getString("seq");
                seqAndConfigMap.put(seq, vEntity.get("incdecconfig"));
            }
            DynamicObjectCollection boEntityColl = ruleCurVision.getDynamicObjectCollection("wtp_rulessettingentity");
            for (DynamicObject boEntity : boEntityColl) {
                String seq = boEntity.getString("seq");
                Object configDy = seqAndConfigMap.get(seq);
                if (HRObjectUtils.isEmpty(configDy)) continue;
                boEntity.set("incdecconfig", configDy);
            }
            updateRuleList.add(ruleCurVision);
        }
        if (isNeedUpdateRule) {
            updateRuleList.add(ruleDy);
        }
    }

    private void copy(Map<Long, List<DynamicObject>> boIdAndConfigMap, long confBoId, List<DynamicObject> insertConfigList, String dateJson, Map<Long, String> confBoIdAndDateJsonMap, DynamicObject entity) {
        long newConfBoId;
        List<DynamicObject> oldConfList = boIdAndConfigMap.get(confBoId);
        if (oldConfList != null && !oldConfList.isEmpty() && (newConfBoId = this.copyConfList(oldConfList, insertConfigList, dateJson)) != 0L) {
            confBoIdAndDateJsonMap.put(newConfBoId, dateJson);
            entity.set("incdecconfig", (Object)newConfBoId);
        }
    }

    private boolean isPoint(DynamicObject ruleCurVision, DynamicObject ruleDy) {
        if (HRObjectUtils.isEmpty((Object)ruleCurVision)) {
            return false;
        }
        String dataStatus = ruleDy.getString("datastatus");
        return HRStringUtils.equals((String)"1", (String)dataStatus);
    }

    private void updateDateJson(Map<Long, List<DynamicObject>> boIdAndConfigMap, long confBoId, String dateJson, List<DynamicObject> updateConfigList) {
        List<DynamicObject> oldConfList = boIdAndConfigMap.get(confBoId);
        if (oldConfList != null && !oldConfList.isEmpty()) {
            for (DynamicObject confDy : oldConfList) {
                confDy.set("conditionjson", (Object)dateJson);
                updateConfigList.add(confDy);
            }
        }
    }

    private long copyConfList(List<DynamicObject> oldConfList, List<DynamicObject> insertConfigList, String dateJson) {
        if (oldConfList == null || oldConfList.size() < 2) {
            return 0L;
        }
        long[] ids = ORM.create().genLongIds("wtp_incdecconf", oldConfList.size());
        HashMap idMap = Maps.newHashMapWithExpectedSize((int)oldConfList.size());
        int index = 0;
        long newBoId = 0L;
        for (DynamicObject confDy : oldConfList) {
            long newId = ids[index];
            if (confDy.getBoolean("iscurrentversion")) {
                newBoId = newId;
            }
            idMap.put(confDy.getLong("id"), newId);
            ++index;
        }
        String idStr = String.valueOf(ids[0]);
        String suf = "_COPY" + idStr.substring(idStr.length() - 4);
        for (DynamicObject confDy : oldConfList) {
            long oldId = confDy.getLong("id");
            Long newId = (Long)idMap.get(oldId);
            DynamicObject newConfigDy = this.configHelper.generateEmptyDynamicObject();
            newConfigDy.set("id", (Object)newId);
            newConfigDy.set("boid", (Object)newBoId);
            newConfigDy.set("iscurrentversion", confDy.get("iscurrentversion"));
            newConfigDy.set("datastatus", confDy.get("datastatus"));
            long sourceId = confDy.getLong("sourcevid");
            if (sourceId != 0L) {
                sourceId = (Long)idMap.get(sourceId);
            }
            newConfigDy.set("sourcevid", (Object)sourceId);
            newConfigDy.set("firstbsed", confDy.get("firstbsed"));
            newConfigDy.set("changebsed", confDy.get("changebsed"));
            newConfigDy.set("ismodify", confDy.get("ismodify"));
            newConfigDy.set("bred", confDy.get("bred"));
            newConfigDy.set("brled", confDy.get("brled"));
            newConfigDy.set("brfd", confDy.get("brfd"));
            newConfigDy.set("versionsource", confDy.get("versionsource"));
            newConfigDy.set("hisversion", confDy.get("hisversion"));
            newConfigDy.set("createorg", confDy.get("createorg"));
            newConfigDy.set("name", (Object)(confDy.getString("name") + suf));
            newConfigDy.set("number", (Object)(confDy.getString("number") + suf));
            newConfigDy.set("ctrlstrategy", confDy.get("ctrlstrategy"));
            newConfigDy.set("bsed", confDy.get("bsed"));
            newConfigDy.set("bsled", confDy.get("bsled"));
            newConfigDy.set("suittype", confDy.get("suittype"));
            newConfigDy.set("triggertype", confDy.get("triggertype"));
            newConfigDy.set("conditionjson", (Object)dateJson);
            newConfigDy.set("changedescription", confDy.get("changedescription"));
            newConfigDy.set("description", confDy.get("description"));
            newConfigDy.set("createtime", confDy.get("createtime"));
            newConfigDy.set("creator", confDy.get("creator"));
            newConfigDy.set("modifytime", confDy.get("modifytime"));
            newConfigDy.set("modifier", confDy.get("modifier"));
            newConfigDy.set("masterid", (Object)newId);
            newConfigDy.set("org", confDy.get("org"));
            newConfigDy.set("useorg", confDy.get("useorg"));
            newConfigDy.set("status", confDy.get("status"));
            newConfigDy.set("enable", confDy.get("enable"));
            newConfigDy.set("issyspreset", (Object)Boolean.FALSE);
            newConfigDy.set("disabler", confDy.get("disabler"));
            newConfigDy.set("disabledate", confDy.get("disabledate"));
            this.copyEntity(confDy, newConfigDy, newId);
            insertConfigList.add(newConfigDy);
        }
        return newBoId;
    }

    private void copyEntity(DynamicObject confDy, DynamicObject newConfigDy, long id) {
        DynamicObjectCollection oldEntityColl = confDy.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection newEntityColl = newConfigDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject oldEntity : oldEntityColl) {
            DynamicObject newEntity = newEntityColl.addNew();
            newEntity.set("conditionstr", oldEntity.get("conditionstr"));
            newEntity.set("resultstr", oldEntity.get("resultstr"));
            newEntity.set("seriallimit", oldEntity.get("seriallimit"));
            newEntity.set("serialperiod", oldEntity.get("serialperiod"));
            newEntity.set("shifttype", oldEntity.get("shifttype"));
            newEntity.set("curattitem", oldEntity.get("curattitem"));
            newEntity.set("battitem", oldEntity.get("battitem"));
            newEntity.set("indecrrel", (Object)oldEntity.getString("indecrrel"));
            newEntity.set("indecrvalue", oldEntity.get("indecrvalue"));
            newEntity.set("daytype", oldEntity.get("daytype"));
            newEntity.set("regulartime", oldEntity.get("regulartime"));
            newEntity.set("logictype", oldEntity.get("logictype"));
            newEntity.set("logicstr", oldEntity.get("logicstr"));
            this.copySubCond(oldEntity, newEntity);
            DynamicObjectCollection oldResultColl = oldEntity.getDynamicObjectCollection("resultsubentryentity");
            DynamicObjectCollection newResultColl = newEntity.getDynamicObjectCollection("resultsubentryentity");
            for (DynamicObject oldResult : oldResultColl) {
                DynamicObject newResult = newResultColl.addNew();
                newResult.set("resultitem", oldResult.get("resultitem"));
                newResult.set("resultrel", oldResult.get("resultrel"));
                newResult.set("resultvalue", oldResult.get("resultvalue"));
            }
        }
    }

    private void copySubCond(DynamicObject oldEntity, DynamicObject newEntity) {
        DynamicObjectCollection oldCondColl = oldEntity.getDynamicObjectCollection("condsubentryentity");
        DynamicObjectCollection newCondColl = newEntity.getDynamicObjectCollection("condsubentryentity");
        for (DynamicObject oldCond : oldCondColl) {
            DynamicObject newCond = newCondColl.addNew();
            newCond.set("limitno", oldCond.get("limitno"));
            MulBasedataProp prop = (MulBasedataProp)newCond.getDynamicObjectType().getProperty("condattitem");
            MulBasedataDynamicObjectCollection mulColl = new MulBasedataDynamicObjectCollection();
            DynamicObjectCollection condAttItems = oldCond.getDynamicObjectCollection("condattitem");
            for (DynamicObject item : condAttItems) {
                DynamicObject newDy = new DynamicObject(prop.getDynamicCollectionItemPropertyType());
                newDy.set("fbasedataid", item.get("fbasedataid"));
                newDy.set("fbasedataid_id", (Object)item.getLong("fbasedataid.id"));
                mulColl.add(newDy);
            }
            if (!mulColl.isEmpty()) {
                newCond.set("condattitem", (Object)mulColl);
            }
            newCond.set("condrel", oldCond.get("condrel"));
            newCond.set("condvalue", oldCond.get("condvalue"));
        }
    }

    private void getBoIdInfo(DynamicObject[] data, List<Long> configBoIdList, Map<Long, List<DynamicObject>> boIdAndConfigMap) {
        for (DynamicObject dy : data) {
            long boId = dy.getLong("boid");
            configBoIdList.add(boId);
            ArrayList configList = boIdAndConfigMap.get(boId);
            if (configList == null) {
                configList = Lists.newArrayListWithExpectedSize((int)16);
            }
            configList.add(dy);
            boIdAndConfigMap.put(boId, configList);
        }
    }

    private void transData(DynamicObject[] data) {
        HashMap mainTableMap = Maps.newHashMapWithExpectedSize((int)data.length);
        HashMap limitMap = Maps.newHashMapWithExpectedSize((int)data.length);
        HashMap itemBaseDataMap = Maps.newHashMapWithExpectedSize((int)data.length);
        HashMap itemMap = Maps.newHashMapWithExpectedSize((int)data.length);
        this.getOldConfigInfo(data, mainTableMap, limitMap, itemBaseDataMap, itemMap);
        for (DynamicObject dy : data) {
            long id;
            Map mainDataMap;
            boolean isSys = dy.getBoolean("issyspreset");
            if (isSys || (mainDataMap = (Map)mainTableMap.get(id = dy.getLong("id"))) == null) continue;
            List limitList = (List)limitMap.get(id);
            dy.set("suittype", (Object)"1");
            String triggerType = dy.getString("triggertype");
            if (HRStringUtils.equals((String)"A", (String)triggerType)) {
                this.tranOfItem(dy, mainDataMap, limitList, itemBaseDataMap, itemMap);
                continue;
            }
            if (!HRStringUtils.equals((String)"B", (String)triggerType)) continue;
            this.tranOfTime(dy, mainDataMap, itemMap);
        }
    }

    private void tranOfItem(DynamicObject dy, Map<String, Object> mainDataMap, List<Map<String, Object>> limitList, Map<Long, List<Long>> itemBaseDataMap, Map<Long, DynamicObject> itemMap) {
        Long attItemBoId = (Long)mainDataMap.get("ftarattitem");
        DynamicObject attItemDy = null;
        if (attItemBoId != null) {
            attItemDy = itemMap.get(attItemBoId);
        }
        if (HRObjectUtils.isEmpty(attItemDy)) {
            return;
        }
        DynamicObjectCollection entry = dy.getDynamicObjectCollection("entryentity");
        DynamicObject each = entry.addNew();
        each.set("logictype", mainDataMap.get("fcombofield"));
        each.set("logicstr", mainDataMap.get("fcondition"));
        each.set("seq", (Object)0);
        each.set("indecrvalue", (Object)BigDecimal.ZERO);
        each.set("seriallimit", (Object)Boolean.FALSE);
        each.set("serialperiod", (Object)Boolean.FALSE);
        each.set("daytype", (Object)"A");
        each.set("shifttype", (Object)"0");
        DynamicObjectCollection newDataOfLimitColl = each.getDynamicObjectCollection("condsubentryentity");
        if (limitList != null) {
            for (Map<String, Object> limitMap : limitList) {
                List<Long> itemList;
                DynamicObject newCondDy = newDataOfLimitColl.addNew();
                newCondDy.set("seq", limitMap.get("fseq"));
                newCondDy.set("limitno", limitMap.get("flimitindex"));
                newCondDy.set("condrel", limitMap.get("ffloorlogic"));
                newCondDy.set("condvalue", limitMap.get("ffloorvalue"));
                Long entryId = (Long)limitMap.get("fentryid");
                if (entryId == null || (itemList = itemBaseDataMap.get(entryId)) == null || itemList.isEmpty()) continue;
                MulBasedataProp prop = (MulBasedataProp)newCondDy.getDynamicObjectType().getProperty("condattitem");
                MulBasedataDynamicObjectCollection mulColl = new MulBasedataDynamicObjectCollection();
                for (Long baseDataId : itemList) {
                    DynamicObject baseDataDy = itemMap.get(baseDataId);
                    DynamicObject newDy = new DynamicObject(prop.getDynamicCollectionItemPropertyType());
                    newDy.set("fbasedataid_id", (Object)baseDataId);
                    newDy.set("fbasedataid", (Object)baseDataDy);
                    mulColl.add(newDy);
                }
                if (mulColl.isEmpty()) continue;
                newCondDy.set("condattitem", (Object)mulColl);
            }
        }
        DynamicObjectCollection newDataOfResultColl = each.getDynamicObjectCollection("resultsubentryentity");
        DynamicObject newResultDy = newDataOfResultColl.addNew();
        newResultDy.set("seq", (Object)0);
        newResultDy.set("resultitem", (Object)attItemDy);
        newResultDy.set("resultrel", mainDataMap.get("fincdecrelation"));
        newResultDy.set("resultvalue", mainDataMap.get("fincdecvalue"));
        String condShow = this.COND_SERVICE.condShow(newDataOfLimitColl, each.getString("logicstr"), each.getString("logictype"));
        each.set("conditionstr", (Object)condShow);
        each.set("resultstr", (Object)this.COND_SERVICE.getOneResultStr(newResultDy));
    }

    private void tranOfTime(DynamicObject dy, Map<String, Object> mainDataMap, Map<Long, DynamicObject> itemMap) {
        Long attItemBoId = (Long)mainDataMap.get("ftarattitem");
        DynamicObject attItemDy = null;
        if (attItemBoId != null) {
            attItemDy = itemMap.get(attItemBoId);
        }
        if (HRObjectUtils.isEmpty(attItemDy)) {
            return;
        }
        boolean isTime = HRStringUtils.equals((String)"1", (String)((String)mainDataMap.get("fcheckboxfield")));
        if (isTime) {
            dy.set("triggertype", (Object)"B");
        } else {
            dy.set("triggertype", (Object)"C");
        }
        DynamicObjectCollection entry = dy.getDynamicObjectCollection("entryentity");
        DynamicObject each = entry.addNew();
        each.set("seq", (Object)0);
        if (isTime) {
            each.set("regulartime", mainDataMap.get("ftriggertime"));
        }
        each.set("curattitem", (Object)attItemDy);
        each.set("indecrrel", mainDataMap.get("fincdecrelation"));
        each.set("indecrvalue", mainDataMap.get("fincdecvalue"));
        if (isTime) {
            each.set("conditionstr", (Object)this.COND_SERVICE.condShow(each.getInt("regulartime")));
        } else {
            each.set("conditionstr", (Object)IncDecConfKDStringHelper.empty());
        }
        String resultShow = this.COND_SERVICE.resultShowOfTime(each.getDynamicObject("curattitem"), each.getString("indecrrel"), each.getBigDecimal("indecrvalue"));
        each.set("resultstr", (Object)resultShow);
    }

    private void getOldConfigInfo(DynamicObject[] data, Map<Long, Map<String, Object>> mainTableMap, Map<Long, List<Map<String, Object>>> limitMap, Map<Long, List<Long>> itemBaseDataMap, Map<Long, DynamicObject> itemMap) {
        List allIdList = Arrays.stream(data).map(dd -> dd.getString("id")).collect(Collectors.toList());
        ArrayList attItemBoIdList = Lists.newArrayListWithCapacity((int)16);
        DBRoute db = this.getDb();
        String mainSql = "select fid,ftriggertime,ftarattitem,fincdecrelation,fcombofield,fcondition,fincdecvalue,fcheckboxfield  from t_wtp_incdecconf where fid in  (" + String.join((CharSequence)",", allIdList) + ");";
        DataSet mainRows = DB.queryDataSet((String)(this.getClass().getName() + ".mainTableMap"), (DBRoute)db, (String)mainSql);
        for (Row row : mainRows) {
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
            Long id = row.getLong("fid");
            dataMap.put("fid", id);
            dataMap.put("ftriggertime", row.get("ftriggertime"));
            Long attItemBoId = row.getLong("ftarattitem");
            dataMap.put("ftarattitem", attItemBoId);
            dataMap.put("fincdecrelation", row.get("fincdecrelation"));
            dataMap.put("fcombofield", row.get("fcombofield"));
            dataMap.put("fcondition", row.get("fcondition"));
            dataMap.put("fincdecvalue", row.get("fincdecvalue"));
            dataMap.put("fcheckboxfield", row.get("fcheckboxfield"));
            mainTableMap.put(id, dataMap);
            attItemBoIdList.add(attItemBoId);
        }
        String limitSql = "select fid,fseq,flimitindex,ffloorlogic,ffloorvalue,fentryid  from t_wtp_incdeclimentry where fid in (" + String.join((CharSequence)",", allIdList) + ");";
        DataSet limitRows = DB.queryDataSet((String)(this.getClass().getName() + ".limitSql"), (DBRoute)db, (String)limitSql);
        Iterator limitIterator = limitRows.iterator();
        ArrayList entryIdList = Lists.newArrayListWithExpectedSize((int)16);
        while (limitIterator.hasNext()) {
            Row row = (Row)limitIterator.next();
            Long id = row.getLong("fid");
            ArrayList list = limitMap.get(id);
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)16);
            }
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
            dataMap.put("fseq", row.get("fseq"));
            dataMap.put("flimitindex", row.get("flimitindex"));
            dataMap.put("ffloorlogic", row.get("ffloorlogic"));
            dataMap.put("ffloorvalue", row.get("ffloorvalue"));
            dataMap.put("fentryid", row.get("fentryid"));
            list.add(dataMap);
            limitMap.put(id, list);
            entryIdList.add(row.getString("fentryid"));
        }
        String itemSql = "select fentryid ,fbasedataid  from t_wtp_incdecattitems where fentryid in (" + String.join((CharSequence)",", entryIdList) + ");";
        DataSet itemRows = DB.queryDataSet((String)(this.getClass().getName() + ".itemSql"), (DBRoute)db, (String)itemSql);
        for (Row row : itemRows) {
            Long entryId = row.getLong("fentryid");
            ArrayList list = itemBaseDataMap.get(entryId);
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)16);
            }
            Long attItemBoId = row.getLong("fbasedataid");
            list.add(attItemBoId);
            itemBaseDataMap.put(entryId, list);
            attItemBoIdList.add(attItemBoId);
        }
        HRBaseServiceHelper attItemHelper = new HRBaseServiceHelper("wtbd_attitem");
        DynamicObject[] attItemArr = attItemHelper.loadDynamicObjectArray((Object[])attItemBoIdList.toArray(new Long[0]));
        if (attItemArr != null && attItemArr.length > 0) {
            for (DynamicObject attItemDy : attItemArr) {
                itemMap.put(attItemDy.getLong("id"), attItemDy);
            }
        }
    }

    private DynamicObject[] getAllConfigData(DynamicObject[] configDataOfUpgrade) {
        QFilter sysQFilter;
        DynamicObject[] sysArr;
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)16);
        if (configDataOfUpgrade != null && configDataOfUpgrade.length > 0) {
            for (DynamicObject configDy : configDataOfUpgrade) {
                idList.add(configDy.getLong("id"));
            }
        }
        if ((sysArr = this.configHelper.query("id", new QFilter[]{sysQFilter = new QFilter("issyspreset", "=", (Object)Character.valueOf('1'))})) != null && sysArr.length > 0) {
            for (DynamicObject dy : sysArr) {
                idList.add(dy.getLong("id"));
            }
        }
        return this.configHelper.loadDynamicObjectArray((Object[])idList.toArray(new Long[0]));
    }

    private DynamicObject[] getConfigDataOfUpgrade() {
        DBRoute db = this.getDb();
        String sql = "select a.fid,b.fsuittype  from t_wtp_incdecconf a left join t_wtp_incdecconf_a b on a.fid = b.fid where a.ftarattitem <> 0 and a.fissyspreset ='0';";
        DataSet rows = DB.queryDataSet((String)(this.getClass().getName() + ".getConfigDataOfUpgrade"), (DBRoute)db, (String)sql);
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : rows) {
            String suitType = row.getString("fsuittype");
            if (!HRStringUtils.isEmpty((String)suitType)) continue;
            idSet.add(row.getLong("fid"));
        }
        if (idSet.isEmpty()) {
            return null;
        }
        String insertUSql = "INSERT INTO t_wtp_incdecconf_a (fid,fsuittype) VALUES(?, ?);";
        ArrayList params = Lists.newArrayListWithExpectedSize((int)100);
        for (Long id : idSet) {
            Object[] org = new Object[]{id, 1};
            params.add(org);
        }
        if (params.size() > 0) {
            HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"wtc"), (String)"INSERT INTO t_wtp_incdecconf_a (fid,fsuittype) VALUES(?, ?);", (List)params);
        }
        LOG.info("IncDecConfUpgradeService_insert_table_a idSet={}", (Object)idSet.size());
        return this.configHelper.loadDynamicObjectArray((Object[])idSet.toArray(new Long[0]));
    }

    private DynamicObject[] getRuleData(List<Long> configBoIdList) {
        QFilter entryConfig = new QFilter("wtp_rulessettingentity.incdecconfig", "in", configBoIdList);
        entryConfig.and(new QFilter("issyspreset", "=", (Object)Character.valueOf('0')));
        return this.ruleHelper.query("id,boid,wtp_rulessettingentity,iscurrentversion,wtp_rulessettingentity.incdecconfig", new QFilter[]{entryConfig});
    }

    private DynamicObject[] getRuleData(DynamicObject[] ruleData) {
        List<Long> idList = Arrays.stream(ruleData).map(dd -> dd.getLong("id")).collect(Collectors.toList());
        return this.ruleHelper.loadDynamicObjectArray((Object[])idList.toArray(new Long[0]));
    }

    private DynamicObject[] getDateRange(Set<Long> ruleBoIdSet) {
        HRBaseServiceHelper dateRangeHelper = new HRBaseServiceHelper("wtbd_daterange");
        QFilter rule = new QFilter("metanumber", "=", (Object)"wtp_incdecrules");
        rule.and(new QFilter("basedataid", "in", ruleBoIdSet));
        return dateRangeHelper.query("basedataid,conditions", new QFilter[]{rule});
    }

    private DBRoute getDb() {
        IDataEntityType dataEntityType = this.configHelper.generateEmptyDynamicObject().getDataEntityType();
        return DBRoute.of((String)dataEntityType.getDBRouteKey());
    }
}

