/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.incdec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCCommonHisService;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.task.upgrade.billcommon.BillUpgradeCommonService;

public class IncDecPlanUpgradeService {
    private Map<Long, Set<Long>> planAndRuleEntryMap;
    private Map<Long, DynamicObject> ruleIdAndBoDy;

    public void upgrade() {
        HRBaseServiceHelper planServiceHelper = new HRBaseServiceHelper("wtp_incdecplan");
        BillUpgradeCommonService commonService = new BillUpgradeCommonService();
        List<DynamicObject> needUpdatePlan = commonService.queryNeedUpdatePlan("wtp_incdecplan", "incdecrulef7");
        if (CollectionUtils.isEmpty(needUpdatePlan)) {
            return;
        }
        Map currentVersionMap = needUpdatePlan.stream().filter(attendPlan -> attendPlan.getBoolean("iscurrentversion")).collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity()));
        this.planAndRuleEntryMap = this.getPlanAndRuleEntryMap(needUpdatePlan);
        HashSet allRuleBoId = Sets.newHashSetWithExpectedSize((int)this.planAndRuleEntryMap.size());
        this.planAndRuleEntryMap.forEach((key, val) -> allRuleBoId.addAll(val));
        this.ruleIdAndBoDy = commonService.getCurrentRuleByIds(allRuleBoId, "wtp_incdecrules");
        ArrayList insertRule = Lists.newArrayListWithExpectedSize((int)10);
        long[] ruleIds = DB.genGlobalLongIds((int)needUpdatePlan.size());
        int idIndex = 0;
        for (DynamicObject planDy : needUpdatePlan) {
            DynamicObject newRule;
            if (planDy.getBoolean("iscurrentversion") && "C".equalsIgnoreCase(planDy.getString("status")) || (newRule = this.genNewRuleByPlan(planDy, ruleIds[idIndex])) == null) continue;
            insertRule.add(newRule);
            planDy.set("incdecrulef7_id", (Object)ruleIds[idIndex]);
            String dataStatus = planDy.getString("datastatus");
            DynamicObject currentVersionDy = (DynamicObject)currentVersionMap.get(planDy.getLong("boid"));
            if (currentVersionDy != null && HRStringUtils.equalsIgnoreCase((String)dataStatus, (String)"1")) {
                currentVersionDy.set("incdecrulef7_id", (Object)ruleIds[idIndex]);
            }
            ++idIndex;
        }
        if (CollectionUtils.isEmpty((Collection)insertRule)) {
            return;
        }
        planServiceHelper.update(needUpdatePlan.toArray(new DynamicObject[0]));
        HisResponse versionChangeRespDataHisResponse = WTCCommonHisService.saveTimeHisModelData((DynamicObject[])insertRule.toArray(new DynamicObject[0]), (String)"wtp_incdecrules", (Long)DB.genGlobalLongId(), (Boolean)Boolean.FALSE);
        if (!HRStringUtils.equals((String)versionChangeRespDataHisResponse.getCode(), (String)"200")) {
            throw new KDBizException("error in update attplan case by saveTimeHisModelData");
        }
    }

    private DynamicObject genNewRuleByPlan(DynamicObject plan, long newRuleVid) {
        long planId = plan.getLong("id");
        Set<Long> ruleBoIdList = this.planAndRuleEntryMap.get(planId);
        if (CollectionUtils.isEmpty(ruleBoIdList)) {
            return null;
        }
        BillUpgradeCommonService commonService = new BillUpgradeCommonService();
        DynamicObject newRule = commonService.genRuleCommonInfo("wtp_incdecrules", plan, newRuleVid);
        DynamicObjectCollection newRuleEntries = newRule.getDynamicObjectCollection("wtp_rulessettingentity");
        HashSet<Long> ruleBoIds = new HashSet<Long>(16);
        int i = 1;
        for (Long ruleBoId : ruleBoIdList) {
            if (ruleBoId == null || ruleBoId == 0L) continue;
            DynamicObject currentVersion = this.ruleIdAndBoDy.get(ruleBoId);
            DynamicObjectCollection configEntry = currentVersion.getDynamicObjectCollection("wtp_rulessettingentity");
            for (DynamicObject entryDy : configEntry) {
                Long configDyId;
                if (entryDy == null || (configDyId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)entryDy, (String)"incdecconfig")) == 0L || ruleBoIds.contains(configDyId)) continue;
                DynamicObject newEntryDy = newRuleEntries.addNew();
                newEntryDy.set("incdecconfig_id", (Object)configDyId);
                newEntryDy.set("seq", (Object)i);
                ruleBoIds.add(configDyId);
                ++i;
            }
        }
        return newRule;
    }

    private Map<Long, Set<Long>> getPlanAndRuleEntryMap(List<DynamicObject> needQueryPlanDys) {
        Set planIdSets = needQueryPlanDys.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        Set planIdStringSets = needQueryPlanDys.stream().map(dynamicObject -> dynamicObject.getLong("id") + "").collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(planIdSets)) {
            return Collections.emptyMap();
        }
        DBRoute dbRoute = this.getDBRoute();
        HashMap result = Maps.newHashMapWithExpectedSize((int)planIdSets.size());
        for (Long planIdSet : planIdSets) {
            result.put(planIdSet, Sets.newHashSetWithExpectedSize((int)16));
        }
        String ids = String.join((CharSequence)",", planIdStringSets);
        String sql = "SELECT fentryid, fseq, fincdecruleid, fid, fentryboid FROM t_wtp_incdecprzentry  where fid in (" + ids + ");";
        DataSet ruleEntrySet = HRDBUtil.queryDataSet((String)"getPlanAndRuleEntryMap", (DBRoute)dbRoute, (String)sql, (Object[])new Object[0]);
        for (Row next : ruleEntrySet) {
            Long fid = next.getLong("fid");
            Set attRuleIds = (Set)result.get(fid);
            Long fattruleid = next.getLong("fincdecruleid");
            if (fattruleid == null || fattruleid == 0L) continue;
            attRuleIds.add(fattruleid);
        }
        return result;
    }

    private DBRoute getDBRoute() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_incdecplan");
        IDataEntityType dataEntityType = serviceHelper.generateEmptyDynamicObject().getDataEntityType();
        return DBRoute.of((String)dataEntityType.getDBRouteKey());
    }
}

