/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.incdec;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.wtp.constants.incdec.IncDecConfigConstants;

public class IncDecUpdateEnableService
implements IncDecConfigConstants {
    private static final Log LOG = LogFactory.getLog(IncDecUpdateEnableService.class);
    private HRBaseServiceHelper configHelper = new HRBaseServiceHelper("wtp_incdecconf");
    private HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("wtp_incdecrules");

    public void update() {
        DynamicObject[] ruleArr = this.getRuleData();
        if (ruleArr == null || ruleArr.length == 0) {
            LOG.info("not data to update about enable");
            return;
        }
        HashMap toUpdateMap = Maps.newHashMapWithExpectedSize((int)ruleArr.length);
        HashMap notUpdateMap = Maps.newHashMapWithExpectedSize((int)ruleArr.length);
        HashSet set = Sets.newHashSetWithExpectedSize((int)4);
        set.add("-2");
        set.add("-1");
        for (DynamicObject ruleDy : ruleArr) {
            String dataStatus = ruleDy.getString("datastatus");
            DynamicObjectCollection entityColl = ruleDy.getDynamicObjectCollection("wtp_rulessettingentity");
            for (DynamicObject entity : entityColl) {
                long configBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entity, (String)"incdecconfig");
                if (configBoId == 0L) continue;
                if (set.contains(dataStatus)) {
                    this.updateMap(toUpdateMap, configBoId);
                    continue;
                }
                this.updateMap(notUpdateMap, configBoId);
            }
        }
        HashSet toUpdateSet = Sets.newHashSetWithExpectedSize((int)toUpdateMap.size());
        Set entries = toUpdateMap.entrySet();
        for (Map.Entry next : entries) {
            Integer count1;
            Long boId = (Long)next.getKey();
            Integer count2 = (Integer)notUpdateMap.get(boId);
            if (count2 != null || (count1 = (Integer)next.getValue()) == null || count1 != 1) continue;
            toUpdateSet.add(boId);
        }
        LOG.info("begin updateConfig");
        this.updateConfig(toUpdateSet);
    }

    private void updateConfig(Set<Long> toUpdateSet) {
        DynamicObject[] arr;
        if (toUpdateSet.isEmpty()) {
            return;
        }
        QFilter number = new QFilter("number", "like", (Object)"%_COPY%");
        number.and("boid", "in", toUpdateSet);
        QFilter sysQFilter = new QFilter("issyspreset", "=", (Object)Character.valueOf('0'));
        for (DynamicObject dy : arr = this.configHelper.query("id,datastatus,enable", new QFilter[]{sysQFilter, number})) {
            dy.set("enable", (Object)0);
        }
        this.configHelper.update(arr);
    }

    private void updateMap(Map<Long, Integer> map, long configBoId) {
        Integer count = map.get(configBoId);
        if (count == null) {
            map.put(configBoId, 1);
        } else {
            count = count + 1;
            map.put(configBoId, count);
        }
    }

    private DynamicObject[] getRuleData() {
        QFilter number = new QFilter("number", "like", (Object)"%_COPY%");
        number.and("iscurrentversion", "=", (Object)"1");
        number.and("enable", "=", (Object)"1");
        QFilter sysQFilter = new QFilter("issyspreset", "=", (Object)Character.valueOf('0'));
        DynamicObject[] arr = this.configHelper.query("id", new QFilter[]{sysQFilter, number});
        if (arr == null || arr.length == 0) {
            return null;
        }
        Set configBoIdSet = Arrays.stream(arr).map(dd -> dd.getLong("id")).collect(Collectors.toSet());
        QFilter entryConfig = new QFilter("wtp_rulessettingentity.incdecconfig", "in", configBoIdSet);
        entryConfig.and(new QFilter("issyspreset", "=", (Object)Character.valueOf('0')));
        return this.ruleHelper.query("id,boid,datastatus,wtp_rulessettingentity,iscurrentversion,wtp_rulessettingentity.incdecconfig", new QFilter[]{entryConfig});
    }
}

