/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.sysparam;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class SysParamInitUpgrade
extends AbstractWtcTaskUpgrade {
    private static final Log LOGGER = LogFactory.getLog(SysParamInitUpgrade.class);
    private static final String QUERY_BAS_SYSPARAM_SQL = "select forgid ,fdata from t_bas_sysparameter where fparamid =(select fid from t_bas_sysparaconsole where fformid ='wtp_param' and fenabled ='1') and fviewtypeid ='26';";
    private static final String QUERY_WTP_SYSPARAMRECORD_SQL = "select forgid ,fdata from t_wtp_sysparamrecord";
    private static final String INSERT_WTP_SYSPARAMRECORD_SQL = "insert into t_wtp_sysparamrecord(fid,forgid,fdata,fcreatetime,fmodifytime) values(?,?,?,?,?)";

    protected String getJobId() {
        return "3FWPN9EEDSQ5";
    }

    protected String getScheduleId() {
        return "3FWPY1CP/UJQ";
    }

    protected boolean process() {
        LOGGER.info("WtpSysParamInitUpgrade.start");
        List<Object[]> paramList = this.beforeProcess();
        if (CollectionUtils.isEmpty(paramList)) {
            return true;
        }
        try {
            DBRoute wtcDbRoute = new DBRoute("wtc");
            HRDBUtil.executeBatch((DBRoute)wtcDbRoute, (String)INSERT_WTP_SYSPARAMRECORD_SQL, paramList);
        }
        catch (Exception ex) {
            LOGGER.warn("WtpSysParamInitUpgrade.process error", (Throwable)ex);
            throw new KDException((Throwable)ex, new ErrorCode("WtpSysParamInitUpgrade error", "WtpSysParamInitUpgrade.process error"), new Object[0]);
        }
        return true;
    }

    private List<Object[]> beforeProcess() {
        DBRoute sysDbRoute = new DBRoute("sys");
        DBRoute wtcDbRoute = new DBRoute("wtc");
        ArrayList list = Lists.newArrayListWithExpectedSize((int)10);
        try (DataSet basSysParamDataSet = HRDBUtil.queryDataSet((String)"bas", (DBRoute)sysDbRoute, (String)QUERY_BAS_SYSPARAM_SQL, null);
             DataSet wtpSysParamDataSet = HRDBUtil.queryDataSet((String)"wtp", (DBRoute)wtcDbRoute, (String)QUERY_WTP_SYSPARAMRECORD_SQL, null);){
            HashSet existOrgIdSet = Sets.newHashSetWithExpectedSize((int)16);
            while (wtpSysParamDataSet.hasNext()) {
                Row row = wtpSysParamDataSet.next();
                existOrgIdSet.add(row.getLong("forgid"));
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            while (basSysParamDataSet.hasNext()) {
                Row row = basSysParamDataSet.next();
                Long orgId = row.getLong("forgid");
                if (existOrgIdSet.contains(orgId)) continue;
                String data = row.getString("fdata");
                map.put(orgId, data);
            }
            long[] ids = DB.genGlobalLongIds((int)map.size());
            int index = 0;
            Date date = new Date();
            for (Map.Entry entry : map.entrySet()) {
                list.add(new Object[]{ids[index], entry.getKey(), entry.getValue(), date, date});
                ++index;
            }
        }
        return list;
    }
}

