/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.vacation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;

public class VaBaseSetUpgradeImpl
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(VaBaseSetUpgradeImpl.class);
    private static final long SHIFT_ITEM_ID = 1743542207845043200L;

    protected String getJobId() {
        return "3G5DZ3PCU+XX";
    }

    protected String getScheduleId() {
        return "3G5EE9FYER/K";
    }

    public boolean process() {
        LOG.info("VaBaseSetUpgradeImpl start process...");
        try (TXHandle txHandle = TX.required();){
            LOG.info("VaBaseSetUpgradeImpl start ...");
            this.upgradeVaBaseSetData();
            this.upgradeVaRuleData();
            LOG.info("VaBaseSetUpgradeImpl end ...");
        }
        return true;
    }

    private void upgradeVaBaseSetData() {
        String insertSql = "INSERT INTO T_WTP_VABASESET_A(fid,fisspecialholiday,fbreasttime,fspecialdaytype,fdaterangecondition,fmaxholidaytime,ftimecalctype,fhalfdaytype,fisaheadmax,faheadmaxval,faheadmaxunit) VALUES(?,?,?,?,?,?,?,?,?,?,?);";
        Object[] insertParams = new Object[]{0L, "0", 0, " ", " ", 0, "A", "A", "0", 0, " "};
        String updateSql = "UPDATE T_WTP_VABASESET_A SET ftimecalctype = ?, fhalfdaytype = ? WHERE fid = ?;";
        Object[] updateParams = new Object[]{"A", "A", 0L};
        ArrayList insertParamsList = Lists.newArrayList();
        ArrayList updateParamList = Lists.newArrayList();
        String vaBaseSetProps = String.format("%s,%s,%s,%s", "id", "number", "timecalctype", "halfdaytype");
        QFilter isNotSysPreset = new QFilter("issyspreset", "!=", (Object)"1");
        QFilter timeCalcTypeIsEmpty = new QFilter("timecalctype", "=", (Object)" ").or("timecalctype", "=", null);
        HRBaseServiceHelper vaBaseSetHelper = new HRBaseServiceHelper("wtp_vabaseset");
        Object[] vaBaseSetArray = vaBaseSetHelper.query(vaBaseSetProps, new QFilter[]{isNotSysPreset, timeCalcTypeIsEmpty});
        if (ArrayUtils.isNotEmpty((Object[])vaBaseSetArray)) {
            for (Object obj : vaBaseSetArray) {
                Object[] params;
                if (obj == null) continue;
                if (obj.get("timecalctype") == null) {
                    params = Arrays.copyOf(insertParams, insertParams.length);
                    params[0] = obj.getPkValue();
                    insertParamsList.add(params);
                    continue;
                }
                params = Arrays.copyOf(updateParams, updateParams.length);
                params[2] = obj.getPkValue();
                updateParamList.add(params);
            }
            DBRoute wtp = new DBRoute("wtc");
            if (!CollectionUtils.isEmpty((Collection)insertParamsList)) {
                DB.executeBatch((DBRoute)wtp, (String)insertSql, (List)insertParamsList);
            }
            if (!CollectionUtils.isEmpty((Collection)updateParamList)) {
                DB.executeBatch((DBRoute)wtp, (String)updateSql, (List)updateParamList);
            }
        }
    }

    private void upgradeVaRuleData() {
        QFilter isNotSysPreset;
        String updateSql = "UPDATE t_wtp_varuleentry SET fisquota = ?, ftimebyshiftitemid = ?, ftimebydayitemid = ? WHERE fentryid = ?;";
        HRBaseServiceHelper vaRuleHelper = new HRBaseServiceHelper("wtp_varule");
        String vaRuleProps = String.format("%1$s,%2$s,%4$s,%5$s,%6$s,%7$s,%8$s", "id", "number", "entryentity", "isquota", "timebyshiftitem", "timebydayitem", "deductrule", "vabasesetid");
        Object[] vaRuleArray = vaRuleHelper.query(vaRuleProps, new QFilter[]{isNotSysPreset = new QFilter("issyspreset", "!=", (Object)"1")});
        if (ArrayUtils.isNotEmpty((Object[])vaRuleArray)) {
            ArrayList updateParamsList = Lists.newArrayList();
            for (Object obj : vaRuleArray) {
                DynamicObjectCollection entryEntity = obj.getDynamicObjectCollection("entryentity");
                if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
                for (DynamicObject entry : entryEntity) {
                    DynamicObject vaBaseSetDy;
                    Object[] params = new Object[]{"0", entry.getLong("timebyshiftitem.id"), entry.getLong("timebydayitem.id"), entry.getPkValue()};
                    if (entry.get("deductrule") != null) {
                        params[0] = "1";
                    }
                    if ((vaBaseSetDy = entry.getDynamicObject("vabasesetid")) != null && entry.get("timebyshiftitem") == null && entry.get("timebydayitem") == null) {
                        String timeCalcType = vaBaseSetDy.getString("timecalctype");
                        if ("A".equals(timeCalcType)) {
                            params[1] = 1743542207845043200L;
                        } else if ("B".equals(timeCalcType)) {
                            params[2] = 1743542207845043200L;
                        }
                    }
                    updateParamsList.add(params);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)updateParamsList)) {
                DBRoute wtp = new DBRoute("wtc");
                DB.executeBatch((DBRoute)wtp, (String)updateSql, (List)updateParamsList);
            }
        }
    }
}

