/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.vacation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class VaDateRangeUpgradeService {
    private static final Log LOG = LogFactory.getLog(VaDateRangeUpgradeService.class);
    private HRBaseServiceHelper vaRuleHelper = new HRBaseServiceHelper("wtp_varule");
    private HRBaseServiceHelper vaBaseSetHelper = new HRBaseServiceHelper("wtp_vabaseset");
    private static final String VA_BASESET_REPLACEMENT = "simpledaterange.wtp_vasimpledaterange";
    private static final String VA_BASESET_REG = "simpledaterange.wtbd_simpledaterangestd";
    private static final String VA_RULEENTRY_REPLACEMENT = "daterange.wtp_vadaterangestd";
    private static final String VA_RULEENTRY_REG = "daterange.wtbd_daterangestd";

    protected void upgrade() {
        LOG.info("\u5347\u7ea7\u4f11\u5047\u89c4\u5219\u548c\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u7684\u65e5\u671f\u8303\u56f4\u6570\u636e\u5f00\u59cb\u3002");
        this.upgradeVaRule();
        this.upgradeBaseSet();
        LOG.info("\u5347\u7ea7\u4f11\u5047\u89c4\u5219\u548c\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u7684\u65e5\u671f\u8303\u56f4\u6570\u636e\u7ed3\u675f\u3002");
    }

    private void upgradeBaseSet() {
        LOG.info("\u5347\u7ea7\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u7684\u65e5\u671f\u8303\u56f4\u6570\u636e\u5f00\u59cb");
        QFilter isSysQFilter = new QFilter("1", "=", (Object)1);
        DynamicObject[] baseSetDys = this.vaBaseSetHelper.loadDynamicObjectArray(new QFilter[]{isSysQFilter});
        Set<Long> baseSetIds = Arrays.stream(baseSetDys).map(baseSet -> baseSet.getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> dateRangeMap = this.getDateRangeData(baseSetIds, "wtp_vabaseset");
        ArrayList skipList = Lists.newArrayListWithCapacity((int)100);
        DynamicObjectCollection updateList = new DynamicObjectCollection();
        for (DynamicObject baseSetDy : baseSetDys) {
            long baseSetId = baseSetDy.getLong("id");
            String conditionExpOld = baseSetDy.getString("daterangecondition");
            if (StringUtils.isNotBlank((CharSequence)conditionExpOld)) {
                skipList.add(baseSetId);
                continue;
            }
            DynamicObject dateRangeDyn = dateRangeMap.get(baseSetId);
            if (dateRangeDyn != null) {
                String conditionExp = dateRangeDyn.getString("conditions");
                conditionExp = conditionExp.replaceAll(VA_BASESET_REG, VA_BASESET_REPLACEMENT);
                String dyCondition = baseSetDy.getString("daterangecondition");
                if (!StringUtils.isBlank((CharSequence)dyCondition)) continue;
                baseSetDy.set("daterangecondition", (Object)conditionExp);
                updateList.add((Object)baseSetDy);
                continue;
            }
            skipList.add(baseSetId);
        }
        LOG.info("update begin, updateList:{}", (Object)updateList.size());
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            this.vaBaseSetHelper.save(updateList);
        }
        if (!skipList.isEmpty()) {
            LOG.info("\u672a\u627e\u5230\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u5bf9\u5e94\u65e5\u671f\u8303\u56f4\u6570\u636e\uff0c\u8df3\u8fc7\u5347\u7ea7\uff1askipList:{}", (Object)skipList);
        }
        LOG.info("\u5347\u7ea7\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u7684\u65e5\u671f\u8303\u56f4\u6570\u636e\u7ed3\u675f.");
    }

    private void upgradeVaRule() {
        LOG.info("\u5347\u7ea7\u4f11\u5047\u89c4\u5219\u7684\u65e5\u671f\u8303\u56f4\u6570\u636e\u5f00\u59cb.");
        QFilter isSysQFilter = new QFilter("1", "=", (Object)1);
        DynamicObject[] vaRuleDys = this.vaRuleHelper.loadDynamicObjectArray(new QFilter[]{isSysQFilter});
        List ruleCalDys = Arrays.stream(vaRuleDys).map(vaRuleDy -> vaRuleDy.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).collect(Collectors.toList());
        Set<Long> baseDataIds = ruleCalDys.stream().map(dynamicObject -> dynamicObject.getLong("basedataid")).collect(Collectors.toSet());
        Map<Long, DynamicObject> dataRangeDataMap = this.getDateRangeData(baseDataIds, "wtp_vacalculrule");
        HashSet skipList = Sets.newHashSetWithExpectedSize((int)100);
        DynamicObjectCollection updateList = new DynamicObjectCollection();
        for (DynamicObject vaRuleDy2 : vaRuleDys) {
            DynamicObjectCollection vaRuleEntries = vaRuleDy2.getDynamicObjectCollection("entryentity");
            boolean isAdd = false;
            for (DynamicObject vaRuleEntry : vaRuleEntries) {
                long entryBaseDataId = vaRuleEntry.getLong("basedataid");
                if (entryBaseDataId == 0L) continue;
                DynamicObject dateRngeDyn = dataRangeDataMap.get(entryBaseDataId);
                if (dateRngeDyn == null) break;
                isAdd = true;
                String conditionExp = dateRngeDyn.getString("conditions");
                conditionExp = conditionExp.replaceAll(VA_RULEENTRY_REG, VA_RULEENTRY_REPLACEMENT);
                String datecangeCondition = vaRuleEntry.getString("daterangecondition");
                if (!StringUtils.isBlank((CharSequence)datecangeCondition)) continue;
                vaRuleEntry.set("daterangecondition", (Object)conditionExp);
            }
            if (isAdd) {
                updateList.add((Object)vaRuleDy2);
                continue;
            }
            skipList.add(vaRuleDy2.getLong("id"));
        }
        LOG.info("update begin, updateList:{}", (Object)updateList.size());
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            this.vaRuleHelper.save((DynamicObject[])updateList.toArray((Object[])new DynamicObject[0]));
        }
        if (!skipList.isEmpty()) {
            LOG.info("\u672a\u627e\u5230\u4f11\u5047\u89c4\u5219\u5bf9\u5e94\u65e5\u671f\u8303\u56f4\u6570\u636e\uff0c\u8df3\u8fc7\u5347\u7ea7\uff1askipList:{}", (Object)skipList);
        }
        LOG.info("\u5347\u7ea7\u4f11\u5047\u89c4\u5219\u7684\u65e5\u671f\u8303\u56f4\u6570\u636e\u7ed3\u675f.");
    }

    private Map<Long, DynamicObject> getDateRangeData(Set<Long> baseDataIds, String entityNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_daterange");
        QFilter pageFilter = new QFilter("metanumber", "=", (Object)entityNumber);
        if (CollectionUtils.isNotEmpty(baseDataIds)) {
            QFilter pkIdFilter = new QFilter("basedataid", "in", baseDataIds);
            pageFilter.and(pkIdFilter);
        }
        DynamicObject[] dataRangeData = serviceHelper.loadDynamicObjectArray(new QFilter[]{pageFilter});
        return Arrays.stream(dataRangeData).collect(Collectors.toMap(dateRangeDyn -> dateRangeDyn.getLong("basedataid"), dyn -> dyn, (d1, d2) -> d1));
    }
}

