/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.task.upgrade.vacation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCCommonHisService;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtp.business.task.upgrade.vacation.VaDateRangeUpgradeService;

public class VacationPlanUpgradeImpl
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(VacationPlanUpgradeImpl.class);
    private HRBaseServiceHelper vacationPlanHelper = new HRBaseServiceHelper("wtp_vacationplan");
    private HRBaseServiceHelper vaRuleHelper = new HRBaseServiceHelper("wtp_varule");
    private DynamicObject[] vaPlanArr;
    private Map<Long, Map<String, Object>> map = new HashMap<Long, Map<String, Object>>(16);
    private static final String VACATION_RULE_QUERY_STR = "select fid,fvatypeid,fattpolicyid,fvabasesetid,fvachangesetid,fvaitemid,froundruleid,froundruleitemid,fresultitemid from t_wtp_varule where fid in";

    protected String getJobId() {
        return "37Q83+QWFPQM";
    }

    protected String getScheduleId() {
        return "37Q8EX0T0V4=";
    }

    public boolean process() {
        LOG.info("VacationPlanUpgradeImpl start process...");
        this.beforeUpgrade();
        try (TXHandle txHandle = TX.required();){
            LOG.info("VacationPlanUpgradeImpl start ...");
            this.upgrade();
            LOG.info("VacationPlanUpgradeImpl end ...");
            VaDateRangeUpgradeService vaDateRangeUpgradeService = new VaDateRangeUpgradeService();
            vaDateRangeUpgradeService.upgrade();
        }
        return true;
    }

    private void upgrade() {
        if (this.vaPlanArr == null || this.vaPlanArr.length == 0) {
            return;
        }
        List<DynamicObject> vaPlanList = Arrays.asList(this.vaPlanArr);
        Map currentVersionMap = vaPlanList.stream().filter(vaPlan -> vaPlan.getBoolean("iscurrentversion")).collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity()));
        for (DynamicObject vaPlan2 : vaPlanList) {
            long ruleBoid;
            if (vaPlan2.getBoolean("iscurrentversion") && "C".equalsIgnoreCase(vaPlan2.getString("status"))) continue;
            Date bsed = vaPlan2.getDate("bsed");
            Date blsed = vaPlan2.getDate("bsled");
            DynamicObjectCollection vaRuleEntryEntity = vaPlan2.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)vaRuleEntryEntity)) continue;
            DynamicObject emptyDy = this.vaRuleHelper.generateEmptyDynamicObject();
            String hisversion = vaPlan2.getString("hisversion");
            hisversion = HRStringUtils.isEmpty((String)hisversion) ? System.currentTimeMillis() + "" : hisversion;
            String mark = "_" + WTCDateUtils.date2Str((Date)bsed, (String)"yyyy-MM-dd") + "_" + hisversion;
            ILocaleString localeString = vaPlan2.getLocaleString("name");
            String localeValueZhCn = localeString.getLocaleValue_zh_CN();
            String localeValueZhTw = localeString.getLocaleValue_zh_TW();
            String localeValueEn = localeString.getLocaleValue_en();
            LocaleString ruleLocalString = new LocaleString();
            if (!HRStringUtils.isEmpty((String)localeValueZhCn)) {
                ruleLocalString.setLocaleValue_zh_CN(localeValueZhCn + mark);
            }
            if (!HRStringUtils.isEmpty((String)localeValueZhTw)) {
                ruleLocalString.setLocaleValue_zh_TW(localeValueZhTw + mark);
            }
            if (!HRStringUtils.isEmpty((String)localeValueEn)) {
                ruleLocalString.setLocaleValue_en(localeValueEn + mark);
            }
            emptyDy.set("number", (Object)(vaPlan2.getString("number") + mark));
            emptyDy.set("name", (Object)ruleLocalString);
            emptyDy.set("bsed", (Object)bsed);
            emptyDy.set("bsled", (Object)blsed);
            emptyDy.set("firstbsed", (Object)vaPlan2.getDate("firstbsed"));
            emptyDy.set("createorg", (Object)vaPlan2.getLong("createorg.id"));
            emptyDy.set("org", (Object)vaPlan2.getLong("org.id"));
            emptyDy.set("useorg", (Object)vaPlan2.getLong("useorg.id"));
            emptyDy.set("ctrlstrategy", (Object)vaPlan2.getString("ctrlstrategy"));
            emptyDy.set("enable", (Object)"1");
            emptyDy.set("versionsource", (Object)"1");
            DynamicObjectCollection dynamicObjectCollection = emptyDy.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < vaRuleEntryEntity.size(); ++i) {
                DynamicObject vaRule = (DynamicObject)vaRuleEntryEntity.get(i);
                long vaRuleId = vaRule.getLong("vacationrule.id");
                Map<String, Object> rowMap = this.map.get(vaRuleId);
                if (CollectionUtils.isEmpty(rowMap)) continue;
                DynamicObject entry = dynamicObjectCollection.addNew();
                entry.set("seq", (Object)(i + 1));
                entry.set("vatype", rowMap.get("fvatypeid"));
                entry.set("attpolicy", rowMap.get("fattpolicyid"));
                entry.set("vabasesetid", rowMap.get("fvabasesetid"));
                entry.set("vachangesetid", rowMap.get("fvachangesetid"));
                entry.set("vaitem", rowMap.get("fvaitemid"));
                entry.set("roundrule", rowMap.get("froundruleid"));
                entry.set("roundruleitem", rowMap.get("froundruleitemid"));
                entry.set("resultitem", rowMap.get("fresultitemid"));
                entry.set("basedataid", (Object)vaRuleId);
            }
            HisResponse versionChangeRespDataHisResponse = WTCCommonHisService.saveTimeHisModelData((DynamicObject[])new DynamicObject[]{emptyDy}, (String)"wtp_varule", null, (Boolean)Boolean.FALSE);
            VersionChangeRespData data = (VersionChangeRespData)versionChangeRespDataHisResponse.getData();
            Object[] newDynamicObjects = data.getNewDynamicObjects();
            long l = ruleBoid = WTCCollectionIndexUtil.getEleFromArr((Object[])newDynamicObjects, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromArr((Object[])newDynamicObjects, (int)0).get()).getLong("boid") : 0L;
            if (ruleBoid == 0L) continue;
            vaPlan2.set("varule", (Object)ruleBoid);
            this.vacationPlanHelper.updateDataOne(vaPlan2);
            long boid = vaPlan2.getLong("boid");
            DynamicObject currentVersionDy = (DynamicObject)currentVersionMap.get(boid);
            if (currentVersionDy == null || !"1".equals(vaPlan2.getString("datastatus"))) continue;
            currentVersionDy.set("varule", (Object)ruleBoid);
            this.vacationPlanHelper.updateDataOne(currentVersionDy);
        }
    }

    private void beforeUpgrade() {
        QFilter filter = new QFilter("varule", "is null", null).or(new QFilter("varule", "=", (Object)0L));
        QFilter entryFilter = new QFilter("entryentity", "is not null", null);
        this.vaPlanArr = this.vacationPlanHelper.loadDynamicObjectArray(new QFilter[]{filter, entryFilter});
        if (this.vaPlanArr.length == 0) {
            return;
        }
        HashSet<Long> vaRuleIdSet = new HashSet<Long>(16);
        ArrayList strList = new ArrayList(this.vaPlanArr.length);
        for (DynamicObject vaPlan : this.vaPlanArr) {
            DynamicObjectCollection vaRuleCollection = vaPlan.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : vaRuleCollection) {
                DynamicObject vaRule = dynamicObject.getDynamicObject("vacationrule");
                long vaRuleId = vaRule.getLong("id");
                vaRuleIdSet.add(vaRuleId);
            }
        }
        vaRuleIdSet.forEach(ruleId -> strList.add("?"));
        String inStr = "(" + String.join((CharSequence)",", strList) + ");";
        DBRoute dbRoute = new DBRoute("wtc");
        try (DataSet vaRuleDataSet = null;){
            vaRuleDataSet = HRDBUtil.queryDataSet((String)"VacationPlanUpgradeImpl", (DBRoute)dbRoute, (String)(VACATION_RULE_QUERY_STR + inStr), (Object[])vaRuleIdSet.toArray());
            while (vaRuleDataSet.hasNext()) {
                HashMap<String, Long> rowMap = new HashMap<String, Long>();
                Row row = vaRuleDataSet.next();
                rowMap.put("fid", row.getLong("fid"));
                rowMap.put("fvatypeid", row.getLong("fvatypeid"));
                rowMap.put("fattpolicyid", row.getLong("fattpolicyid"));
                rowMap.put("fvabasesetid", row.getLong("fvabasesetid"));
                rowMap.put("fvachangesetid", row.getLong("fvachangesetid"));
                rowMap.put("fvaitemid", row.getLong("fvaitemid"));
                rowMap.put("froundruleid", row.getLong("froundruleid"));
                rowMap.put("froundruleitemid", row.getLong("froundruleitemid"));
                rowMap.put("fresultitemid", row.getLong("fresultitemid"));
                this.map.put(row.getLong("fid"), rowMap);
            }
        }
    }
}

