/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.timecombination;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class TimeCombinationUtils {
    private boolean tipflag = false;

    public boolean verifyShiftPeriod(DynamicObjectCollection dynamicObjectCollection) {
        HashMap shiftTimeMap = new HashMap(16);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject dynamicObjectTime = dynamicObject.getDynamicObject("shiftinner");
            if (dynamicObjectTime == null) continue;
            if (dynamicObjectTime.getBoolean("shiftstarttime")) {
                this.checkConflict(dynamicObject, shiftTimeMap, "shiftstarttime", "shiftstart", true);
            }
            if (dynamicObjectTime.getBoolean("shiftendtime")) {
                this.checkConflict(dynamicObject, shiftTimeMap, "shiftendtime", "shiftend", true);
            }
            if (!dynamicObjectTime.getBoolean("shiftofftime")) continue;
            this.checkConflict(dynamicObject, shiftTimeMap, "shiftofftime", "shiftoff", true);
        }
        return this.tipflag;
    }

    public boolean verifyTargetTypePeriod(DynamicObjectCollection dynamicObjectCollection) {
        HashMap<String, Boolean> monthmap = new HashMap<String, Boolean>(16);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            QFilter boFilter;
            HRBaseServiceHelper hisServiceHelper;
            DynamicObject[] oldBoDatas;
            String datatype;
            DynamicObject dynamicObjectTime = dynamicObject.getDynamicObject("typeid");
            if (dynamicObjectTime == null || !"C".equals(datatype = dynamicObjectTime.getString("datatype")) || (oldBoDatas = (hisServiceHelper = new HRBaseServiceHelper("wtam_shift_type")).loadDynamicObjectArray(new QFilter[]{boFilter = new QFilter("id", "in", dynamicObjectTime.get("masterid"))})) == null || oldBoDatas.length <= 0) continue;
            for (DynamicObject dynamicObject2 : oldBoDatas[0].getDynamicObjectCollection("entryentity3")) {
                String month = dynamicObject2.getString("week");
                if (monthmap.get(month) == null) {
                    monthmap.put(month, Boolean.TRUE);
                    continue;
                }
                this.tipflag = true;
            }
        }
        return this.tipflag;
    }

    private void checkConflict(DynamicObject dynamicObject, Map map, String key, String shiftKey, boolean flag) {
        if (map.containsKey(key)) {
            this.tipflag = true;
        } else {
            map.put(key, Boolean.TRUE);
        }
        if (flag) {
            dynamicObject.set(shiftKey, (Object)"\u2714");
        }
    }
}

