/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.timecut;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.rulecontrol.ConditionValidateService;
import kd.wtc.wtbs.business.rulecontrol.entity.RuleValidateInfo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtp.common.kdstring.TimeCutKDString;

public class TimeCutValidatorHelper {
    private static final List<String> CONDITION_EXPRESS_TYPE_CONSTANTS = Arrays.asList("0", "1");
    private static final List<String> CONDITION_NEED_VALUES_OPERATORS_CONSTANTS = Arrays.asList("==", "in", "not_in", "!=");

    public static boolean checkCondition(String dayType, String conditionStr) {
        if (WTCStringUtils.isEmpty((String)conditionStr)) {
            return true;
        }
        RuleValidateInfo conditionValidate = ConditionValidateService.validCondition((String)conditionStr, (boolean)true);
        if (!conditionValidate.isSuccess()) {
            if (WTCCollections.isNotEmpty((Collection)conditionValidate.getMsgList())) {
                throw new KDBizException(dayType + WTCSymbolMultiLanguageUtil.getColonSymbol() + (String)conditionValidate.getMsgList().get(0));
            }
            throw new KDBizException(TimeCutKDString.getConditionValidateFailStr((Object[])new Object[]{dayType}));
        }
        AccessDto condDto = TimeCutValidatorHelper.readRuleFromJsonStr(conditionStr);
        boolean isEmptyCondition = WTCCollections.isEmpty((Collection)condDto.getConditionList());
        if (!isEmptyCondition) {
            for (ConditionDto cond : condDto.getConditionList()) {
                boolean operatorValueUnValid;
                boolean bl = operatorValueUnValid = CONDITION_NEED_VALUES_OPERATORS_CONSTANTS.contains(cond.getOperators()) && WTCStringUtils.isEmpty((String)cond.getValue());
                if (!operatorValueUnValid && !WTCStringUtils.isEmpty((String)cond.getParam())) continue;
                throw new KDBizException(TimeCutKDString.getConfigEditNotifyStr6((Object[])new Object[]{dayType, cond.getName()}));
            }
        }
        return isEmptyCondition;
    }

    public static boolean emptyCondition(String conditionStr) {
        if (WTCStringUtils.isEmpty((String)conditionStr)) {
            return true;
        }
        AccessDto condDto = TimeCutValidatorHelper.readRuleFromJsonStr(conditionStr);
        return WTCCollections.isEmpty((Collection)condDto.getConditionList());
    }

    public static boolean unSameCondition(String condStr1, String condStr2) {
        if (TimeCutValidatorHelper.emptyCondition(condStr1) && TimeCutValidatorHelper.emptyCondition(condStr2)) {
            return false;
        }
        if (!TimeCutValidatorHelper.emptyCondition(condStr1) && TimeCutValidatorHelper.emptyCondition(condStr2) || TimeCutValidatorHelper.emptyCondition(condStr1) && !TimeCutValidatorHelper.emptyCondition(condStr2)) {
            return true;
        }
        boolean passed = true;
        AccessDto condDto1 = TimeCutValidatorHelper.readRuleFromJsonStr(condStr1);
        List condList1 = condDto1.getConditionList();
        String condType1 = condDto1.getConditionExpressType();
        Map<String, Integer> condStrMap1 = TimeCutValidatorHelper.getCondStrMap(condList1);
        if (CONDITION_EXPRESS_TYPE_CONSTANTS.contains(condType1)) {
            AccessDto condDto2 = TimeCutValidatorHelper.readRuleFromJsonStr(condStr2);
            List condList2 = condDto2.getConditionList();
            String condType2 = condDto2.getConditionExpressType();
            if (condList1.size() == condList2.size() && WTCStringUtils.equals((String)condType2, (String)condType1)) {
                Map<String, Integer> condStrMap2 = TimeCutValidatorHelper.getCondStrMap(condList2);
                if (condStrMap1.size() == condStrMap2.size()) {
                    AtomicBoolean same = new AtomicBoolean(true);
                    condStrMap2.forEach((condStr, count) -> {
                        Integer dayCount = (Integer)condStrMap1.get(condStr);
                        if (dayCount == null || !dayCount.equals(count)) {
                            same.set(false);
                        }
                    });
                    passed = !same.get();
                }
            }
        }
        return passed;
    }

    private static Map<String, Integer> getCondStrMap(List<ConditionDto> condList) {
        HashMap<String, Integer> condStrMap = new HashMap<String, Integer>();
        for (ConditionDto cond : condList) {
            String param = cond.getParam();
            String operators = cond.getOperators();
            String value = cond.getValue();
            String conditionStr = param + operators + value;
            if (condStrMap.containsKey(conditionStr)) {
                condStrMap.put(conditionStr, 1 + (Integer)condStrMap.get(conditionStr));
                continue;
            }
            condStrMap.put(conditionStr, 1);
        }
        return condStrMap;
    }

    public static boolean isAllSame(String condStr, String ... params) {
        boolean allSame = false;
        if (TimeCutValidatorHelper.emptyCondition(condStr)) {
            return allSame;
        }
        AccessDto condDto = TimeCutValidatorHelper.readRuleFromJsonStr(condStr);
        Map<String, Integer> condCountMap = TimeCutValidatorHelper.getCondStrMap(condDto.getConditionList());
        for (String param : params) {
            condCountMap.remove(param);
        }
        if (WTCMaps.isEmpty(condCountMap)) {
            allSame = true;
        }
        return allSame;
    }

    public static boolean isAllSameTimeCut(String condStr, String ... params) {
        if (TimeCutValidatorHelper.emptyCondition(condStr)) {
            return true;
        }
        return TimeCutValidatorHelper.isAllSame(condStr, params);
    }

    public static AccessDto readRuleFromJsonStr(String condStr) {
        AccessDto accessDto;
        try {
            accessDto = (AccessDto)SerializationUtils.fromJsonString((String)condStr, AccessDto.class);
        }
        catch (RuntimeException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u53c2\u6570\u89e3\u6790\u5931\u8d25\u3002", (String)"TimeCutValidatorHelper_0", (String)"wtc-wtp-business", (Object[])new Object[0]));
        }
        return accessDto;
    }
}

