/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.upgrade;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.ruleenging.RuleEngingService;
import kd.wtc.wtp.common.constants.RuleEngingConstants;
import kd.wtc.wtp.constants.upgrade.UpgradeKDString;

public class RuleEngineUpgradeService
implements RuleEngingConstants {
    private static final Log log = LogFactory.getLog(RuleEngineUpgradeService.class);
    private static final String PAGE_BRM_SCENE = "brm_scene";
    private static final String BRM_POLICY_EDIT = "brm_policy_edit";
    private static final String WTP_RULEASSOCIATION = "wtp_ruleassociation";
    private static final Map<String, String> FIELD_MAP = Maps.newHashMapWithExpectedSize((int)128);

    public void startUpgradeTask() {
        log.info("RuleEngineUpgradeTask, start");
        HRBaseServiceHelper helper = new HRBaseServiceHelper(PAGE_BRM_SCENE);
        HashSet<String> sceneNumbers = new HashSet<String>(16);
        sceneNumbers.add("wtc_scene_idp");
        sceneNumbers.add("wtc_scene_vacation");
        sceneNumbers.add("wtc_scene_exception");
        sceneNumbers.add("wtc_scene_ad");
        sceneNumbers.add("wtc_scene_attendplan");
        sceneNumbers.add("wtc_scene_otp");
        sceneNumbers.add("wtc_scene_tp");
        DynamicObject[] sceneDys = helper.query("id,number", new QFilter[]{new QFilter("number", "in", sceneNumbers)});
        if (sceneDys.length < 1) {
            log.info("RuleEngineUpgradeTask, scene not found");
            return;
        }
        HashMap<Long, String> sceneMap = new HashMap<Long, String>(sceneDys.length);
        for (DynamicObject scene : sceneDys) {
            sceneMap.put(scene.getLong("id"), scene.getString("number") + "_v2");
        }
        Set sceneIds = Arrays.stream(sceneDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HashSet<String> newSceneNumbers = new HashSet<String>(16);
        newSceneNumbers.add("wtc_scene_idp_v2");
        newSceneNumbers.add("wtc_scene_vacation_v2");
        newSceneNumbers.add("wtc_scene_exception_v2");
        newSceneNumbers.add("wtc_scene_ad_v2");
        newSceneNumbers.add("wtc_scene_attendplan_v2");
        newSceneNumbers.add("wtc_scene_otp_v2");
        newSceneNumbers.add("wtc_scene_tp_v2");
        DynamicObject[] newSceneDys = helper.query("id,number", new QFilter[]{new QFilter("number", "in", newSceneNumbers)});
        HashMap<String, Long> newSceneMap = new HashMap<String, Long>(sceneDys.length);
        for (DynamicObject scene : newSceneDys) {
            newSceneMap.put(scene.getString("number"), scene.getLong("id"));
        }
        HRBaseServiceHelper brmHelper = new HRBaseServiceHelper(BRM_POLICY_EDIT);
        DynamicObject[] policyDys = brmHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("scene.id", "in", sceneIds)});
        if (policyDys.length < 1) {
            log.info("RuleEngineUpgradeTask, policy not found");
            return;
        }
        HRBaseServiceHelper associationHelper = new HRBaseServiceHelper(WTP_RULEASSOCIATION);
        Set policyIds = Arrays.stream(policyDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] associationDys = associationHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("policyid", "in", policyIds), new QFilter("ruleset", "=", (Object)"2")});
        if (associationDys.length < 1) {
            log.info("RuleEngineUpgradeTask, wtp_ruleassociation not found");
            return;
        }
        for (DynamicObject policyDy : policyDys) {
            long policyId = policyDy.getLong("id");
            long sceneId = policyDy.getLong("scene.id");
            String sceneNumber = (String)sceneMap.get(sceneId);
            if (StringUtils.isEmpty((String)sceneNumber)) continue;
            long newSceneId = (Long)newSceneMap.get(sceneNumber);
            for (DynamicObject associationDy : associationDys) {
                long asPolicyId = associationDy.getLong("policyid");
                if (policyId != asPolicyId) continue;
                Map<String, Object> policyMap = this.getPolicyMap(policyDy, newSceneId);
                log.info("RuleEngineUpgradeTask.invoke interface.requestMap:{}", policyMap);
                Map resultMap = (Map)WTCServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"addPolicy", (Object[])new Object[]{policyMap});
                if (!resultMap.containsKey("resultCode") || (Integer)resultMap.get("resultCode") == 500) {
                    log.info("RuleEngineUpgradeTask, invoke interface fail,message[{}]", resultMap.get("errorMsg"));
                    continue;
                }
                Long newPolicyId = (Long)resultMap.get("policyId");
                associationDy.set("policyid", (Object)newPolicyId);
                log.info("RuleEngineUpgradeTask, invoke interface success,policy[{}],new policy[{}]", (Object)policyId, (Object)newPolicyId);
                Object result = associationHelper.updateOne(associationDy);
                log.info("RuleEngineUpgradeTask, update association size[{}]", null == result ? Integer.valueOf(0) : result);
            }
        }
        log.info("RuleEngineUpgradeTask, end");
    }

    private boolean genConditionDto(List<ConditionDto> list, boolean flag, StringBuilder sbCondition) {
        for (ConditionDto conditionDto : list) {
            String param = conditionDto.getParam();
            String reParam = FIELD_MAP.get(param);
            if (HRStringUtils.isEmpty((String)reParam)) {
                sbCondition.append(conditionDto.getDisplayParam()).append(" ").append(conditionDto.getOperators()).append(" ").append(conditionDto.getDisplayValue()).append("\uff1b");
                flag = true;
                reParam = "wtp_attfilebase.wtp_attfilebase.number";
                conditionDto.setDisplayParam(UpgradeKDString.attFile());
                conditionDto.setParamType("string");
                conditionDto.setOperators("==");
                conditionDto.setDisplayValue(UpgradeKDString.invalidCondition());
                conditionDto.setValue(UpgradeKDString.invalidCondition());
            }
            conditionDto.setParam(reParam);
        }
        return flag;
    }

    private Map<String, Object> getPolicyMap(DynamicObject dy, long newSceneId) {
        DynamicObjectCollection entryRuleListDys;
        HashMap<String, Object> policyMap = new HashMap<String, Object>(32);
        String name = dy.getString("name");
        String newName = name.split("_")[0];
        String codeRuleNumber = RuleEngingService.getCodeRuleNumber();
        policyMap.put("name", newName + codeRuleNumber);
        String number = dy.getString("number");
        String newNumber = number + codeRuleNumber;
        if (newNumber.length() > 50) {
            newNumber = newNumber.substring(0, 50);
        }
        policyMap.put("number", newNumber);
        policyMap.put("createbu", dy.getLong("createbu.id"));
        policyMap.put("policymode", dy.getString("policymode"));
        policyMap.put("bizappid", dy.getString("bizappid.id"));
        policyMap.put("scene", newSceneId);
        policyMap.put("enable", "1");
        policyMap.put("results", dy.getString("results"));
        policyMap.put("description", dy.getString("description"));
        List<Map<String, Object>> entryRuleList = this.getEntryRuleList(dy);
        if (!CollectionUtils.isEmpty(entryRuleList)) {
            policyMap.put("entryrulelist", entryRuleList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(entryRuleListDys = dy.getDynamicObjectCollection("entrybulist")))) {
            ArrayList entryBuList = new ArrayList(2);
            for (DynamicObject object : entryRuleListDys) {
                HashMap<String, Constable> map = new HashMap<String, Constable>(4);
                map.put("entitybu", Long.valueOf(object.getLong("entitybu.id")));
                map.put("containssub", Boolean.valueOf(object.getBoolean("containssub")));
                entryBuList.add(map);
            }
            policyMap.put("entrybulist", entryBuList);
        }
        return policyMap;
    }

    private List<Map<String, Object>> getEntryRuleList(DynamicObject dy) {
        ArrayList<Map<String, Object>> entryRuleList = new ArrayList<Map<String, Object>>(8);
        DynamicObjectCollection entryRuleListDys = dy.getDynamicObjectCollection("entryrulelist");
        if (null == entryRuleListDys || entryRuleListDys.size() == 0) {
            return entryRuleList;
        }
        for (DynamicObject object : entryRuleListDys) {
            AccessDto accessDto;
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            OrmLocaleValue desc = (OrmLocaleValue)object.get("ruledescription");
            String condition = object.getString("filtercondition");
            OrmLocaleValue ruleName = (OrmLocaleValue)object.get("rulename");
            try {
                accessDto = (AccessDto)SerializationUtils.fromJsonString((String)condition, AccessDto.class);
            }
            catch (Exception e) {
                throw new KDBizException("parse error");
            }
            List list = accessDto.getConditionList();
            boolean flag = false;
            StringBuilder sbCondition = new StringBuilder(UpgradeKDString.condition());
            if (this.genConditionDto(list, flag, sbCondition)) {
                String description = sbCondition.toString();
                if (sbCondition.length() > 200) {
                    description = description.substring(0, 200);
                }
                desc.setLocaleValue(description);
                ruleName.setLocaleValue(UpgradeKDString.invalid() + RuleEngingService.getCodeRuleNumber());
            }
            if (ruleName.getLocaleValue().length() > 50) {
                ruleName.setLocaleValue(ruleName.getLocaleValue().substring(0, 50));
            }
            map.put("rulename", ruleName.getLocaleValue());
            map.put("rulenumber", object.getString("rulenumber"));
            map.put("ruleorder", object.getInt("ruleorder"));
            map.put("ruleenable", object.getBoolean("ruleenable"));
            map.put("ruledescription", desc.getLocaleValue());
            String conditionStr = SerializationUtils.toJsonString((Object)accessDto);
            map.put("filtercondition", conditionStr);
            map.put("filterresult", object.getString("filterresult"));
            entryRuleList.add(map);
        }
        return entryRuleList;
    }

    static {
        FIELD_MAP.put("wtp_attfilebase.wtp_attfilebase.number", "wtp_attfilebase.wtp_attfilebase.number");
        FIELD_MAP.put("wtp_attfilebase_rule.wtp_attfilebase_rule.number", "wtp_attfilebase.wtp_attfilebase.number");
        FIELD_MAP.put("wtp_attfilebase.wtp_attfilebase.mode", "wtp_attfilebase.wtp_attfilebase.mode");
        FIELD_MAP.put("wtp_attfilebase_rule.wtp_attfilebase_rule.mode", "wtp_attfilebase.wtp_attfilebase.mode");
        FIELD_MAP.put("hrpi_depemp.hrpi_depemp.adminorg.id", "wtp_attfilebase.wtp_attfilebase.adminorg.id");
        FIELD_MAP.put("hrpi_depemp_rule.hrpi_depemp_rule.adminorg.id", "wtp_attfilebase.wtp_attfilebase.adminorg.id");
        FIELD_MAP.put("hrpi_empjobrel.hrpi_empjobrel.adminorg.id", "wtp_attfilebase.wtp_attfilebase.adminorg.id");
        FIELD_MAP.put("hrpi_empjobrel_rule.hrpi_empjobrel_rule.adminorg.id", "wtp_attfilebase.wtp_attfilebase.adminorg.id");
        FIELD_MAP.put("wtp_attfilebase.wtp_attfilebase.org.id", "wtp_attfilebase.wtp_attfilebase.org.id");
        FIELD_MAP.put("wtp_attfilebase_rule.wtp_attfilebase_rule.org.id", "wtp_attfilebase.wtp_attfilebase.org.id");
        FIELD_MAP.put("wtp_attfilebase.wtp_attfilebase.affiliateadminorg.id", "wtp_attfilebase.wtp_attfilebase.affiliateadminorg.id");
        FIELD_MAP.put("wtp_attfilebase_rule.wtp_attfilebase_rule.affiliateadminorg.id", "wtp_attfilebase.wtp_attfilebase.affiliateadminorg.id");
        FIELD_MAP.put("wtp_attfilebase.wtp_attfilebase.dependency.id", "wtp_attfilebase.wtp_attfilebase.dependency.id");
        FIELD_MAP.put("wtp_attfilebase_rule.wtp_attfilebase_rule.dependency.id", "wtp_attfilebase.wtp_attfilebase.dependency.id");
        FIELD_MAP.put("wtp_attfilebase.wtp_attfilebase.dependencytype.id", "wtp_attfilebase.wtp_attfilebase.dependencytype.id");
        FIELD_MAP.put("wtp_attfilebase_rule.wtp_attfilebase_rule.dependencytype.id", "wtp_attfilebase.wtp_attfilebase.dependencytype.id");
        FIELD_MAP.put("hrpi_pernontsprop.hrpi_pernontsprop.nationality.id", "wtp_attendperson.wtp_attendperson.nationality.id");
        FIELD_MAP.put("hrpi_pernontsprop_rule.hrpi_pernontsprop_rule.nationality.id", "wtp_attendperson.wtp_attendperson.nationality.id");
        FIELD_MAP.put("hrpi_employee.hrpi_employee.laborreltype.id", "wtp_attendperson.wtp_attendperson.laborreltype.id");
        FIELD_MAP.put("hrpi_depemp_rule.hrpi_depemp_rule.laborreltype.id", "wtp_attendperson.wtp_attendperson.laborreltype.id");
        FIELD_MAP.put("hrpi_empjobrel.hrpi_empjobrel.joblevel.id", "wtp_attendperson.wtp_attendperson.joblevel.id");
        FIELD_MAP.put("hrpi_empjobrel_rule.hrpi_empjobrel_rule.joblevel.id", "wtp_attendperson.wtp_attendperson.joblevel.id");
        FIELD_MAP.put("hrpi_empjobrel.hrpi_empjobrel.jobgrade.id", "wtp_attendperson.wtp_attendperson.jobgrade.id");
        FIELD_MAP.put("hrpi_empjobrel_rule.hrpi_empjobrel_rule.jobgrade.id", "wtp_attendperson.wtp_attendperson.jobgrade.id");
        FIELD_MAP.put("hrpi_pernontsprop.hrpi_pernontsprop.gender.id", "wtp_attendperson.wtp_attendperson.gender.id");
        FIELD_MAP.put("hrpi_pernontsprop_rule.hrpi_pernontsprop_rule.gender.id", "wtp_attendperson.wtp_attendperson.gender.id");
        FIELD_MAP.put("wtp_attendperson.wtp_attendperson.gender.id", "wtp_attendperson.wtp_attendperson.gender.id");
        FIELD_MAP.put("hrpi_depemp.hrpi_depemp.postype.id", "wtp_depempjob.wtp_depempjob.postype.id");
        FIELD_MAP.put("hrpi_depemp_rule.hrpi_depemp_rule.postype.id", "wtp_depempjob.wtp_depempjob.postype.id");
        FIELD_MAP.put("hrpi_depemp.hrpi_depemp.position.id", "wtp_depempjob.wtp_depempjob.position.id");
        FIELD_MAP.put("hrpi_empjobrel.hrpi_empjobrel.position.id", "wtp_depempjob.wtp_depempjob.position.id");
        FIELD_MAP.put("wtp_attfilebase_rule.wtp_attfilebase_rule.position.id", "wtp_depempjob.wtp_depempjob.position.id");
        FIELD_MAP.put("hrpi_depemp_rule.hrpi_depemp_rule.position.id", "wtp_depempjob.wtp_depempjob.position.id");
        FIELD_MAP.put("hrpi_empjobrel_rule.hrpi_empjobrel_rule.position.id", "wtp_depempjob.wtp_depempjob.position.id");
        FIELD_MAP.put("hrpi_empjobrel.hrpi_empjobrel.company.id", "wtp_depempjob.wtp_depempjob.company.id");
        FIELD_MAP.put("hrpi_empjobrel_rule.hrpi_empjobrel_rule.company.id", "wtp_depempjob.wtp_depempjob.company.id");
        FIELD_MAP.put("hrpi_empjobrel.hrpi_empjobrel.job.id", "wtp_depempjob.wtp_depempjob.job.id");
        FIELD_MAP.put("wtp_attfilebase_rule.wtp_attfilebase_rule.job.id", "wtp_depempjob.wtp_depempjob.job.id");
        FIELD_MAP.put("hrpi_empjobrel_rule.hrpi_empjobrel_rule.job.id", "wtp_depempjob.wtp_depempjob.job.id");
    }
}

