/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.upgrade;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class WTSSHomeRuleEngineUpgradeService {
    private static final Log log = LogFactory.getLog(WTSSHomeRuleEngineUpgradeService.class);
    public static final String NAME = "Name";
    public static final String ADMIN_ORG = "adminorg";
    public static final String ORG = "org";

    public void startUpgradeTask() {
        log.info("RuleEngineUpgradeTask, start");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("brm_scene");
        DynamicObject dynamicObject = helper.loadDynamicObject(new QFilter[]{new QFilter("number", "=", (Object)"wtc_scene_mobilescheme")});
        if (dynamicObject == null || dynamicObject.getLong("id") == 0L) {
            log.info("RuleEngineUpgradeTask, scene not found");
            return;
        }
        boolean updateRule = false;
        DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection("sceneinputparams");
        for (DynamicObject entry : entries) {
            String number = entry.getString("inputnumber");
            if (!StringUtils.equals((CharSequence)"attfilebase", (CharSequence)number)) continue;
            String propsText = entry.getString("inputdynprop");
            JSONArray props = JSONArray.parseArray((String)propsText);
            if (props == null) {
                props = new JSONArray();
            }
            boolean hasOrg = false;
            boolean hasAdminOrg = false;
            for (Object prop : props) {
                Map propMap = (Map)prop;
                Object name = propMap.get(NAME);
                if (name == null) continue;
                if (ORG.equals(name)) {
                    hasOrg = true;
                }
                if (!ADMIN_ORG.equals(name)) continue;
                hasAdminOrg = true;
            }
            if (!hasOrg) {
                JSONObject orgObj = JSONObject.parseObject((String)"{\"fDName\":\"\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\",\"fName\":\"\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\",\"Name\":\"org\"}");
                props.add((Object)orgObj);
                updateRule = true;
            }
            if (!hasAdminOrg) {
                JSONObject adminOrgObj = JSONObject.parseObject((String)"{\"fDName\":\"\u884c\u653f\u7ec4\u7ec7\",\"fName\":\"\u884c\u653f\u7ec4\u7ec7\",\"Name\":\"adminorg\"}");
                props.add((Object)adminOrgObj);
                updateRule = true;
            }
            if (!updateRule) continue;
            propsText = props.toJSONString();
            entry.set("inputdynprop", (Object)propsText);
        }
        if (updateRule) {
            helper.updateOne(dynamicObject);
        }
    }
}

