/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.vaqt;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.wtc.wtbs.common.deduction.QTApplyReq;
import kd.wtc.wtbs.common.deduction.QTApplyResult;
import kd.wtc.wtbs.common.deduction.QTAtomApplyResponse;
import kd.wtc.wtbs.common.deduction.frozen.BillApplyEntryFrozenResult;
import kd.wtc.wtbs.common.deduction.frozen.FrozenApplyReq;
import kd.wtc.wtbs.common.deduction.frozen.FrozenResult;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaQueryReq;
import kd.wtc.wtbs.common.deduction.usable.UsableQuotaQueryResp;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtp.business.cumulate.trading.QTBillOuterService;

public final class VAQuotaHelper {
    public static QTAtomApplyResponse handleApplyReqAtom(QTApplyReq req) {
        return QTBillOuterService.handleApplyReqAtom(req);
    }

    public static List<UsableQuotaQueryResp> handleQueryReq(List<UsableQuotaQueryReq> reqList) {
        return QTBillOuterService.handleQueryReq(reqList);
    }

    public static UsableQuotaQueryResp handleQueryReq(UsableQuotaQueryReq req) {
        return QTBillOuterService.handleQueryReq(req);
    }

    public static List<FrozenResult> handleFrozenApplyReq(FrozenApplyReq req) {
        String operationType = null;
        if ("FROZEN".equals(req.getOperateType())) {
            operationType = "FROZEN";
        } else if ("UNFROZEN".equals(req.getOperateType())) {
            operationType = "UNFROZEN";
        } else if ("TRYFROZEN".equals(req.getOperateType())) {
            operationType = "TRYFROZEN";
        } else {
            throw new IllegalArgumentException("FrozenApplyReq only support operationType:FROZEN/UNFROZEN. but argument operationType us:" + req.getOperateType());
        }
        QTApplyReq qtReq = new QTApplyReq();
        qtReq.setBillType(req.getBillType());
        qtReq.setBillApplyList(req.getBillApplyList());
        qtReq.setOperateType(operationType);
        List<QTApplyResult> qtApplyResList = QTBillOuterService.handleApplyReqForeach(qtReq);
        return qtApplyResList.stream().map(qtApplyRes -> {
            FrozenResult res = new FrozenResult();
            res.setId(qtApplyRes.getId());
            res.setErrCode(qtApplyRes.getErrCode());
            res.setFrozenResult(qtApplyRes.getFrozenResult());
            res.setErrFrom(qtApplyRes.getCauseFrom());
            List<Object> entryResList = new LinkedList();
            if (WTCCollections.isNotEmpty((Collection)qtApplyRes.getQtBillApplyResList())) {
                entryResList = qtApplyRes.getQtBillApplyResList().stream().map(ele -> {
                    BillApplyEntryFrozenResult entryRes = new BillApplyEntryFrozenResult();
                    entryRes.setEntryId(ele.getEntryId());
                    entryRes.setSuccess(ele.isSuccess());
                    entryRes.setResultMsg(ele.getResultMsg());
                    entryRes.setErrCode(ele.getErrCode());
                    entryRes.setRetData(ele.getRetData());
                    return entryRes;
                }).collect(Collectors.toList());
            }
            res.setBillFrozenResultList(entryResList);
            return res;
        }).collect(Collectors.toList());
    }
}

