/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.cumulate.trading.DateRange;
import kd.wtc.wtp.business.cumulate.trading.QTDealRecordDBService;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.constants.quota.QTLineDetailConstants;
import kd.wtc.wtp.mservice.api.IQTService;

public class IQTServiceImpl
implements IQTService {
    Log LOG = LogFactory.getLog(IQTServiceImpl.class);
    private static final int USE_RANGE_LIMIT = 0;
    private static final int GEN_RANGE_LIMIT = 1;
    private static final int USE_AND_GEN_RANGE_LIMIT = 2;
    private static final int USE_OR_GEN_RANGE_LIMIT = 3;

    public List<DynamicObject> queryQuota(long attFileBoId, List<Long> qtTypeIdList, int rangQueryType, Date startDate, Date endDate) {
        DateRange range;
        ArrayList<DynamicObject> res = new ArrayList<DynamicObject>(16);
        if (attFileBoId <= 0L) {
            return res;
        }
        if (rangQueryType < 0 || rangQueryType > 3) {
            return res;
        }
        if (startDate == null || endDate == null) {
            range = DateRange.singleDay((Date)new Date());
        } else {
            if (startDate.getTime() > endDate.getTime()) {
                return res;
            }
            range = DateRange.range((Date)startDate, (Date)endDate);
        }
        return IQTServiceImpl.loadLineDetailDyn(QTLineDetailConstants.bizShowField, attFileBoId, qtTypeIdList, range, rangQueryType);
    }

    private static List<DynamicObject> loadLineDetailDyn(String selectField, long attFileBoId, List<Long> qtTypeIdList, DateRange range, int rangeQueryType) {
        if (attFileBoId <= 0L) {
            return new ArrayList<DynamicObject>(16);
        }
        QFilter filter = new QFilter("attfilebo", "=", (Object)attFileBoId);
        QFilter rangeFilter = null;
        if (rangeQueryType == 0) {
            rangeFilter = range.getFilterIntersectionLCRC("usestartdate", "useenddate");
        } else if (rangeQueryType == 1) {
            rangeFilter = range.getFilterIntersectionLCRC("genstartdate", "genenddate");
        } else if (rangeQueryType == 2) {
            rangeFilter = range.getFilterIntersectionLCRC("usestartdate", "useenddate").and(range.getFilterIntersectionLCRC("genstartdate", "genenddate"));
        } else if (rangeQueryType == 3) {
            rangeFilter = range.getFilterIntersectionLCRC("usestartdate", "useenddate").or(range.getFilterIntersectionLCRC("genstartdate", "genenddate"));
        } else {
            throw new IllegalArgumentException("rangeQueryType can't be " + rangeQueryType);
        }
        filter.and(rangeFilter);
        if (qtTypeIdList != null && !qtTypeIdList.isEmpty()) {
            filter.and("qttype.id", "in", qtTypeIdList);
        }
        DynamicObject[] dynamicObjectArray = WTCStringUtils.isEmpty((String)selectField) ? QTLineDetailDBService.lineDetailDao.loadDynamicObjectArray(filter.toArray()) : QTLineDetailDBService.lineDetailDao.query(selectField, filter.toArray());
        return Arrays.asList(dynamicObjectArray);
    }

    public void deleteQuota(List<Long> attFileBoIds) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IQTServiceImpl deleteQuota.attFileBoIds : {}", attFileBoIds);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (WTCCollections.isNotEmpty(attFileBoIds)) {
                    QTDealRecordDBService.deleteAllDealByFileBoId(attFileBoIds);
                    QTLineDetailDBService.deleteAllDealByFileBoId(attFileBoIds);
                }
            }
            catch (Exception ex) {
                tx.markRollback();
                this.LOG.error("IQTServiceImpl deleteQuota.ERROR", (Throwable)ex);
                throw ex;
            }
        }
    }
}

