/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.mservice.api.IPersonAttFileService;

public class PersonAttFileServiceImpl
implements IPersonAttFileService {
    private static final Log LOGGER = LogFactory.getLog(PersonAttFileServiceImpl.class);
    private static final String OLD_EMP_NUMBER = "oldempnumber";

    public Map<String, Object> modifyPersonNumber(Map<String, Object> param) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        result.put("success", true);
        Object dataObj = param.get("data");
        if (dataObj == null) {
            result.put("message", "param is null");
            return result;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("modifyPersonNumber param {}", (Object)SerializationUtils.toJsonString((Object)dataObj));
        }
        try {
            DynamicObject[] attPersonDyOldNumArr;
            DynamicObject[] attPersonDyArr;
            List personNumberData = (List)dataObj;
            if (personNumberData.size() > 10000) {
                result.put("success", false);
                result.put("message", "data size more then 10000");
                return result;
            }
            Map<String, String> personNumberMap = personNumberData.stream().filter(d -> WTCStringUtils.isNotEmpty((String)((String)d.get("oriNumber")))).collect(Collectors.toMap(personNumberDatum -> (String)personNumberDatum.get("oriNumber"), personNumberDatum -> (String)personNumberDatum.get("newNumber")));
            Set<String> oriPersonNumberSet = personNumberMap.keySet();
            HRBaseServiceHelper fileBaseServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
            HRBaseServiceHelper attPersonBaseServiceHelper = new HRBaseServiceHelper("wtp_attendperson");
            DynamicObject[] attFileDyArr = fileBaseServiceHelper.query("id,personnum", new QFilter[]{new QFilter("personnum", "in", oriPersonNumberSet)});
            if (attFileDyArr != null && attFileDyArr.length > 0) {
                for (DynamicObject attFile : attFileDyArr) {
                    this.updateDyPersonNumberByPro(personNumberMap, attFile, "personnum");
                }
                fileBaseServiceHelper.updateDatas(attFileDyArr);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("modifyPersonNumber update attFile size {}", (Object)attFileDyArr.length);
                }
            }
            if ((attPersonDyArr = attPersonBaseServiceHelper.query("id,number", new QFilter[]{new QFilter("number", "in", oriPersonNumberSet)})) != null && attPersonDyArr.length > 0) {
                for (DynamicObject attPerson : attPersonDyArr) {
                    this.updateDyPersonNumberByPro(personNumberMap, attPerson, "number");
                }
                attPersonBaseServiceHelper.updateDatas(attPersonDyArr);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("modifyPersonNumber update attPerson size {}", (Object)attPersonDyArr.length);
                }
            }
            if ((attPersonDyOldNumArr = attPersonBaseServiceHelper.query("id,oldempnumber", new QFilter[]{new QFilter(OLD_EMP_NUMBER, "in", oriPersonNumberSet)})) != null && attPersonDyOldNumArr.length > 0) {
                for (DynamicObject attPersonOldNum : attPersonDyOldNumArr) {
                    this.updateDyPersonNumberByPro(personNumberMap, attPersonOldNum, OLD_EMP_NUMBER);
                }
                attPersonBaseServiceHelper.updateDatas(attPersonDyOldNumArr);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("modifyPersonNumber update attPersonDyOldNumArr size {}", (Object)attPersonDyOldNumArr.length);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            result.put("success", false);
            result.put("message", exception.getMessage());
            return result;
        }
        return result;
    }

    public Map<String, String> modifyCompanyBoId(Set<Long> orgBoIdSet, Long companyId, Date effectDate) {
        int batchSize = 5000;
        String isSuccess = "isSuccess";
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        result.put(isSuccess, "true");
        if (WTCCollections.isEmpty(orgBoIdSet) || companyId == null || companyId == 0L) {
            result.put("errorMsg", "param is empty");
            return result;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("modifyCompanyBoId orgBoIdSet size = {},companyId = {}", (Object)orgBoIdSet.size(), (Object)companyId);
        }
        try {
            DynamicObject[] empPosOrgRelDyArr;
            HRBaseServiceHelper fileBaseServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
            HRBaseServiceHelper empPosOrgRelBaseServiceHelper = new HRBaseServiceHelper("wtp_depempjob");
            ArrayList batchFileDyList = Lists.newArrayListWithExpectedSize((int)batchSize);
            ArrayList batchEmpPosOrgRelDyList = Lists.newArrayListWithExpectedSize((int)batchSize);
            DynamicObject[] attFileDyArr = fileBaseServiceHelper.query("id,company,company.id", new QFilter[]{new QFilter("adminorg.id", "in", orgBoIdSet)});
            if (attFileDyArr != null && attFileDyArr.length > 0) {
                for (DynamicObject attFile : attFileDyArr) {
                    this.updateDyData(companyId, batchSize, fileBaseServiceHelper, batchFileDyList, attFile);
                }
                if (!batchFileDyList.isEmpty()) {
                    fileBaseServiceHelper.updateDatas(batchFileDyList.toArray(new DynamicObject[0]));
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("modifyCompanyBoId update attFile size {}", (Object)attFileDyArr.length);
                }
            }
            if ((empPosOrgRelDyArr = empPosOrgRelBaseServiceHelper.query("id,company,company.id", new QFilter[]{new QFilter("adminorg.id", "in", orgBoIdSet)})) != null && empPosOrgRelDyArr.length > 0) {
                for (DynamicObject empPosOrgRelDy : empPosOrgRelDyArr) {
                    this.updateDyData(companyId, batchSize, empPosOrgRelBaseServiceHelper, batchEmpPosOrgRelDyList, empPosOrgRelDy);
                }
                if (!batchEmpPosOrgRelDyList.isEmpty()) {
                    empPosOrgRelBaseServiceHelper.updateDatas(batchEmpPosOrgRelDyList.toArray(new DynamicObject[0]));
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("modifyCompanyBoId update empPosOrgRel size {}", (Object)empPosOrgRelDyArr.length);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            result.put(isSuccess, "false");
            result.put("errorMsg", exception.getMessage());
            return result;
        }
        return result;
    }

    private void updateDyData(Long companyId, int batchSize, HRBaseServiceHelper baseServiceHelper, List<DynamicObject> batchDyList, DynamicObject updateDy) {
        updateDy.set("company", (Object)companyId);
        batchDyList.add(updateDy);
        if (batchDyList.size() >= batchSize) {
            baseServiceHelper.updateDatas(batchDyList.toArray(new DynamicObject[0]));
            batchDyList.clear();
        }
    }

    private void updateDyPersonNumberByPro(Map<String, String> personNumberMap, DynamicObject attFile, String pro) {
        String attFileExistPersonNumber = attFile.getString(pro);
        String newPersonNumber = personNumberMap.get(attFileExistPersonNumber);
        if (HRStringUtils.isNotEmpty((String)newPersonNumber)) {
            attFile.set(pro, (Object)newPersonNumber);
        }
    }
}

