/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice.mockfile;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.web.WTCAttFileService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.mservice.mockfile.AttFileServiceParam;

@ApiController(desc="\u8003\u52e4\u6863\u6848\u5fae\u670d\u52a1API\u6d4b\u8bd5", value="AttFileApi")
@ApiMapping(value="/attFileApi")
public class AttFileApi
implements Serializable {
    private static final Log log = LogFactory.getLog(AttFileApi.class);
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attfilebase");

    @ApiPostMapping(desc="attFileApi", value="attFileApi")
    public CustomApiResult<Map<String, Object>> doCustomService(@ApiParam(value="\u5165\u53c2") @ApiParam(value="\u5165\u53c2") AttFileServiceParam attFileServiceParam) {
        HashMap res = Maps.newHashMap();
        AttFileQueryServiceImpl attFileQueryService = AttFileQueryServiceImpl.getInstance();
        AttFileQueryParam attFileQueryParam = this.createAttFileQueryParam(attFileServiceParam);
        Long startTime = System.currentTimeMillis();
        log.info("AttFileApi start  queryAttFiles {}", (Object)attFileServiceParam);
        List count = attFileQueryService.queryAttFiles(attFileQueryParam);
        Long endTime = System.currentTimeMillis();
        Long useTime = (endTime - startTime) / 1000L;
        log.info("AttFileApi queryAttFiles use time {} s ", (Object)useTime);
        CustomApiResult customApiResult = new CustomApiResult();
        res.put("useTime", useTime);
        if (!CollectionUtils.isEmpty((Collection)count)) {
            res.put("countSize", count.size());
        }
        customApiResult.setData((Object)res);
        if (customApiResult != null) {
            DistributeSessionlessCache redisCache = WTCCacheUtils.getCache();
            String cacheKey = WTCCacheUtils.getKey((String)"wtp", (String)"wtp_periodtaskdetail");
            Set set = (Set)JSON.parseObject((String)((String)redisCache.get(cacheKey)), Set.class);
            set.clear();
            redisCache.put(cacheKey, (Object)JSON.toJSONString((Object)set));
        }
        return customApiResult;
    }

    private AttFileQueryParam createAttFileQueryParam(AttFileServiceParam attFileServiceParam) {
        AttFileQueryParam attFileQueryParam = attFileServiceParam.getInitProperties() != null ? new AttFileQueryParam(attFileServiceParam.getInitProperties().booleanValue()) : new AttFileQueryParam();
        if (attFileServiceParam.getBeCurrent() != null) {
            attFileQueryParam.setBeCurrent(attFileServiceParam.getBeCurrent());
        }
        if (attFileServiceParam.getAuthCheck() != null) {
            attFileQueryParam.setBeCurrent(attFileServiceParam.getAuthCheck());
        }
        if (!StringUtils.isEmpty((CharSequence)attFileServiceParam.getAttStatus())) {
            AttStatusEnum attStatusEnum = AttStatusEnum.ATT_NORMAL.getCode().equals(attFileServiceParam.getAttStatus()) ? AttStatusEnum.ATT_NORMAL : AttStatusEnum.ATT_STOP;
            attFileQueryParam.setAttStatus(attStatusEnum);
        }
        if (attFileServiceParam.getStartDate() != null) {
            attFileQueryParam.setStartDate(attFileServiceParam.getStartDate());
        }
        if (attFileServiceParam.getEndDate() != null) {
            attFileQueryParam.setStartDate(attFileServiceParam.getEndDate());
        }
        if (attFileServiceParam.getBoId() != null) {
            attFileQueryParam.setBoId(attFileServiceParam.getBoId().longValue());
        }
        if (attFileServiceParam.getAttPersonId() != null) {
            attFileQueryParam.setAttPersonId(attFileServiceParam.getAttPersonId().longValue());
        }
        if (attFileServiceParam.getEmpGroupId() != null) {
            attFileQueryParam.setEmpGroupId(attFileServiceParam.getEmpGroupId().longValue());
        }
        if (attFileServiceParam.getEmpPosAdminOrgId() != null) {
            attFileQueryParam.setEmpGroupId(attFileServiceParam.getEmpPosAdminOrgId().longValue());
        }
        if (attFileServiceParam.getAffiliateAdminOrgId() != null) {
            attFileQueryParam.setAffiliateAdminOrgId(attFileServiceParam.getAffiliateAdminOrgId().longValue());
        }
        if (attFileServiceParam.getOrgId() != null) {
            attFileQueryParam.setOrgId(attFileServiceParam.getOrgId().longValue());
        }
        if (!StringUtils.isEmpty((CharSequence)attFileServiceParam.getProperties())) {
            attFileQueryParam.setProperties(attFileServiceParam.getProperties());
        }
        if (attFileServiceParam.getHisStatus() != null) {
            attFileQueryParam.setHisStatus(attFileServiceParam.getHisStatus());
        }
        if (attFileServiceParam.getLimitPersonIds() != null) {
            QFilter qFilter = WTCAttFileService.getAttFileStatusQFilter((Boolean)Boolean.TRUE);
            DynamicObject[] dys = helper.query("person.id,boid", new QFilter[]{qFilter});
            Set personids = Arrays.stream(dys).map(t -> t.getLong("person.id")).distinct().limit(attFileServiceParam.getLimitPersonIds() * 10000L).collect(Collectors.toSet());
            attFileQueryParam.setPersonSetIds(personids);
            log.info("AttFileApi query personids size {}", (Object)personids.size());
            if (attFileServiceParam.getLimitBoIds() != null) {
                Set boids = Arrays.stream(dys).map(t -> t.getLong("boid")).distinct().limit(attFileServiceParam.getLimitBoIds() * 10000L).collect(Collectors.toSet());
                attFileQueryParam.setSetBoIds(boids);
                log.info("AttFileApi query boids size {}", (Object)boids.size());
            }
        }
        return attFileQueryParam;
    }
}

