/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice.mockfile;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtp.mservice.mockfile.ApiParams;

public class MakePersonTool {
    private static final Log LOGGER = LogFactory.getLog(MakePersonTool.class);
    private Map<String, Object> params;
    private final Map<String, DynamicObject> basePropDataCache = new HashMap<String, DynamicObject>();

    public MakePersonTool(Map<String, Object> params) {
        this.params = params;
    }

    private DynamicObject getPersonDynamObject(long pkValue, DynamicObjectType dynamicObjectType) {
        DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
        dynamicObject.set("id", (Object)pkValue);
        this.initBaseData(dynamicObject);
        this.initLaborType(dynamicObject);
        this.setCommonData(dynamicObject);
        return dynamicObject;
    }

    private void initBaseData(DynamicObject setDynamicObject) {
        DataEntityPropertyCollection properties = setDynamicObject.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof BasedataProp) {
                String baseEntityName = ((BasedataProp)property).getBaseEntityId();
                DynamicObject dynamicObject = this.basePropDataCache.get(baseEntityName);
                if (dynamicObject == null) {
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(baseEntityName);
                    QFilter qf = new QFilter("enable", "=", (Object)"1");
                    dynamicObject = serviceHelper.queryOne("id", new QFilter[]{qf}, "number asc");
                    this.basePropDataCache.put(baseEntityName, dynamicObject);
                }
                if (null != dynamicObject) {
                    setDynamicObject.set(property.getName(), (Object)dynamicObject.getLong("id"));
                }
            }
            if (property instanceof DateProp) {
                setDynamicObject.set(property.getName(), (Object)ApiParams.getPersonDate(this.params.get("personDate")));
            }
            if (!(property instanceof IntegerProp)) continue;
            setDynamicObject.set(property.getName(), (Object)1);
        }
    }

    private void setCommonData(DynamicObject dynamicObject) {
        String number = this.getNumber();
        dynamicObject.set("empnumber", (Object)number);
        dynamicObject.set("number", (Object)number);
        dynamicObject.set("phone", (Object)this.getNo("180"));
        dynamicObject.set("name", (Object)number);
        dynamicObject.set("certificatenumber", (Object)this.getNo("420"));
    }

    private String getNumber() {
        String yyyyMMdd = new SimpleDateFormat("HHmmss").format(new Date());
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            String tmp = HRObjectUtils.isEmpty((Object)this.params.get("prefix")) ? "" : this.params.get("prefix");
            return tmp + "GJAPI" + yyyyMMdd + random.nextInt(100000);
        }
        catch (NoSuchAlgorithmException var4) {
            LOGGER.warn((Throwable)var4);
            return String.valueOf(System.currentTimeMillis());
        }
    }

    private String getNo(String pre) {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            return pre + random.nextInt(100000000);
        }
        catch (NoSuchAlgorithmException var4) {
            LOGGER.warn((Throwable)var4);
            return String.valueOf(System.currentTimeMillis());
        }
    }

    private void initLaborType(DynamicObject setDynamicObject) {
        DynamicObject dynamicObject = this.basePropDataCache.get("hpbs_affairaction");
        if (dynamicObject == null) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hpbs_affairaction");
            QFilter qFilter = new QFilter("number", "=", (Object)"1010_S");
            dynamicObject = serviceHelper.loadDynamicObject(new QFilter[]{qFilter});
            this.basePropDataCache.put("hpbs_affairaction", dynamicObject);
        }
        if (null != dynamicObject) {
            DynamicObjectCollection postentry = dynamicObject.getDynamicObjectCollection("postentry");
            DynamicObjectCollection laborentry = dynamicObject.getDynamicObjectCollection("laborentry");
            setDynamicObject.set("laborreltype", (Object)((DynamicObject)laborentry.get(0)).getLong("laborrelntype.id"));
            DynamicObjectCollection laborrelnstate = ((DynamicObject)laborentry.get(0)).getDynamicObjectCollection("laborrelnstate");
            setDynamicObject.set("laborrelstatus", (Object)((DynamicObject)laborrelnstate.get(0)).getLong("fbasedataid_id"));
            setDynamicObject.set("postype", (Object)((DynamicObject)postentry.get(0)).getLong("newpostype.id"));
            setDynamicObject.set("posstatus", (Object)((DynamicObject)postentry.get(0)).getLong("newpoststate.id"));
            setDynamicObject.set("variationtype", (Object)dynamicObject.getLong("affgeneraltype.id"));
            String isPrimary = ((DynamicObject)postentry.get(0)).getString("mainpostnop");
            if (HRStringUtils.isNotEmpty((String)isPrimary) && "03".equals(isPrimary)) {
                setDynamicObject.set("isprimary", (Object)1);
            } else {
                setDynamicObject.set("isprimary", (Object)0);
            }
        }
    }

    public DynamicObject[] makePersonOp(int limit) {
        DynamicObject[] tmp;
        if (limit <= 0 || limit > 1000) {
            limit = 1000;
        }
        long[] ids = DB.genGlobalLongIds((int)limit);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"hrpi_saveemployee");
        for (DynamicObject dynamicObject : tmp = (DynamicObject[])LongStream.of(ids).boxed().map(arg -> this.getPersonDynamObject((long)arg, (DynamicObjectType)entityType)).toArray(DynamicObject[]::new)) {
            OperationServiceHelper.executeOperate((String)"save", (String)"hrpi_saveemployee", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
        }
        return this.castData(tmp);
    }

    private DynamicObject[] castData(DynamicObject[] tmp) {
        List numberList = Stream.of(tmp).map(arg -> arg.getString("empnumber")).collect(Collectors.toList());
        QFilter filter = new QFilter("employee.empnumber", "in", numberList);
        DynamicObject[] empDyn = BusinessDataServiceHelper.load((String)"hrpi_empposorgrel", (String)"id,person,person.id,depemp,position,job,startdate", (QFilter[])new QFilter[]{filter});
        return Stream.of(empDyn).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(arg -> arg.getLong("person.id")))), ArrayList::new)).toArray(new DynamicObject[0]);
    }
}

