/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice.openapi.quota;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.DateRange;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.quota.QTLineDetailNumHelper;
import kd.wtc.wtp.mservice.openapi.quota.model.AbsQTQueryReq;
import kd.wtc.wtp.mservice.openapi.quota.model.QTDetailModel;
import kd.wtc.wtp.mservice.openapi.quota.model.QTDetailQueryReq;
import kd.wtc.wtp.mservice.openapi.quota.model.QTDetailQueryRes;
import kd.wtc.wtp.mservice.openapi.quota.model.QTSummaryModel;
import kd.wtc.wtp.mservice.openapi.quota.model.QTSummaryQueryReq;
import kd.wtc.wtp.mservice.openapi.quota.model.QTSummaryQueryRes;

@ApiController(desc="\u5b9a\u989d\u7ba1\u7406OpenApi", value="wtp")
@ApiMapping(value="/quota")
@ApiErrorCodes(value={@ApiErrorCode(code="0-999", desc="api system error"), @ApiErrorCode(code="10000-99999", desc="BOS\u5e73\u53f0\u5f02\u5e38"), @ApiErrorCode(code="wtp.100001", desc="\u53c2\u6570\u683c\u5f0f\u9519\u8bef"), @ApiErrorCode(code="wtp.100002", desc="\u67e5\u8be2\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406")})
public class QuotaOpenApi
implements Serializable {
    private static final long serialVersionUID = 2525475886335609163L;
    private static final Log LOG = LogFactory.getLog(QuotaOpenApi.class);
    private static final String attPersonNumber = "attfilebo.attperson.number";
    private static final String fileNumber = "attfilebo.number";
    private static final String orgNumber = "attfilebo.org.number";
    private static final String orgName = "attfilebo.org.name";
    private static final String adminOrgNumber = "attfilebo.adminorg.number";
    private static final String adminOrgName = "attfilebo.adminorg.name";
    private static final String qtTypeNumber = "qttype.number";
    private static final String qtTypeName = "qttype.name";
    private static final String qtTypeUnit = "qttype.unit";
    private static final int API_QUERY_MAX_FILE_SIZE;
    private static final String queryField;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="/getQuotSummary", desc="\u8c03\u7528\u672c\u63a5\u53e3\u67e5\u8be2\u67d0\u4eba/\u67d0\u4e9b\u4eba\u5728\u67d0\u65e5\u671f\u8303\u56f4\u5185\uff08\u6216\u67d0\u5929\uff09\u7684\u5b9a\u989d\u7c7b\u578b\u7684\u6c47\u603b\u6570\u636e\u3002")
    public CustomApiResult<QTSummaryQueryRes> getQuotaSummary(@ApiParam(value="\u8003\u52e4\u6863\u6848\u5bf9\u8c61id\u5217\u8868 \u4e3a\u5fc5\u586b\uff1b\u4f7f\u7528\u5f00\u59cb\u65e5\u671f\u3001\u4f7f\u7528\u7ed3\u675f\u65e5\u671f \u4e3a\u5fc5\u586b\uff1b\u751f\u6210\u5f00\u59cb\u65e5\u671f\u3001\u751f\u6210\u7ed3\u675f\u65e5\u671f \u4e3a\u9009\u586b\uff1b\u5b9a\u989d\u7c7b\u578bid\u3001\u5b9a\u989d\u7c7b\u578b\u7f16\u7801\u5fc5\u586b\u4e00\u4e2a\u3002", required=true, example="") @Valid @ApiParam(value="\u8003\u52e4\u6863\u6848\u5bf9\u8c61id\u5217\u8868 \u4e3a\u5fc5\u586b\uff1b\u4f7f\u7528\u5f00\u59cb\u65e5\u671f\u3001\u4f7f\u7528\u7ed3\u675f\u65e5\u671f \u4e3a\u5fc5\u586b\uff1b\u751f\u6210\u5f00\u59cb\u65e5\u671f\u3001\u751f\u6210\u7ed3\u675f\u65e5\u671f \u4e3a\u9009\u586b\uff1b\u5b9a\u989d\u7c7b\u578bid\u3001\u5b9a\u989d\u7c7b\u578b\u7f16\u7801\u5fc5\u586b\u4e00\u4e2a\u3002", required=true, example="") @Valid QTSummaryQueryReq req) {
        try {
            String errMsg = this.checkParamAndRetErrMsg(req);
            if (errMsg != null) {
                return CustomApiResult.fail((String)"wtp.100001", (String)errMsg);
            }
            if (req.getAttFileBoIds().isEmpty()) {
                QTSummaryQueryRes res = new QTSummaryQueryRes();
                res.setQtSummaryModelList(new LinkedList<QTSummaryModel>());
                return CustomApiResult.success((Object)res);
            }
            QFilter fileBoIdFilter = new QFilter("attfilebo", "in", req.getAttFileBoIds());
            QFilter qtTypeIdFilter = this.getQTTypeIdFilter(req);
            QFilter dateRangeFilter = this.genDateRangeFilter(req);
            QFilter effectFilter = QTLineDetailDBService.newCanUseInitStatusLineFilter();
            try (DataSet lineStream = QTLineDetailDBService.lineDetailDao.queryDataSet(this.getClass().getName() + ".getQuotSummary", queryField, new QFilter[]{fileBoIdFilter, qtTypeIdFilter, dateRangeFilter, effectFilter});){
                HashMap<String, QTSummaryModel> summaryMap = new HashMap<String, QTSummaryModel>(16);
                while (lineStream.hasNext()) {
                    Row line = lineStream.next();
                    String key = line.getLong("attfilebo.id").toString() + "" + line.getLong("qttype.id").toString();
                    QTSummaryModel summaryModel = (QTSummaryModel)summaryMap.get(key);
                    if (summaryModel == null) {
                        summaryMap.put(key, this.parse2QTSummaryModel(line));
                        continue;
                    }
                    summaryModel.setOwnValue(summaryModel.getOwnValue().add(line.getBigDecimal("ownvalue")));
                    summaryModel.setUsableValue(summaryModel.getUsableValue().add(line.getBigDecimal("usablevalue")));
                    summaryModel.setFreezeValue(summaryModel.getFreezeValue().add(line.getBigDecimal("freezevalue")));
                    summaryModel.setUsedValue(summaryModel.getUsedValue().add(line.getBigDecimal("usedvalue")));
                    summaryModel.setCanBeOdValue(summaryModel.getCanBeOdValue().add(line.getBigDecimal("canbeodvalue")));
                    summaryModel.setUseOdValue(summaryModel.getUseOdValue().add(line.getBigDecimal("useodvalue")));
                    summaryModel.setCarryDownedValue(summaryModel.getCarryDownedValue().add(line.getBigDecimal("cdedvalue")).add(line.getBigDecimal("settlementvalue")));
                    summaryModel.setPastValue(summaryModel.getPastValue().add(line.getBigDecimal("pastvalue").add(line.getBigDecimal("invalidvalue"))));
                    summaryModel.setDepartValue(summaryModel.getDepartValue().add(line.getBigDecimal("departvalue")));
                }
                QTSummaryQueryRes res = new QTSummaryQueryRes();
                res.setQtSummaryModelList(new ArrayList<QTSummaryModel>(summaryMap.values()));
                CustomApiResult customApiResult = CustomApiResult.success((Object)res);
                return customApiResult;
            }
        }
        catch (Exception ex) {
            LOG.warn("getQuotSummary.warn", (Throwable)ex);
            return CustomApiResult.fail((String)"wtp.100002", (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="/getQuotaDetail", desc="\u8c03\u7528\u672c\u63a5\u53e3\u67e5\u8be2\u67d0\u4eba/\u67d0\u4e9b\u4eba\u5728\u67d0\u65e5\u671f\u8303\u56f4\u5185\uff08\u6216\u67d0\u5929\uff09\u7684\u5b9a\u989d\u7c7b\u578b\u7684\u660e\u7ec6\u6570\u636e\u3002")
    public CustomApiResult<QTDetailQueryRes> getQuotaDetail(@ApiParam(value="\u8003\u52e4\u6863\u6848\u5bf9\u8c61id\u5217\u8868 \u4e3a\u5fc5\u586b\uff1b\u4f7f\u7528\u5f00\u59cb\u65e5\u671f\u3001\u4f7f\u7528\u7ed3\u675f\u65e5\u671f \u4e3a\u5fc5\u586b\uff1b\u751f\u6210\u5f00\u59cb\u65e5\u671f\u3001\u751f\u6210\u7ed3\u675f\u65e5\u671f \u4e3a\u9009\u586b\uff1b\u5b9a\u989d\u7c7b\u578bid\u3001\u5b9a\u989d\u7c7b\u578b\u7f16\u7801\u3001\u5b9a\u989d\u660e\u7ec6\u7f16\u7801\u5fc5\u586b\u4e00\u4e2a\u3002", required=true, example="") @Valid @ApiParam(value="\u8003\u52e4\u6863\u6848\u5bf9\u8c61id\u5217\u8868 \u4e3a\u5fc5\u586b\uff1b\u4f7f\u7528\u5f00\u59cb\u65e5\u671f\u3001\u4f7f\u7528\u7ed3\u675f\u65e5\u671f \u4e3a\u5fc5\u586b\uff1b\u751f\u6210\u5f00\u59cb\u65e5\u671f\u3001\u751f\u6210\u7ed3\u675f\u65e5\u671f \u4e3a\u9009\u586b\uff1b\u5b9a\u989d\u7c7b\u578bid\u3001\u5b9a\u989d\u7c7b\u578b\u7f16\u7801\u3001\u5b9a\u989d\u660e\u7ec6\u7f16\u7801\u5fc5\u586b\u4e00\u4e2a\u3002", required=true, example="") @Valid QTDetailQueryReq req) {
        try {
            String errMsg = this.checkParamAndRetErrMsg(req);
            if (errMsg != null) {
                return CustomApiResult.fail((String)"wtp.100001", (String)errMsg);
            }
            QFilter fileBoIdFilter = new QFilter("attfilebo", "in", req.getAttFileBoIds());
            QFilter qtTypeIdFilter = this.getQTTypeIdFilter(req);
            QFilter dateRangeFilter = this.genDateRangeFilter(req);
            QFilter effectFilter = QTLineDetailDBService.newCanUseInitStatusLineFilter();
            DynamicObject[] lineArr = QTLineDetailDBService.lineDetailDao.query(queryField, new QFilter[]{fileBoIdFilter, qtTypeIdFilter, dateRangeFilter, effectFilter});
            List<QTDetailModel> detailList = Arrays.stream(lineArr).map(this::parse2QTDetailModel).collect(Collectors.toList());
            QTDetailQueryRes res = new QTDetailQueryRes();
            res.setQtDetailModelList(detailList);
            return CustomApiResult.success((Object)res);
        }
        catch (Exception ex) {
            LOG.warn("getQuotaDetail.warn", (Throwable)ex);
            return CustomApiResult.fail((String)"wtp.100002", (String)ex.getMessage());
        }
    }

    private QTDetailModel parse2QTDetailModel(DynamicObject line) {
        QTDetailModel res = new QTDetailModel();
        res.setAttPersonNumber(line.getString(attPersonNumber));
        res.setFileNumber(line.getString(fileNumber));
        res.setOrgNumber(line.getString(orgNumber));
        res.setOrgName(line.getString(orgName));
        res.setAdminOrgNumber(line.getString(adminOrgNumber));
        res.setAdminOrgName(line.getString(adminOrgName));
        res.setQtDetailNumber(QTLineDetailNumHelper.convertNum((Long)line.getLong("id")));
        res.setQtTypeNumber(line.getString(qtTypeNumber));
        res.setQtTypeName(line.getString(qtTypeName));
        res.setUnit(this.getUnitStr(line.getString(qtTypeUnit)));
        res.setOwnValue(line.getBigDecimal("ownvalue"));
        res.setUsableValue(line.getBigDecimal("usablevalue"));
        res.setFreezeValue(line.getBigDecimal("freezevalue"));
        res.setUsedValue(line.getBigDecimal("usedvalue"));
        res.setCanBeOdValue(line.getBigDecimal("canbeodvalue"));
        res.setUseOdValue(line.getBigDecimal("useodvalue"));
        res.setCarryDownedValue(line.getBigDecimal("cdedvalue").add(line.getBigDecimal("settlementvalue")));
        res.setPastValue(line.getBigDecimal("pastvalue").add(line.getBigDecimal("invalidvalue")));
        res.setDepartValue(line.getBigDecimal("departvalue"));
        res.setGenStartDate(line.getDate("genstartdate"));
        res.setGenEndDate(line.getDate("genenddate"));
        res.setUseStartDate(line.getDate("usestartdate"));
        res.setUseEndDate(line.getDate("useenddate"));
        res.setBusStatus(this.getBusStatusStr(line.getString("busstatus")));
        res.setSource(this.getSourceStr(line.getString("source")));
        return res;
    }

    private QTSummaryModel parse2QTSummaryModel(Row line) {
        QTSummaryModel res = new QTSummaryModel();
        res.setAttPersonNumber(line.getString(attPersonNumber));
        res.setFileNumber(line.getString(fileNumber));
        res.setOrgNumber(line.getString(orgNumber));
        res.setOrgName(line.getString(orgName));
        res.setAdminOrgNumber(line.getString(adminOrgNumber));
        res.setAdminOrgName(line.getString(adminOrgName));
        res.setQtTypeNumber(line.getString(qtTypeNumber));
        res.setQtTypeName(line.getString(qtTypeName));
        res.setUnit(this.getUnitStr(line.getString(qtTypeUnit)));
        res.setOwnValue(line.getBigDecimal("ownvalue"));
        res.setUsableValue(line.getBigDecimal("usablevalue"));
        res.setFreezeValue(line.getBigDecimal("freezevalue"));
        res.setUsedValue(line.getBigDecimal("usedvalue"));
        res.setCanBeOdValue(line.getBigDecimal("canbeodvalue"));
        res.setUseOdValue(line.getBigDecimal("useodvalue"));
        res.setCarryDownedValue(line.getBigDecimal("cdedvalue").add(line.getBigDecimal("settlementvalue")));
        res.setPastValue(line.getBigDecimal("pastvalue").add(line.getBigDecimal("invalidvalue")));
        res.setDepartValue(line.getBigDecimal("departvalue"));
        return res;
    }

    private String getSourceStr(String source) {
        if ("DT-001".equals(source)) {
            return ResManager.loadKDString((String)"\u5f80\u671f\u7ed3\u8f6c", (String)"QuotaOpenApi_14", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        if ("DT-002".equals(source)) {
            return ResManager.loadKDString((String)"\u624b\u52a8\u751f\u6210", (String)"QuotaOpenApi_15", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        if ("DT-003".equals(source)) {
            return ResManager.loadKDString((String)"\u5f80\u671f\u900f\u652f", (String)"QuotaOpenApi_16", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        if ("DT-007".equals(source)) {
            return ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210", (String)"QuotaOpenApi_18", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        if ("DT-008".equals(source)) {
            return ResManager.loadKDString((String)"\u521d\u59cb\u5316\u7ed3\u8f6c", (String)"QuotaOpenApi_19", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u7cfb\u7edf\u751f\u6210", (String)"QuotaOpenApi_13", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
    }

    private String getBusStatusStr(String busStatus) {
        if ("0".equals(busStatus)) {
            return ResManager.loadKDString((String)"\u751f\u6548", (String)"QuotaOpenApi_11", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5931\u6548", (String)"QuotaOpenApi_12", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
    }

    private String getUnitStr(String unit) {
        if ("D".equals(unit)) {
            return ResManager.loadKDString((String)"\u5929", (String)"QuotaOpenApi_9", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"QuotaOpenApi_10", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
    }

    private String checkParamAndRetErrMsg(AbsQTQueryReq req) {
        if (req.getAttFileBoIds().size() > API_QUERY_MAX_FILE_SIZE && API_QUERY_MAX_FILE_SIZE > 0) {
            return ResManager.loadKDString((String)"\u8d85\u8fc7\u6700\u5927\u67e5\u8be2\u6570\u636e\u91cf\uff0c\u8bf7\u8c03\u6574\u67e5\u8be2\u53c2\u6570\u540e\u91cd\u8bd5\u3002", (String)"QuotaOpenApi_17", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        if (req instanceof QTDetailQueryReq) {
            QTDetailQueryReq dReq = (QTDetailQueryReq)req;
            if (dReq.getQtTypeId() == 0L && WTCStringUtils.isEmpty((String)dReq.getQtTypeNumber()) && WTCStringUtils.isEmpty((String)dReq.getQtDetailNumber())) {
                return ResManager.loadKDString((String)"\u201c\u5b9a\u989d\u7c7b\u578b\u5bf9\u8c61ID\u201d\u3001\u201c\u5b9a\u989d\u7c7b\u578b\u7f16\u7801\u201d\u4e0e\u201c\u5b9a\u989d\u660e\u7ec6\u7f16\u7801\u201d\u4e2d\u81f3\u5c11\u7ef4\u62a4\u4e00\u9879\u3002", (String)"QuotaOpenApi_8", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
            }
        } else if (req.getQtTypeId() == 0L && WTCStringUtils.isEmpty((String)req.getQtTypeNumber())) {
            return ResManager.loadKDString((String)"\u201c\u5b9a\u989d\u7c7b\u578b\u5bf9\u8c61ID\u201d\u4e0e\u201c\u5b9a\u989d\u7c7b\u578b\u7f16\u7801\u201d\u4e2d\u81f3\u5c11\u7ef4\u62a4\u4e00\u9879\u3002", (String)"QuotaOpenApi_1", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        if (WTCStringUtils.isEmpty((String)req.getUseStartDate()) || WTCStringUtils.isEmpty((String)req.getUseEndDate())) {
            return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4f7f\u7528\u5f00\u59cb\u65e5\u671f\u201d\u3001\u201c\u4f7f\u7528\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"QuotaOpenApi_2", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        Date useStartDate = WTCDateUtils.str2Date((String)req.getUseStartDate(), (String)"yyyy-MM-dd");
        Date useEndDate = WTCDateUtils.str2Date((String)req.getUseEndDate(), (String)"yyyy-MM-dd");
        if (useStartDate == null || useEndDate == null) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f7f\u7528\u5f00\u59cb\u65e5\u671f\u548c\u4f7f\u7528\u7ed3\u675f\u65e5\u671f\uff0c\u683c\u5f0f\u4e3a\u201cyyyy-MM-dd\u201d\u3002", (String)"QuotaOpenApi_3", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        if (useStartDate.after(useEndDate)) {
            return ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u5f00\u59cb\u65e5\u671f\u201d\u4e0d\u5f97\u5927\u4e8e\u201c\u4f7f\u7528\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"QuotaOpenApi_4", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        Date genStartDate = null;
        Date genEndDate = null;
        if (WTCStringUtils.isNotEmpty((String)req.getGenStartDate()) && (genStartDate = WTCDateUtils.str2Date((String)req.getGenStartDate(), (String)"yyyy-MM-dd")) == null) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u751f\u6210\u5f00\u59cb\u65e5\u671f\uff0c\u683c\u5f0f\u4e3a\u201cyyyy-MM-dd\u201d\u3002", (String)"QuotaOpenApi_5", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        if (WTCStringUtils.isNotEmpty((String)req.getGenEndDate()) && (genEndDate = WTCDateUtils.str2Date((String)req.getGenEndDate(), (String)"yyyy-MM-dd")) == null) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u751f\u6210\u7ed3\u675f\u65e5\u671f\uff0c\u683c\u5f0f\u4e3a\u201cyyyy-MM-dd\u201d\u3002", (String)"QuotaOpenApi_6", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        if (genStartDate != null && genEndDate != null && genStartDate.after(genEndDate)) {
            return ResManager.loadKDString((String)"\u201c\u751f\u6210\u5f00\u59cb\u65e5\u671f\u201d\u4e0d\u5f97\u5927\u4e8e\u201c\u751f\u6210\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"QuotaOpenApi_7", (String)"wtc-wtp-mservice", (Object[])new Object[0]);
        }
        return null;
    }

    private QFilter genDateRangeFilter(AbsQTQueryReq req) {
        Date useStartDate = WTCDateUtils.str2Date((String)req.getUseStartDate(), (String)"yyyy-MM-dd");
        Date useEndDate = WTCDateUtils.str2Date((String)req.getUseEndDate(), (String)"yyyy-MM-dd");
        QFilter dateRangeFilter = Objects.requireNonNull(DateRange.range((Date)useStartDate, (Date)useEndDate)).getFilterIntersectionLCRC("usestartdate", "useenddate");
        Date genStartDate = null;
        Date genEndDate = null;
        if (WTCStringUtils.isNotEmpty((String)req.getGenStartDate())) {
            genStartDate = WTCDateUtils.str2Date((String)req.getGenStartDate(), (String)"yyyy-MM-dd");
        }
        if (WTCStringUtils.isNotEmpty((String)req.getGenEndDate())) {
            genEndDate = WTCDateUtils.str2Date((String)req.getGenEndDate(), (String)"yyyy-MM-dd");
        }
        if (genStartDate != null && genEndDate != null) {
            QFilter genDateRangeFilter = DateRange.range((Date)genStartDate, (Date)genEndDate).getFilterIntersectionLCRC("genstartdate", "genenddate");
            dateRangeFilter.and(genDateRangeFilter);
        } else if (genStartDate != null) {
            dateRangeFilter.and("genenddate", ">=", (Object)genStartDate);
        } else if (genEndDate != null) {
            dateRangeFilter.and("genstartdate", "<=", (Object)genEndDate);
        }
        return dateRangeFilter;
    }

    private QFilter getQTTypeIdFilter(AbsQTQueryReq req) {
        Set<Object> qtTypeIdSet;
        HRBaseServiceHelper typeDao = new HRBaseServiceHelper("wtp_qttype");
        if (req instanceof QTDetailQueryReq) {
            QTDetailQueryReq dReq = (QTDetailQueryReq)req;
            QFilter filter = null;
            if (dReq.getQtTypeId() != 0L) {
                if (WTCStringUtils.isEmpty((String)dReq.getQtTypeNumber()) && WTCStringUtils.isEmpty((String)dReq.getQtDetailNumber())) {
                    return new QFilter("qttype", "=", (Object)dReq.getQtTypeId());
                }
                filter = new QFilter("id", "=", (Object)dReq.getQtTypeId());
            }
            if (WTCStringUtils.isNotEmpty((String)dReq.getQtTypeNumber())) {
                QFilter numberFilter = new QFilter("number", "=", (Object)dReq.getQtTypeNumber());
                QFilter qFilter = filter = filter != null ? filter.and(numberFilter) : numberFilter;
            }
            if (filter == null) {
                return new QFilter("id", "=", (Object)QTLineDetailNumHelper.convertId((String)dReq.getQtDetailNumber()));
            }
            DynamicObject[] arr = typeDao.query("id", filter.toArray());
            Set qtTypeIdSet2 = Arrays.stream(arr).map(ele -> ele.getLong("id")).collect(Collectors.toSet());
            filter = new QFilter("qttype", "in", qtTypeIdSet2);
            if (WTCStringUtils.isNotEmpty((String)dReq.getQtDetailNumber())) {
                return filter.and("id", "=", (Object)QTLineDetailNumHelper.convertId((String)dReq.getQtDetailNumber()));
            }
            return filter;
        }
        QFilter filter = null;
        if (req.getQtTypeId() != 0L) {
            if (WTCStringUtils.isEmpty((String)req.getQtTypeNumber())) {
                return new QFilter("qttype", "=", (Object)req.getQtTypeId());
            }
            filter = new QFilter("id", "=", (Object)req.getQtTypeId());
        }
        if (WTCStringUtils.isNotEmpty((String)req.getQtTypeNumber())) {
            QFilter numberFilter = new QFilter("number", "=", (Object)req.getQtTypeNumber());
            QFilter qFilter = filter = filter != null ? filter.and(numberFilter) : numberFilter;
        }
        if (filter == null) {
            qtTypeIdSet = new HashSet(16);
        } else {
            DynamicObject[] arr = typeDao.query("id", filter.toArray());
            qtTypeIdSet = Arrays.stream(arr).map(ele -> ele.getLong("id")).collect(Collectors.toSet());
        }
        return new QFilter("qttype", "in", qtTypeIdSet);
    }

    static {
        List<String> commonField = Arrays.asList("id", "attfilebo.id", "attfileid.id", "qttype.id", "genstartdate", "genenddate", "usestartdate", "useenddate", "source", "busstatus", "ownvalue", "usablevalue", "freezevalue", "usedvalue", "canbeodvalue", "useodvalue", "cdedvalue", "pastvalue", "invalidvalue", "settlementvalue", "departvalue");
        ArrayList<String> selectField = new ArrayList<String>(commonField);
        selectField.add(attPersonNumber);
        selectField.add(fileNumber);
        selectField.add(orgNumber);
        selectField.add(orgName);
        selectField.add(adminOrgNumber);
        selectField.add(adminOrgName);
        selectField.add(qtTypeNumber);
        selectField.add(qtTypeName);
        selectField.add(qtTypeUnit);
        queryField = String.join((CharSequence)",", selectField);
        Integer tmp = WTCAppContextHelper.getProjectParams().getInteger("kd.wtc.wtp.quota.openapi.query.maxFileSize", Integer.valueOf(500));
        API_QUERY_MAX_FILE_SIZE = tmp == null ? 500 : tmp;
    }
}

