/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.business.upgrade.WTCUpgradeService;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class AccountPlanDateUpgrade
extends WTCUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(AccountPlanDateUpgrade.class);
    private static final String SELECT_PHASEENTRY = "select  fentryid , fphasename from t_wtp_phaseentry where fphasename != ' ' and fid not in (1484706461694033920,1660061414347244545,1660040628450362368,1484710029285130241,1855703448469747713,1855698946488384512);";
    private static final String DELETE_PHASEENTRY = "delete from t_wtp_phaseentry_l where fentryid = ? and flocaleid = 'zh_CN';";
    private static final String INSERT_PHASEENTRY = "insert into t_wtp_phaseentry_l(fpkid, fentryid, flocaleid, fphasenamelang) values (?,?,?,?);";

    public void upgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        LOGGER.info("phaseEntryUpgrade upgradeAction start .....");
        DBRoute wtpDbRoute = new DBRoute("wtc");
        try (TXHandle ignored = TX.requiresNew();
             DataSet attFileDateDataSet = HRDBUtil.queryDataSet((String)"SELECT_PHASEENTRY", (DBRoute)wtpDbRoute, (String)SELECT_PHASEENTRY, (Object[])new Object[0]);){
            int count = attFileDateDataSet.copy().count("fentryid", true);
            ArrayList phaseEntryList = Lists.newArrayListWithExpectedSize((int)count);
            String[] phaseEntryStr = DB.genStringIds((String)"t_wtp_phaseentry_l", (int)count);
            ArrayList entryIdList = Lists.newArrayListWithExpectedSize((int)count);
            int num = 0;
            while (attFileDateDataSet.hasNext()) {
                Row row = attFileDateDataSet.next();
                Object fentryid = row.get("fentryid");
                Object fphasename = row.get("fphasename");
                Object[] objects = new Object[]{phaseEntryStr[num], fentryid, "zh_CN", fphasename};
                Object[] entryOjects = new Object[]{fentryid};
                entryIdList.add(entryOjects);
                phaseEntryList.add(objects);
                ++num;
            }
            if (!CollectionUtils.isEmpty((Collection)phaseEntryList)) {
                DBRoute dbRoute = new DBRoute("wtc");
                HRDBUtil.executeBatch((DBRoute)dbRoute, (String)DELETE_PHASEENTRY, (List)entryIdList);
                HRDBUtil.executeBatch((DBRoute)dbRoute, (String)INSERT_PHASEENTRY, (List)phaseEntryList);
            }
        }
        catch (Exception exception) {
            String msg = "phaseEntryUpgrade exception";
            LOGGER.error("phaseEntryUpgrade.upgradeAction error", (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("phaseEntryUpgrade", msg), new Object[0]);
        }
        LOGGER.info("phaseEntryUpgrade upgradeAction end .....");
    }
}

