/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.util.WTCBatchHandleUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.common.AttFileScheduleUpgradeParam;

public class AttFileScheduleUpgrade
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(AttFileScheduleUpgrade.class);
    private static final HRBaseServiceHelper attFileCutSchLogServiceHelper = new HRBaseServiceHelper("wtp_attfileupgradelog");

    protected String getJobId() {
        return "3M6H20S7TF/S";
    }

    protected String getScheduleId() {
        return "3H7YB1O5NEPU";
    }

    protected boolean process() {
        return true;
    }

    protected boolean process(Map<String, Object> map) {
        LOG.info("AttFileScheduleUpgrade start process...");
        this.upgradeAction(map);
        LOG.info("AttFileScheduleUpgrade end ...");
        return true;
    }

    public void upgradeAction(Map<String, Object> map) {
        List attFileByFileList;
        String boIdStr = (String)map.get("boid");
        ArrayList boIdList = Lists.newArrayListWithExpectedSize((int)1);
        if (WTCStringUtils.isNotEmpty((String)boIdStr)) {
            String[] split = WTCStringUtils.split((String)boIdStr, (String)",");
            boIdList = Lists.newArrayListWithExpectedSize((int)split.length);
            for (String s : split) {
                boIdList.add(Long.valueOf(s));
            }
        }
        int batchSize = Integer.parseInt((String)map.get("batchSize"));
        DynamicObject[] attFileCutSchLogArr = attFileCutSchLogServiceHelper.query("boid", new QFilter[]{new QFilter("type", "=", (Object)"0")});
        Set notInFileBoIdSet = Arrays.stream(attFileCutSchLogArr).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        if (WTCCollections.isNotEmpty((Collection)boIdList) && WTCCollections.isNotEmpty(notInFileBoIdSet)) {
            for (int i = boIdList.size() - 1; i >= 0; --i) {
                Long boId = (Long)boIdList.get(i);
                if (!notInFileBoIdSet.contains(boId)) continue;
                boIdList.remove(i);
            }
            if (WTCCollections.isEmpty((Collection)boIdList)) {
                return;
            }
        }
        if (WTCCollections.isNotEmpty((Collection)(attFileByFileList = AttFileHelper.getAttFileByFileBoId(boIdList == null ? null : new HashSet(boIdList), notInFileBoIdSet, (boolean)false, (String)"boid", (Boolean)true)))) {
            List fileBoIdList = attFileByFileList.stream().map(dy -> dy.getLong("boid")).distinct().collect(Collectors.toList());
            AttFileScheduleUpgradeParam param = new AttFileScheduleUpgradeParam();
            param.setMainBoId(Long.valueOf(ID.genLongId()));
            param.setUpdateScheduleEnumSet(null);
            param.setAttFileByFileList(attFileByFileList);
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)1);
            WTCBatchHandleUtils.batchHandleMap((Map)returnMap, fileBoIdList, (int)batchSize, (Object)param, this::callBatch);
        }
    }

    private Map<Long, Long> callBatch(List<Long> fileBoIdList, AttFileScheduleUpgradeParam param) {
        try (TXHandle tx = TX.required();){
            try {
                List attFileByFileList = AttFileHelper.getAttFileByFileBoId(new HashSet<Long>(fileBoIdList), (boolean)false);
                AttFileServiceImpl.getInstance().cutAllBaseAndRuleSchedule(attFileByFileList, param.getUpdateScheduleEnumSet(), param.getMainBoId(), false);
                DynamicObject[] upgradeLogArr = new DynamicObject[fileBoIdList.size()];
                for (int i = 0; i < fileBoIdList.size(); ++i) {
                    Long boId = fileBoIdList.get(i);
                    DynamicObject upgradeLog = attFileCutSchLogServiceHelper.generateEmptyDynamicObject();
                    upgradeLog.set("boid", (Object)boId);
                    upgradeLog.set("type", (Object)"0");
                    upgradeLogArr[i] = upgradeLog;
                }
                attFileCutSchLogServiceHelper.save(upgradeLogArr);
            }
            catch (Throwable e) {
                tx.markRollback();
                LOG.error("AttFileScheduleUpgrade fail!", e);
                LOG.error("AttFileScheduleUpgrade fail! fileBoIdList = {}", fileBoIdList);
            }
        }
        return null;
    }
}

