/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice.upgrade;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.business.upgrade.WTCUpgradeService;

public class AttendPersonDateUpgrade
extends WTCUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(AttendPersonDateUpgrade.class);
    private static final String SELECT_ATTFILEBASE = "select min(fstartdate) earliestattenddate, max(fenddate) latestattenddate, fpersonid person from t_wtp_attfilebase a where fiscurrentversion = '1' and exists( select 1 from t_wtp_attendperson b where a.fpersonid = b.fid and (b.fearliestattenddate is null or b.flatestattenddate is null)) group by fpersonid;";
    private static final String UPDATE_ATTENDPERSON = "update t_wtp_attendperson set fearliestattenddate = ?, flatestattenddate = ? where fid = ?;";

    public void upgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        LOGGER.info("AttendPersonDateUpgrade upgradeAction start .....");
        DBRoute wtpDbRoute = new DBRoute("wtc");
        try (TXHandle ignored = TX.requiresNew();
             DataSet attFileDateDataSet = HRDBUtil.queryDataSet((String)"getAttFileDate", (DBRoute)wtpDbRoute, (String)SELECT_ATTFILEBASE, (Object[])new Object[0]);){
            ArrayList<Object[]> attendPersonParamList = new ArrayList<Object[]>(attFileDateDataSet.copy().count("person", true));
            while (attFileDateDataSet.hasNext()) {
                Row row = attFileDateDataSet.next();
                Object earliestAttendDate = row.get("earliestattenddate");
                Object latestAttendDate = row.get("latestattenddate");
                Object person = row.get("person");
                Object[] objects = new Object[]{earliestAttendDate, latestAttendDate, person};
                attendPersonParamList.add(objects);
            }
            if (!CollectionUtils.isEmpty(attendPersonParamList)) {
                DBRoute dbRoute = new DBRoute("wtc");
                HRDBUtil.executeBatch((DBRoute)dbRoute, (String)UPDATE_ATTENDPERSON, attendPersonParamList);
            }
        }
        catch (Exception exception) {
            String msg = "AttendPersonDateUpgrade exception";
            LOGGER.error("AttendPersonDateUpgrade.upgradeAction error", (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("AttendPersonDateUpgrade", msg), new Object[0]);
        }
        LOGGER.info("AttendPersonDateUpgrade upgradeAction end .....");
    }
}

