/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.business.upgrade.WTCUpgradeService;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class AttendPersonUpgrade
extends WTCUpgradeService {
    private static final Log logger = LogFactory.getLog(AttendPersonUpgrade.class);
    private final Map<Long, Long> pidMap = Maps.newHashMapWithExpectedSize((int)10);
    private final List<Long> personIdList = Lists.newArrayListWithExpectedSize((int)10);

    public void upgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("AttendPersonUpgrade upgradeAction start .....");
        if (CollectionUtils.isEmpty(this.pidMap)) {
            return;
        }
        try {
            logger.info("AttendPersonUpgrade upgradeAction ids={}", this.pidMap.keySet());
            DBRoute dbRoute = new DBRoute("wtc");
            String personSql = "update t_wtp_attendperson set fpersonindexid =? where fid=?;";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(this.pidMap.size());
            for (Map.Entry<Long, Long> entry : this.pidMap.entrySet()) {
                Long personId = entry.getKey();
                Long personIndexId = entry.getValue();
                paramsList.add(new Object[]{personIndexId, personId});
            }
            int[] ints = HRDBUtil.executeBatch((DBRoute)dbRoute, (String)personSql, paramsList);
            logger.info("AttendPersonUpgrade upgradeAction success size={}", (Object)ints.length);
        }
        catch (Exception exception) {
            String msg = "AttendPersonUpgrade exception";
            logger.warn(msg, (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("AttendPersonUpgrade", msg), new Object[0]);
        }
        logger.info("AttendPersonUpgrade upgradeAction end .....");
    }

    public void beforeUpgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        super.beforeUpgradeAction(ver, iteration, dbKey, sqlFileName);
        DBRoute dbRoute = new DBRoute("wtc");
        String personSql = "select fid from t_wtp_attendperson where fpersonindexid = 0 or fpersonindexid is null ;";
        DataSet dataSet = HRDBUtil.queryDataSet((String)"attendperson", (DBRoute)dbRoute, (String)personSql, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            this.personIdList.add(row.getLong("fid"));
        }
        if (!CollectionUtils.isEmpty(this.personIdList) && !CollectionUtils.isEmpty(this.personIdList)) {
            ArrayList<Long> idList = new ArrayList<Long>(200);
            for (int i = 0; i < this.personIdList.size(); ++i) {
                Long personId = this.personIdList.get(i);
                idList.add(personId);
                if (i % 200 != 0 && i != this.personIdList.size() - 1) continue;
                String idListStr = StringUtils.join(idList, (String)",");
                DBRoute hrDbRoute = new DBRoute("hr");
                String sql = "select fid,fpersonindexid from t_hrpi_person where fid in(" + idListStr + ");";
                HRDBUtil.query((DBRoute)hrDbRoute, (String)sql, null, resultSet -> {
                    while (resultSet.next()) {
                        this.pidMap.put(resultSet.getLong("fid"), resultSet.getLong("fpersonindexid"));
                    }
                    return null;
                });
                idList.clear();
            }
        }
    }
}

