/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtp.business.coordination.helper.CoordinationHelper;

public class CoorTaskCenterUpgrade
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(CoorTaskCenterUpgrade.class);
    private static int batchSize = 1000;

    protected String getJobId() {
        return "3DRMMT=MFR2B";
    }

    protected String getScheduleId() {
        return "3DRMQPYXU5G/";
    }

    protected boolean process() {
        LOG.info("CoorTaskCenterUpgrade start process...");
        try (TXHandle txHandle = TX.required();){
            LOG.info("CoorTaskCenterUpgrade start ...");
            this.upgradeAction();
            LOG.info("CoorTaskCenterUpgrade end ...");
        }
        return true;
    }

    public void upgradeAction() {
        HRBaseServiceHelper helperOfLog = new HRBaseServiceHelper("wtis_coordinationlog");
        HRBaseServiceHelper helperOfTask = new HRBaseServiceHelper("wtp_coordinationtask");
        DynamicObject[] allTask = helperOfTask.query("id,coordinationlog", new QFilter[0]);
        Set hasGenLogIds = Arrays.stream(allTask).map(dyn -> dyn.getLong("coordinationlog")).collect(Collectors.toSet());
        DynamicObject[] logIdDyns = helperOfLog.query("id", new QFilter[]{new QFilter("taskstatus", "=", (Object)"1")});
        List logIds = Arrays.stream(logIdDyns).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        logIds.removeAll(hasGenLogIds);
        int batch = 0;
        int total = logIds.size();
        while (batch < total) {
            LOG.info("batch:{},total:{}", (Object)batch, (Object)total);
            ArrayList batchLogIds = new ArrayList(logIds.subList(batch, Math.min(batch + batchSize, total)));
            batch += batchSize;
            DynamicObject[] logDyns = helperOfLog.loadDynamicObjectArray(new QFilter[]{new QFilter("taskstatus", "=", (Object)"1"), new QFilter("id", "in", batchLogIds)});
            DynamicObjectCollection dyns = new DynamicObjectCollection();
            for (DynamicObject logDyn : logDyns) {
                if (!logIds.contains(logDyn.getLong("id"))) continue;
                DynamicObject task = helperOfTask.generateEmptyDynamicObject();
                task.set("creator", logDyn.get("creator"));
                task.set("createtime", logDyn.get("createtime"));
                task.set("modifier", logDyn.get("modifier"));
                task.set("modifytime", logDyn.get("modifytime"));
                task.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"wtp_coordinationtask", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"wtp_coordinationtask"), null));
                task.set("executionstatus", (Object)"C");
                task.set("name", (Object)ResManager.loadKDString((String)"%s\u4efb\u52a1", (String)"CoorTaskCenterUpgrade_0", (String)"wtc-wtp-mservice", (Object[])new Object[]{logDyn.get("name")}));
                task.set("executionmode", (Object)"B");
                task.set("taskstatus", (Object)"0");
                task.set("executiondate", logDyn.get("createtime"));
                task.set("coordinationlogname", logDyn.get("name"));
                task.set("msgactionname", logDyn.get("msgaction.name"));
                task.set("coordinationlog", logDyn.get("id"));
                try {
                    task.set("org", this.getOrgByLog(logDyn));
                    logDyn.set("org", task.get("org"));
                    if (0L == task.getLong("org")) continue;
                    dyns.add((Object)task);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
            helperOfLog.save(logDyns);
            helperOfTask.save(dyns);
        }
    }

    private Object getOrgByLog(DynamicObject logDynamicObject) {
        if (logDynamicObject.get("org") == null || logDynamicObject.getLong("org") == 0L) {
            List attFileList;
            Map result = (Map)SerializationUtils.deSerializeFromBase64((String)logDynamicObject.getString("msgcontent"));
            Long recordId = (Long)result.get("recordId");
            if (recordId == null || recordId.equals(0L)) {
                LOG.warn(ResManager.loadKDString((String)"\u6838\u5fc3\u4eba\u529b\u7684\u4e8b\u52a1\u53d8\u52a8ID\u4e3a\u7a7a\u6216\u8005\u4e3a0\uff0c\u65e0\u6cd5\u6267\u884c\u4e8b\u52a1\u3002", (String)"CoorTaskCenterUpgrade_1", (String)"wtc-wtp-mservice", (Object[])new Object[0]));
                return 0;
            }
            Map changeAll = (Map)WTCServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoDetailByRecordId", (Object[])new Object[]{recordId});
            Map changeContent = CoordinationHelper.getInstance().getChangeContentByAll(changeAll);
            List attendNeedChange = null;
            try {
                attendNeedChange = CoordinationHelper.getInstance().getAttendNeedChange(changeContent);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return 0;
            }
            Map hrPiPerson = CoordinationHelper.getInstance().getHrPiEntityChg(attendNeedChange, "hrpi_person", null);
            Long personId = (Long)hrPiPerson.get("boid");
            Date effectTime = new Date((Long)((Map)changeAll.get("data")).get("effectTime"));
            if (CoordinationHelper.getInstance().checkIfResign(logDynamicObject.getString("msgsubno"))) {
                effectTime = WTCDateUtils.addDays((Date)effectTime, (int)-1);
            }
            if (WTCCollections.isNotEmpty((Collection)(attFileList = CoordinationHelper.getInstance().queryAttListByPersonIdAndDay(personId, effectTime))) && attFileList.size() == 1) {
                return ((DynamicObject)attFileList.get(0)).getLong("org.id");
            }
        }
        return 0;
    }
}

