/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;

public class FullSynAttPeriodTimingTask
extends AbstractWtcTaskUpgrade {
    private static final Log log = LogFactory.getLog((String)FullSynAttPeriodTimingTask.class.getName());
    private int batchSize = 50;
    private int loopSize = 100;
    private long hangUpSecond = 0L;

    private void parseRunArgs(Map<String, Object> map) {
        Object hangUpSecondObj;
        Object loopSizeObj;
        Object batchSizeObj = map.get("batchSize");
        if (batchSizeObj != null) {
            int tmp = Integer.parseInt(batchSizeObj.toString());
            int n = this.batchSize = tmp > 0 ? tmp : this.batchSize;
        }
        if ((loopSizeObj = map.get("loopSize")) != null) {
            int tmp = Integer.parseInt(loopSizeObj.toString());
            int n = this.loopSize = tmp > 0 ? tmp : this.loopSize;
        }
        if ((hangUpSecondObj = map.get("hangUpSecond")) != null) {
            long tmp = Long.parseLong(hangUpSecondObj.toString());
            this.hangUpSecond = tmp > 0L ? tmp : this.hangUpSecond;
        }
    }

    protected String getJobId() {
        return "3HD1O1D47+W=";
    }

    protected String getScheduleId() {
        return "3HD1YBSXR/X7";
    }

    protected boolean process() {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(Map<String, Object> map) {
        DLock dLock = DLock.create((String)"FullSynAttPeriodTimingTask-executeUpdate", (String)"FullSynAttPeriodTimingTask");
        boolean locked = false;
        try {
            locked = dLock.tryLock();
            if (!locked) {
                throw new IllegalStateException("can not get lock");
            }
            boolean bl = this.doUpdate(map);
            return bl;
        }
        finally {
            if (locked) {
                dLock.unlock();
            }
            dLock.close();
        }
    }

    private boolean doUpdate(Map<String, Object> map) {
        this.parseRunArgs(map);
        List<Tuple<Long, Long>> fileBo2AttPersonIdList = this.getSynTupleList();
        int cnt = 0;
        HashMap<Long, Long> fileBo2AttPersonIdMap = new HashMap<Long, Long>(this.batchSize);
        Iterator<Tuple<Long, Long>> iterator = fileBo2AttPersonIdList.iterator();
        while (iterator.hasNext()) {
            Tuple<Long, Long> tuple = iterator.next();
            fileBo2AttPersonIdMap.put((Long)tuple.getKey(), (Long)tuple.getValue());
            boolean existUpdate = false;
            if (fileBo2AttPersonIdMap.size() >= this.batchSize) {
                this.genAndStorePerAttPeriod(fileBo2AttPersonIdMap);
                existUpdate = true;
            }
            iterator.remove();
            if (this.hangUpSecond <= 0L) continue;
            if (existUpdate) {
                ++cnt;
            }
            if (cnt < this.loopSize) continue;
            LockSupport.parkNanos(this.hangUpSecond * 1000000000L);
            cnt = 0;
        }
        this.genAndStorePerAttPeriod(fileBo2AttPersonIdMap);
        return true;
    }

    private void genAndStorePerAttPeriod(Map<Long, Long> fileBo2AttPersonIdMap) {
        try {
            PerAttPeriodDataService.getInstance().processAndSavePerAttPeriodData(fileBo2AttPersonIdMap, true);
        }
        catch (Exception exp) {
            log.warn("FullSynAttPeriodTimingTask-executeUpdate fail(msg={}), current execute batch:{}", (Object)exp.getMessage(), fileBo2AttPersonIdMap);
        }
        fileBo2AttPersonIdMap.clear();
    }

    private List<Tuple<Long, Long>> getSynTupleList() {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setProperties("id");
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAttStatus(AttStatusEnum.ATT_NORMAL);
        attFileQueryParam.setProperties("id,boid,attperson,attperson.id");
        ArrayList<Tuple<Long, Long>> fileBo2AttPersonIdList = new ArrayList<Tuple<Long, Long>>(16);
        List fileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        HashSet<Long> helpMap = new HashSet<Long>(16);
        Iterator iterator = fileList.iterator();
        while (iterator.hasNext()) {
            DynamicObject file = (DynamicObject)iterator.next();
            long fileBoId = file.getLong("boid");
            if (helpMap.add(fileBoId)) {
                Tuple tuple = new Tuple((Object)fileBoId, (Object)file.getLong("attperson.id"));
                fileBo2AttPersonIdList.add((Tuple<Long, Long>)tuple);
            }
            iterator.remove();
        }
        return fileBo2AttPersonIdList;
    }
}

