/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.LockSupport;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class PerAttPeriodBizDataUpgrade
extends AbstractWtcTaskUpgrade {
    private static final Log log = LogFactory.getLog((String)PerAttPeriodBizDataUpgrade.class.getName());
    private int storeCacheUpperLimit = 5000;
    private int batchSize = 500;
    private int loopSize = 1000;
    private long hangUpSecond = 0L;
    private boolean updateAttRecord = true;
    private boolean updateAttRecordHis = true;
    private boolean updateTotalRecord = true;
    private boolean updateTotalRecordHis = true;
    private boolean updateInfo = true;
    private boolean updateInfoHis = true;
    private static final String parentJobId = "3HD1O1D47+W=";
    private static final String parentScheduleId = "3HD1YBSXR/X7";

    protected String getJobId() {
        return "3HDI9PX/30RK";
    }

    protected String getScheduleId() {
        return "3HDIGTJYFQBG";
    }

    protected boolean process() {
        throw new IllegalStateException();
    }

    private void parseRunArgs(Map<String, Object> map) {
        Object hangUpSecondObj;
        Object batchSizeObj;
        Object loopSizeObj;
        Object storeCacheUpperLimitObj = map.get("storeCacheUpperLimit");
        if (storeCacheUpperLimitObj != null) {
            int tmp = Integer.parseInt(storeCacheUpperLimitObj.toString());
            int n = this.storeCacheUpperLimit = tmp > 0 ? tmp : this.storeCacheUpperLimit;
        }
        if ((loopSizeObj = map.get("loopSize")) != null) {
            int tmp = Integer.parseInt(loopSizeObj.toString());
            int n = this.loopSize = tmp > 0 ? tmp : this.loopSize;
        }
        if ((batchSizeObj = map.get("batchSize")) != null) {
            int tmp = Integer.parseInt(batchSizeObj.toString());
            int n = this.batchSize = tmp > 0 ? tmp : this.batchSize;
        }
        if ((hangUpSecondObj = map.get("hangUpSecond")) != null) {
            long tmp = Long.parseLong(hangUpSecondObj.toString());
            long l = this.hangUpSecond = tmp > 0L ? tmp : this.hangUpSecond;
        }
        if (map.containsKey("shieldAttRecord")) {
            this.updateAttRecord = false;
        }
        if (map.containsKey("shieldAttRecordHis")) {
            this.updateAttRecordHis = false;
        }
        if (map.containsKey("shieldTotalRecord")) {
            this.updateTotalRecord = false;
        }
        if (map.containsKey("shieldTotalRecordHis")) {
            this.updateTotalRecordHis = false;
        }
        if (map.containsKey("shieldInfo")) {
            this.updateInfo = false;
        }
        if (map.containsKey("shieldInfoHis")) {
            this.updateInfoHis = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(Map<String, Object> map) {
        boolean existedParentSchedule = ScheduleService.getInstance().getObjectFactory().getScheduleDao().existed(parentScheduleId);
        boolean existParentJob = ScheduleService.getInstance().getObjectFactory().getJobDao().isExist(parentJobId);
        if (existedParentSchedule) {
            throw new IllegalStateException("parent schedule is not over yet.");
        }
        if (!existParentJob) {
            throw new IllegalStateException("parent job is not existed.");
        }
        DLock dLock = DLock.create((String)"PerAttPeriodBizDataUpgrade-executeUpdate", (String)"PerAttPeriodBizDataUpgrade");
        boolean locked = false;
        try {
            locked = dLock.tryLock();
            if (!locked) {
                throw new IllegalStateException("can not get lock");
            }
            boolean bl = this.doUpdate(map);
            return bl;
        }
        finally {
            if (locked) {
                dLock.unlock();
            }
            dLock.close();
        }
    }

    private boolean doUpdate(Map<String, Object> map) {
        this.parseRunArgs(map);
        String queryAttFileSql = "select fid,fattpersonid,fboid from t_wtp_attfilebase  where fboid not in (select fboid from  t_wtp_attfileupgradelog a where  a.ftype = '1') order by fattpersonid";
        IDNumberGetter IDNumGetter = new IDNumberGetter();
        UpdateInfoAccumulator updateInfoAccumulator = new UpdateInfoAccumulator(this.batchSize);
        try (DataSet deductRuleDataSet = HRDBUtil.queryDataSet((String)(((Object)((Object)this)).getClass() + ".queryAllAttPersonS"), (DBRoute)new DBRoute("wtc"), (String)queryAttFileSql, null);){
            int cnt = 0;
            while (deductRuleDataSet.hasNext()) {
                Long fileVid;
                Long fileBoId;
                Row next = deductRuleDataSet.next();
                Long attPersonId = next.getLong("fattpersonid");
                boolean isFull = updateInfoAccumulator.addIfLegal(attPersonId, fileBoId = next.getLong("fboid"), fileVid = next.getLong("fid"));
                if (!isFull) continue;
                boolean existUpdate = this.upDateBizData(updateInfoAccumulator, IDNumGetter);
                this.saveUpgradeFileBoIdLog(updateInfoAccumulator);
                updateInfoAccumulator.clear();
                updateInfoAccumulator.addIfLegal(attPersonId, fileBoId, fileVid);
                if (this.hangUpSecond <= 0L) continue;
                if (existUpdate) {
                    ++cnt;
                }
                if (cnt < this.loopSize) continue;
                LockSupport.parkNanos(this.hangUpSecond * 1000000000L);
                cnt = 0;
            }
            if (updateInfoAccumulator.hasStockInfo()) {
                this.upDateBizData(updateInfoAccumulator, IDNumGetter);
                this.saveUpgradeFileBoIdLog(updateInfoAccumulator);
            }
        }
        return true;
    }

    private void saveUpgradeFileBoIdLog(UpdateInfoAccumulator updateInfoAccumulator) {
        Set<Long> attFileBoIdSet = updateInfoAccumulator.getAttFileBoIdSet();
        if (WTCCollections.isNotEmpty(attFileBoIdSet)) {
            DynamicObjectCollection saveFileLogColl = new DynamicObjectCollection();
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_attfileupgradelog");
            for (Long fileBoIdLogSave : attFileBoIdSet) {
                DynamicObject saveFileLogDynamicObject = hrBaseServiceHelper.generateEmptyDynamicObject();
                saveFileLogDynamicObject.set("boid", (Object)fileBoIdLogSave);
                saveFileLogDynamicObject.set("type", (Object)Character.valueOf('1'));
                saveFileLogColl.add((Object)saveFileLogDynamicObject);
            }
            hrBaseServiceHelper.save(saveFileLogColl);
        }
    }

    private boolean upDateBizData(UpdateInfoAccumulator updateInfoAccumulator, IDNumberGetter IDNumGetter) {
        int update;
        PerAttPeriodGetter perAttPeriodGetter = new PerAttPeriodGetter(updateInfoAccumulator.getAttPersonIdSet(), IDNumGetter);
        boolean existUpdate = false;
        if (this.updateAttRecord) {
            RecordUpgrade attRecordUpgrade = new RecordUpgrade("wtdtd_attrecordbase", "t_wtdtd_attrecordbase", this.storeCacheUpperLimit);
            update = attRecordUpgrade.setPerAttPeriodGetter(perAttPeriodGetter).update(updateInfoAccumulator);
            boolean bl = existUpdate = update != 0;
        }
        if (this.updateAttRecordHis) {
            RecordUpgrade attRecordHisUpgrade = new RecordUpgrade("wtdtd_attrecordbasehis", "t_wtdtd_attrecordbasehis", this.storeCacheUpperLimit);
            update = attRecordHisUpgrade.setPerAttPeriodGetter(perAttPeriodGetter).update(updateInfoAccumulator);
            boolean bl = existUpdate = existUpdate || update != 0;
        }
        if (this.updateTotalRecord) {
            SummaryRecordUpgrade attSummaryRecordUpgrade = new SummaryRecordUpgrade("wtctd_atttotalbase", "t_wtctd_atttotalbase", this.storeCacheUpperLimit);
            update = attSummaryRecordUpgrade.setPerAttPeriodGetter(perAttPeriodGetter).update(updateInfoAccumulator);
            boolean bl = existUpdate = existUpdate || update != 0;
        }
        if (this.updateTotalRecordHis) {
            SummaryRecordUpgrade attSummaryRecordHisUpgrade = new SummaryRecordUpgrade("wtctd_atttotalbasehis", "t_wtctd_atttotalbasehis", this.storeCacheUpperLimit);
            update = attSummaryRecordHisUpgrade.setPerAttPeriodGetter(perAttPeriodGetter).update(updateInfoAccumulator);
            boolean bl = existUpdate = existUpdate || update != 0;
        }
        if (this.updateInfo) {
            WtteInfoUpgrade infoUpgrade = new WtteInfoUpgrade("wtte_settleinfo", "t_wtte_settleinfo", this.storeCacheUpperLimit);
            update = infoUpgrade.setPerAttPeriodGetter(perAttPeriodGetter).update(updateInfoAccumulator);
            boolean bl = existUpdate = existUpdate || update != 0;
        }
        if (this.updateInfoHis) {
            WtteInfoUpgrade infoHisUpgrade = new WtteInfoUpgrade("wtte_settleinfohis", "t_wtte_settleinfohis", this.storeCacheUpperLimit);
            update = infoHisUpgrade.setPerAttPeriodGetter(perAttPeriodGetter).update(updateInfoAccumulator);
            existUpdate = existUpdate || update != 0;
        }
        return existUpdate;
    }

    private static class PerAttPeriodGetter {
        private final IDNumberGetter idNumGetter;
        private final List<Object[]> insertDataList = new ArrayList<Object[]>(16);
        private final Map<String, Long> cache = new HashMap<String, Long>(16);
        private final Date currentDate = new Date();
        private static final long illegalPerAttPeriodId = 99999999L;
        private static final String routeKey = "wtc";
        private static final int idIndex = 0;
        private static final String insert_sql = "INSERT INTO t_wtp_perattperiod (fid, fnumber, fattpersonid, fattfileid, fattfilevid, fperiodid, fperiodentryid, fstartdate, fenddate, ftotaldays, fbusistatus, flaststorage, ffirstnotstorage, fcreatorid, fcreatetime, fmodifytime, fmodifierid) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";

        public PerAttPeriodGetter(Set<Long> attPersonIdSet, IDNumberGetter idNumGetter) {
            PerAttPeriodQueryParam param = new PerAttPeriodQueryParam();
            param.setAttPersonIdSet(attPersonIdSet);
            param.setBusiStatus("1");
            List perAttPeriods = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(param);
            for (PerAttPeriod perAttPeriod : perAttPeriods) {
                this.cache.put(perAttPeriod.getId(), perAttPeriod.getPrimaryId());
            }
            param.setBusiStatus("0");
            perAttPeriods = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(param);
            for (PerAttPeriod perAttPeriod : perAttPeriods) {
                this.cache.put(perAttPeriod.getId(), perAttPeriod.getPrimaryId());
            }
            this.idNumGetter = idNumGetter;
        }

        private void flushNewDataNow() {
            if (WTCCollections.isNotEmpty(this.insertDataList)) {
                HRDBUtil.executeBatch((DBRoute)new DBRoute(routeKey), (String)insert_sql, this.insertDataList);
                this.insertDataList.clear();
            }
        }

        private long getOrGenPerAttPeriod(String perAttPeriodKey, Long attFileVid, Long attFileBoId, Long periodId) {
            if (perAttPeriodKey == null) {
                return 99999999L;
            }
            Long perAttPeriodPK = this.cache.get(perAttPeriodKey);
            if (perAttPeriodPK != null) {
                return perAttPeriodPK;
            }
            if (attFileVid == null || attFileBoId == null || periodId == null) {
                return 99999999L;
            }
            Object[] perAttPeriodData = this.genPerAttPeriod(perAttPeriodKey, attFileVid, attFileBoId, periodId, this.currentDate);
            if (perAttPeriodData.length > 0) {
                Long perAttPeriodDatum = (Long)perAttPeriodData[0];
                this.cache.put(perAttPeriodKey, perAttPeriodDatum);
                this.insertDataList.add(perAttPeriodData);
                return perAttPeriodDatum;
            }
            return 99999999L;
        }

        private Object[] genPerAttPeriod(String perAttPeriodKey, long attFileVid, long attFileBoId, long periodId, Date date) {
            if (HRStringUtils.isEmpty((String)perAttPeriodKey) || attFileVid == 0L || attFileBoId == 0L || periodId == 0L) {
                return new Object[0];
            }
            try {
                long pkId = this.idNumGetter.getGlobalLongId();
                String number = this.idNumGetter.getNumber();
                String[] split = perAttPeriodKey.split("_");
                if (split.length < 3) {
                    return new Object[0];
                }
                long attPersonId = Long.parseLong(split[0]);
                long periodEntryId = Long.parseLong(split[1]);
                Date startDate = WTCDateUtils.str2Date((String)split[2], (String)"yyyy-MM-dd");
                Date endDate = WTCDateUtils.str2Date((String)split[3], (String)"yyyy-MM-dd");
                int totalDays = WTCDateUtils.daysBetween((Date)startDate, (Date)endDate) + 1;
                return new Object[]{pkId, number, attPersonId, attFileBoId, attFileVid, periodId, periodEntryId, startDate, endDate, totalDays, "0", Character.valueOf('0'), Character.valueOf('0'), 1L, date, date, 1L};
            }
            catch (Exception exception) {
                log.error((Throwable)exception);
                return new Object[0];
            }
        }
    }

    private static class IDNumberGetter {
        private static final int batchSize = 1000;
        private long[] globalLongIds = DB.genGlobalLongIds((int)1000);
        private int idVernier = 0;
        private String[] numbers = new String[0];
        private int numberVernier = 0;

        private IDNumberGetter() {
        }

        public long getGlobalLongId() {
            if (this.idVernier == this.globalLongIds.length) {
                this.globalLongIds = DB.genGlobalLongIds((int)1000);
                this.idVernier = 0;
            }
            return this.globalLongIds[this.idVernier++];
        }

        public String getNumber() {
            if (this.numberVernier == this.numbers.length) {
                this.numbers = CodeRuleServiceHelper.getBatchNumber((String)"wtp_perattperiod", (DynamicObject)new HRBaseServiceHelper("wtp_perattperiod").generateEmptyDynamicObject(), null, (int)1000);
                this.numberVernier = 0;
            }
            return this.numbers[this.numberVernier++];
        }
    }

    private static class WtteInfoUpgrade {
        private PerAttPeriodGetter perAttPeriodGetter;
        private final int storeBatchSize;
        private final String entityName;
        private final String tableName;
        private static final String bdRouterKey = "wtc.wtte";
        private static final String orderBy = "createtime desc";
        private static final String selectFields = "id,perattperiod,attfile,attfile.id,attfile.boid,attperiod,attperiod.masterid,attperiod.masterid.id";
        private int expectUpdateCnt = 0;
        private int actualUpdateCnt = 0;
        private List<Object[]> updateDataList = new ArrayList<Object[]>(16);

        public WtteInfoUpgrade(String entityName, String tableName, int storeBatchSize) {
            this.entityName = entityName;
            this.tableName = tableName;
            this.storeBatchSize = storeBatchSize;
        }

        public WtteInfoUpgrade setPerAttPeriodGetter(PerAttPeriodGetter perAttPeriodGetter) {
            this.perAttPeriodGetter = perAttPeriodGetter;
            return this;
        }

        private int update(UpdateInfoAccumulator updateInfoAccumulator) {
            HRBaseServiceHelper attRecordMainDao = new HRBaseServiceHelper(this.entityName);
            QFilter qFilter = new QFilter("attfile", "in", updateInfoAccumulator.getAttFileVIdSet());
            QFilter qFilter2 = new QFilter("attperattperiodpk", "=", (Object)0L);
            qFilter.and(qFilter2);
            try (DataSet dataSet = attRecordMainDao.queryDataSet(this.getClass().getName() + ".queryDataSet." + this.entityName, selectFields, qFilter.toArray(), orderBy);){
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    long perAttPeriod = this.perAttPeriodGetter.getOrGenPerAttPeriod(next.getString("perattperiod"), next.getLong("attfile.id"), next.getLong("attfile.boid"), next.getLong("attperiod.masterid.id"));
                    if (perAttPeriod != 0L) {
                        Object[] updateData = new Object[]{perAttPeriod, next.getLong("id")};
                        this.store(updateData);
                    }
                    ++this.expectUpdateCnt;
                }
                this.storeNow();
                log.info("PerAttPeriodBizDataUpgrade-WtteInfoUpgrade update data for attFileVIdSet={}, expectUpdateCnt={}, actualUpdateCnt={}", new Object[]{updateInfoAccumulator.getAttFileVIdSet(), this.expectUpdateCnt, this.actualUpdateCnt});
                int n = this.actualUpdateCnt;
                return n;
            }
        }

        private void store(Object[] updateData) {
            if (this.updateDataList.size() >= this.storeBatchSize) {
                this.storeNow();
                this.updateDataList = new ArrayList<Object[]>(16);
            }
            this.updateDataList.add(updateData);
        }

        private void storeNow() {
            if (WTCCollections.isNotEmpty(this.updateDataList)) {
                this.perAttPeriodGetter.flushNewDataNow();
                HRDBUtil.executeBatch((DBRoute)new DBRoute(bdRouterKey), (String)("update " + this.tableName + " set fattperattperiodpk = ? where fid = ?"), this.updateDataList);
                this.actualUpdateCnt += this.updateDataList.size();
                this.updateDataList = new ArrayList<Object[]>(16);
            }
        }
    }

    private static class SummaryRecordUpgrade {
        private PerAttPeriodGetter perAttPeriodGetter;
        private final int storeBatchSize;
        private final String entityName;
        private final String tableName;
        private static final String bdRouterKey = "wtc.wtctd";
        private static final String orderBy = "perperiodbegindate desc";
        private static final String sumRecordField = "id,attfileid,attfileid.id,attfilevid,attfilevid.id,personid,personid.id,attperattperiodid,perattperiodid,perattperiodid.masterid,perattperiodid.masterid.id";
        private int expectUpdateCnt = 0;
        private int actualUpdateCnt = 0;
        private List<Object[]> updateDataList = new ArrayList<Object[]>(16);

        public SummaryRecordUpgrade(String entityName, String tableName, int storeBatchSize) {
            this.entityName = entityName;
            this.tableName = tableName;
            this.storeBatchSize = storeBatchSize;
        }

        public SummaryRecordUpgrade setPerAttPeriodGetter(PerAttPeriodGetter perAttPeriodGetter) {
            this.perAttPeriodGetter = perAttPeriodGetter;
            return this;
        }

        private int update(UpdateInfoAccumulator updateInfoAccumulator) {
            HRBaseServiceHelper attRecordMainDao = new HRBaseServiceHelper(this.entityName);
            QFilter qFilter = new QFilter("attfileid", "in", updateInfoAccumulator.getAttFileBoIdSet());
            QFilter qFilter2 = new QFilter("attperattperiodpk", "=", (Object)0L);
            qFilter.and(qFilter2);
            try (DataSet dataSet = attRecordMainDao.queryDataSet(this.getClass().getName() + ".queryDataSet." + this.entityName, sumRecordField, qFilter.toArray(), orderBy);){
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    long perAttPeriod = this.perAttPeriodGetter.getOrGenPerAttPeriod(next.getString("attperattperiodid"), next.getLong("attfilevid.id"), next.getLong("attfileid.id"), next.getLong("perattperiodid.masterid.id"));
                    if (perAttPeriod != 0L) {
                        Object[] updateData = new Object[]{perAttPeriod, next.getLong("id")};
                        this.store(updateData);
                    }
                    ++this.expectUpdateCnt;
                }
                this.storeNow();
            }
            log.info("PerAttPeriodBizDataUpgrade-SummaryRecordUpgrade update data for attFileBoIdSet={}, expectUpdateCnt={}, actualUpdateCnt={}", new Object[]{updateInfoAccumulator.getAttFileBoIdSet(), this.expectUpdateCnt, this.actualUpdateCnt});
            return this.actualUpdateCnt;
        }

        private void store(Object[] updateData) {
            if (this.updateDataList.size() >= this.storeBatchSize) {
                this.storeNow();
            }
            this.updateDataList.add(updateData);
        }

        private void storeNow() {
            if (WTCCollections.isNotEmpty(this.updateDataList)) {
                this.perAttPeriodGetter.flushNewDataNow();
                HRDBUtil.executeBatch((DBRoute)new DBRoute(bdRouterKey), (String)("update " + this.tableName + " set fattperattperiodpk = ? where fid = ?"), this.updateDataList);
                this.actualUpdateCnt += this.updateDataList.size();
                this.updateDataList = new ArrayList<Object[]>(16);
            }
        }
    }

    private static class RecordUpgrade {
        private PerAttPeriodGetter perAttPeriodGetter;
        private final int storeBatchSize;
        private final String entityName;
        private final String tableName;
        private static final String bdRouterKey = "wtc.wtdtd";
        private static final String orderBy = "owndate desc";
        private static final String attRecordField = "id,attfileid,attfilevid,attfilevid.id,personid,personid.id,attperattperiodid,perattperiodid,perattperiodid.masterid,perattperiodid.masterid.id";
        private int expectUpdateCnt = 0;
        private int actualUpdateCnt = 0;
        private List<Object[]> updateDataList = new ArrayList<Object[]>(16);

        public RecordUpgrade(String entityName, String tableName, int storeBatchSize) {
            this.entityName = entityName;
            this.tableName = tableName;
            this.storeBatchSize = storeBatchSize;
        }

        public RecordUpgrade setPerAttPeriodGetter(PerAttPeriodGetter perAttPeriodGetter) {
            this.perAttPeriodGetter = perAttPeriodGetter;
            return this;
        }

        private int update(UpdateInfoAccumulator updateInfoAccumulator) {
            HRBaseServiceHelper attRecordMainDao = new HRBaseServiceHelper(this.entityName);
            QFilter qFilter = new QFilter("attfileid", "in", updateInfoAccumulator.getAttFileBoIdSet());
            QFilter qFilter2 = new QFilter("attperattperiodpk", "=", (Object)0L);
            qFilter.and(qFilter2);
            try (DataSet dataSet = attRecordMainDao.queryDataSet(this.getClass().getName() + ".queryDataSet." + this.entityName, attRecordField, qFilter.toArray(), orderBy);){
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    long perAttPeriod = this.perAttPeriodGetter.getOrGenPerAttPeriod(next.getString("attperattperiodid"), next.getLong("attfilevid.id"), next.getLong("attfileid"), next.getLong("perattperiodid.masterid.id"));
                    if (perAttPeriod != 0L) {
                        Object[] updateData = new Object[]{perAttPeriod, next.getLong("id")};
                        this.store(updateData);
                    }
                    ++this.expectUpdateCnt;
                }
                this.storeNow();
            }
            log.info("PerAttPeriodBizDataUpgrade-RecordUpgrade update data for attFileBoIdSet={}, expectUpdateCnt={}, actualUpdateCnt={}", new Object[]{updateInfoAccumulator.getAttFileBoIdSet(), this.expectUpdateCnt, this.actualUpdateCnt});
            return this.actualUpdateCnt;
        }

        private void store(Object[] updateData) {
            if (this.updateDataList.size() >= this.storeBatchSize) {
                this.storeNow();
            }
            this.updateDataList.add(updateData);
        }

        private void storeNow() {
            if (WTCCollections.isNotEmpty(this.updateDataList)) {
                this.perAttPeriodGetter.flushNewDataNow();
                HRDBUtil.executeBatch((DBRoute)new DBRoute(bdRouterKey), (String)("update " + this.tableName + " set fattperattperiodpk = ? where fid = ?"), this.updateDataList);
                this.actualUpdateCnt += this.updateDataList.size();
                this.updateDataList = new ArrayList<Object[]>(16);
            }
        }
    }

    private static class UpdateInfoAccumulator {
        private final int accumulatorUpperLimit;
        final Set<Long> attPersonIdSet;
        final Set<Long> attFileBoIdSet;
        final Set<Long> attFileVIdSet;

        public UpdateInfoAccumulator(int accumulatorUpperLimit) {
            this.accumulatorUpperLimit = accumulatorUpperLimit;
            this.attPersonIdSet = new HashSet<Long>(accumulatorUpperLimit << 1);
            this.attFileBoIdSet = new HashSet<Long>(accumulatorUpperLimit << 1);
            this.attFileVIdSet = new HashSet<Long>(accumulatorUpperLimit << 1);
        }

        public boolean addIfLegal(Long attPersonId, Long attFileBoId, Long attFileVId) {
            if (attPersonId != null && this.attPersonIdSet.size() >= this.accumulatorUpperLimit && !this.attPersonIdSet.contains(attPersonId)) {
                return true;
            }
            if (attPersonId != null) {
                this.attPersonIdSet.add(attPersonId);
            }
            if (attFileBoId != null) {
                this.attFileBoIdSet.add(attFileBoId);
            }
            if (attFileVId != null) {
                this.attFileVIdSet.add(attFileVId);
            }
            return false;
        }

        public void clear() {
            this.attPersonIdSet.clear();
            this.attFileBoIdSet.clear();
            this.attFileVIdSet.clear();
        }

        public boolean hasStockInfo() {
            return !this.attPersonIdSet.isEmpty() || !this.attFileBoIdSet.isEmpty() || !this.attFileVIdSet.isEmpty();
        }

        public Set<Long> getAttPersonIdSet() {
            return this.attPersonIdSet;
        }

        public Set<Long> getAttFileBoIdSet() {
            return this.attFileBoIdSet;
        }

        public Set<Long> getAttFileVIdSet() {
            return this.attFileVIdSet;
        }
    }
}

