/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;

public class QTDeductRuleUpgrade
extends AbstractWtcTaskUpgrade {
    private static final String QUERY_WTP_QTDEDUCTRULE = "select fid,fboid,fstatus from t_wtp_qtdeducrule";
    private static final String INSERT_WTP_QTDEDUCODENTRY = "insert into t_wtp_qtdeducodentry(fid,fentryid,fseq,fsortfield,fsortrule,fentryboid) values(?,?,?,?,?,?)";
    private static final String UPDATE_WTP_QTDEDUCODENTRY = "update t_wtp_qtdeducodentry set fentryboid = ? where fentryid = ?";
    private long[] globalLongIds = DB.genGlobalLongIds((int)1000);
    private int idVernier = 0;

    protected String getJobId() {
        return "3GW03=L5V7FT";
    }

    protected String getScheduleId() {
        return "3GW07OO91GRK";
    }

    protected boolean process() {
        HashMap<Long, List> deductRuleMap = new HashMap<Long, List>(16);
        DBRoute wtcDbRoute = new DBRoute("wtc");
        try (DataSet deductRuleDataSet = HRDBUtil.queryDataSet((String)"wtp", (DBRoute)wtcDbRoute, (String)QUERY_WTP_QTDEDUCTRULE, null);){
            while (deductRuleDataSet.hasNext()) {
                Row next = deductRuleDataSet.next();
                SlimDeductRule slimDeductRule = new SlimDeductRule();
                slimDeductRule.fid = next.getLong("fid");
                slimDeductRule.fboid = next.getLong("fboid");
                slimDeductRule.fstatus = next.getString("fstatus");
                deductRuleMap.computeIfAbsent(slimDeductRule.fboid, key -> new ArrayList(16)).add(slimDeductRule);
            }
        }
        if (deductRuleMap.isEmpty()) {
            return true;
        }
        HashMap<Long, List<SlimOrderRule>> orderMap = new HashMap<Long, List<SlimOrderRule>>(16);
        Set deductRuleIdSet = deductRuleMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).map(rule -> rule.fid).collect(Collectors.toSet());
        String selectSql = "select fid,fentryid,fseq,fsortfield,fsortrule,fentryboid from t_wtp_qtdeducodentry where fid in (" + deductRuleIdSet.stream().map(String::valueOf).collect(Collectors.joining(",")) + ")";
        try (DataSet orderRuleDataSet = HRDBUtil.queryDataSet((String)"wtp", (DBRoute)wtcDbRoute, (String)selectSql, null);){
            while (orderRuleDataSet.hasNext()) {
                Row next = orderRuleDataSet.next();
                SlimOrderRule slimOrderRule = new SlimOrderRule();
                slimOrderRule.fid = next.getLong("fid");
                slimOrderRule.fentryid = next.getLong("fentryid");
                slimOrderRule.fentryboid = next.getLong("fentryboid");
                orderMap.computeIfAbsent(slimOrderRule.fid, key -> new ArrayList(16)).add(slimOrderRule);
            }
        }
        ArrayList<Object[]> saveDataList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> updateDataList = new ArrayList<Object[]>(16);
        for (Map.Entry entry2 : deductRuleMap.entrySet()) {
            List deductRuleList = (List)entry2.getValue();
            Long entryBoId = this.getOrGenEntryBoId(deductRuleList, orderMap);
            for (SlimDeductRule deductRule : deductRuleList) {
                List slimOrderRules = (List)orderMap.get(deductRule.fid);
                if (slimOrderRules == null || slimOrderRules.isEmpty()) {
                    Object[] saveData = new Object[]{deductRule.fid, this.getGlobalLongId(), 1, "C", "A", entryBoId};
                    saveDataList.add(saveData);
                    continue;
                }
                for (SlimOrderRule slimOrderRule : slimOrderRules) {
                    if (slimOrderRule.fentryboid.equals(entryBoId)) continue;
                    Object[] updateData = new Object[]{entryBoId, slimOrderRule.fentryid};
                    updateDataList.add(updateData);
                }
            }
        }
        if (!saveDataList.isEmpty()) {
            HRDBUtil.executeBatch((DBRoute)wtcDbRoute, (String)INSERT_WTP_QTDEDUCODENTRY, saveDataList);
        }
        if (!updateDataList.isEmpty()) {
            HRDBUtil.executeBatch((DBRoute)wtcDbRoute, (String)UPDATE_WTP_QTDEDUCODENTRY, updateDataList);
        }
        return true;
    }

    private long getGlobalLongId() {
        if (this.idVernier == this.globalLongIds.length) {
            this.globalLongIds = DB.genGlobalLongIds((int)1000);
            this.idVernier = 0;
        }
        return this.globalLongIds[this.idVernier++];
    }

    private Long getOrGenEntryBoId(List<SlimDeductRule> deductRuleList, Map<Long, List<SlimOrderRule>> orderMap) {
        Long fentryboid = 0L;
        boolean needEntryBoId = false;
        ArrayList<Long> occurEntryId = new ArrayList<Long>(16);
        block0: for (SlimDeductRule deductRule : deductRuleList) {
            boolean bl = needEntryBoId = needEntryBoId || "C".equalsIgnoreCase(deductRule.fstatus);
            List<SlimOrderRule> slimOrderRules = orderMap.get(deductRule.fid);
            if (slimOrderRules == null) continue;
            for (SlimOrderRule order : slimOrderRules) {
                occurEntryId.add(order.fentryid);
                if (order.fentryboid == null || order.fentryboid == 0L) continue;
                fentryboid = order.fentryboid;
                continue block0;
            }
        }
        if (fentryboid == 0L) {
            if (needEntryBoId) {
                Optional<Long> first = occurEntryId.stream().filter(Objects::nonNull).filter(ele -> ele != 0L).findFirst();
                return first.orElseGet(this::getGlobalLongId);
            }
            return 0L;
        }
        return fentryboid;
    }

    private static class SlimOrderRule {
        Long fid;
        Long fentryid;
        Long fentryboid;

        private SlimOrderRule() {
        }
    }

    private static class SlimDeductRule {
        Long fid;
        Long fboid;
        String fstatus;

        private SlimDeductRule() {
        }
    }
}

