/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.business.upgrade.WTCUpgradeService;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class QTQualificationUpgrade
extends WTCUpgradeService {
    private static final Log logger = LogFactory.getLog(QTQualificationUpgrade.class);
    private final List<Long> idList = Lists.newArrayListWithExpectedSize((int)10);
    private final Map<Long, Map<String, Object>> map = Maps.newHashMapWithExpectedSize((int)10);

    public void upgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("QTQualificationUpgrade upgradeAction start .....");
        if (CollectionUtils.isEmpty(this.map)) {
            return;
        }
        try {
            logger.info("QTQualificationUpgrade upgradeAction ids={}", this.map.keySet());
            DBRoute dbRoute = new DBRoute("wtc");
            String sql = "update t_wtp_qtqualification set finspectrang =?,fconditionstr =?,fqualitytype=?,flimitmethod=?,flimitquatity=?,flimitprecentg=? where fid=?;";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(this.map.size());
            for (Map.Entry<Long, Map<String, Object>> entry : this.map.entrySet()) {
                Row row;
                DataSet dataSet;
                String itemSql;
                Long id = entry.getKey();
                Map<String, Object> propMap = entry.getValue();
                if (CollectionUtils.isEmpty(propMap)) continue;
                Object inspectRang = propMap.get("inspectrang");
                Object qualityType = propMap.get("qualitytype");
                String relation = (String)propMap.get("relation");
                BigDecimal value = (BigDecimal)propMap.get("quatity");
                String conditionStr = "{\"conditionList\":[{\"displayParam\":\"%1$s\",\"paramType\":\"number\",\"displayValue\":\"%2$s\",\"index\":0,\"name\":\"T01\",\"operators\":\"%3$s\",\"param\":\"%4$s\",\"target\":false,\"value\":\"%5$s\",\"valueType\":\"2\"}]  ,\"conditionExpressType\":\"0\",\"conditionExpressList\":[{\"name\":\"T01\"}],\"conditionExpressStr\":\"T01\"}";
                String name = "";
                String param = "";
                if ("A".equals((String)qualityType)) {
                    Long attItemId = (Long)propMap.get("attitemid");
                    param = String.valueOf(attItemId);
                    itemSql = "select fname from t_wtbd_attitem where  fid =" + attItemId + " ;";
                    dataSet = HRDBUtil.queryDataSet((String)"attitem ", (DBRoute)dbRoute, (String)itemSql, null);
                    while (dataSet.hasNext()) {
                        row = dataSet.next();
                        name = row.getString("fname");
                    }
                } else {
                    Long varConditionId = (Long)propMap.get("varconditionid");
                    param = String.valueOf(varConditionId);
                    itemSql = "select fname from t_wtbd_qtvarcondition where  fid =" + varConditionId + " ;";
                    dataSet = HRDBUtil.queryDataSet((String)"qtvarcondition ", (DBRoute)dbRoute, (String)itemSql, null);
                    while (dataSet.hasNext()) {
                        row = dataSet.next();
                        name = row.getString("fname");
                    }
                }
                String condtion = String.format(conditionStr, name, value, relation, param, value);
                Object limitMethod = propMap.get("limitmethod");
                Object limitQuatity = propMap.get("limitquatity");
                Object limitPrecenTg = propMap.get("limitprecentg");
                paramsList.add(new Object[]{inspectRang, condtion, qualityType, limitMethod, limitQuatity, limitPrecenTg, id});
            }
            int[] ints = HRDBUtil.executeBatch((DBRoute)dbRoute, (String)sql, paramsList);
            logger.info("QTQualificationUpgrade upgradeAction success size={}", (Object)ints.length);
        }
        catch (Exception exception) {
            String msg = "QTQualificationUpgrade exception";
            logger.warn(msg, (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("AttendPersonUpgrade", msg), new Object[0]);
        }
        logger.info("QTQualificationUpgrade upgradeAction end .....");
    }

    public void beforeUpgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        super.beforeUpgradeAction(ver, iteration, dbKey, sqlFileName);
        DBRoute dbRoute = new DBRoute("wtc");
        String personSql = "select fid from t_wtp_qtqualification where  finspectrang =' ';";
        DataSet dataSet = HRDBUtil.queryDataSet((String)"qtqualification", (DBRoute)dbRoute, (String)personSql, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            this.idList.add(row.getLong("fid"));
        }
        if (!CollectionUtils.isEmpty(this.idList)) {
            ArrayList<Long> ids = new ArrayList<Long>(200);
            for (int i = 0; i < this.idList.size(); ++i) {
                Long id = this.idList.get(i);
                ids.add(id);
                if (i % 200 != 0 && i != this.idList.size() - 1) continue;
                String idListStr = StringUtils.join(ids, (String)",");
                DBRoute hrDbRoute = new DBRoute("wtc");
                String sql = "select fid,finspectrang,fqualitytype,frelation,fvarconditionid,fattitemid,fquatity,flimitquatity,flimitprecentg,flimitmethod from t_wtp_qtqualificationinf where fid in(" + idListStr + ");";
                HRDBUtil.query((DBRoute)hrDbRoute, (String)sql, null, resultSet -> {
                    while (resultSet.next()) {
                        HashMap propMap = Maps.newHashMapWithExpectedSize((int)10);
                        propMap.put("inspectrang", resultSet.getString("finspectrang"));
                        propMap.put("qualitytype", resultSet.getString("fqualitytype"));
                        propMap.put("relation", resultSet.getString("frelation"));
                        propMap.put("varconditionid", resultSet.getLong("fvarconditionid"));
                        propMap.put("attitemid", resultSet.getLong("fattitemid"));
                        propMap.put("quatity", resultSet.getBigDecimal("fquatity", 2));
                        propMap.put("limitquatity", resultSet.getBigDecimal("flimitquatity"));
                        propMap.put("limitprecentg", resultSet.getBigDecimal("flimitprecentg"));
                        propMap.put("limitmethod", resultSet.getString("flimitmethod"));
                        this.map.put(resultSet.getLong("fid"), propMap);
                    }
                    return null;
                });
                ids.clear();
            }
        }
    }
}

