/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attend.validate;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.web.applybill.ruleengine.PlanRuleEngineHelper;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class AttendPlanValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        HashSet planIds = Sets.newHashSetWithExpectedSize((int)this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            planIds.add((Long)dataEntity.getValue("id"));
        }
        List policyByPlanIds = PlanRuleEngineHelper.getPolicyByPlanIds((Collection)planIds);
        Set enGineIdSet = policyByPlanIds.stream().map(dy -> dy.getLong("planid")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            boolean isEngineSetWay = false;
            String type = (String)dataEntity.getValue("setruleway");
            isEngineSetWay = !HRStringUtils.isEmpty((String)type) ? HRStringUtils.equals((String)"2", (String)type) : enGineIdSet.contains((Long)dataEntity.getValue("id"));
            DynamicObject rule = (DynamicObject)dataEntity.getValue("attdencerule");
            if (isEngineSetWay) continue;
            if (rule == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u52e4\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttendPlanValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                continue;
            }
            Date besd = (Date)dataEntity.getValue("bsed");
            if (besd == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65f6\u95f4\u201d\u3002", (String)"AttendPlanValidator_2", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            }
            Date firstDate = rule.getDate("firstbsed");
            if (besd == null || firstDate == null || !firstDate.after(besd)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u89c4\u5219\u6700\u65e9\u751f\u6548\u65f6\u95f4\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"AttendPlanValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
    }
}

