/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonSynService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HBJMMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HBPMMServiceImpl;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.business.attfile.adjust.AttFileAdjustUpdateServiceImpl;
import kd.wtc.wtp.common.model.file.AttFileAdjustModel;
import kd.wtc.wtp.common.model.file.FileSaveDto;
import kd.wtc.wtp.opplugin.web.attfile.validator.AttFileBaseAdjustValidator;

public class AttFileBaseAdjustOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs validatorsEventArgs) {
        validatorsEventArgs.addValidator((AbstractValidator)new AttFileBaseAdjustValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        e.setCancelOperation(true);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        DynamicObject dataEntity = dataEntities[0];
        String selectAttFileVersionIdStr = (String)this.getOption().getVariables().get("selectattfileversionid");
        if (HRStringUtils.isEmpty((String)selectAttFileVersionIdStr)) {
            long orgId = dataEntity.getLong("org.id");
            Map variablesMap = this.getOption().getVariables();
            String boId = (String)variablesMap.get("op_org_variables");
            if (StringUtils.isEmpty((CharSequence)boId)) {
                return;
            }
            AttFileServiceImpl.getInstance().adjust(Long.valueOf(orgId), Collections.singletonList(Long.parseLong(boId)));
        } else {
            String fileCoreDataVo = this.getOption().getVariableValue("fileCoreDataVo");
            if (HRStringUtils.isEmpty((String)fileCoreDataVo)) {
                return;
            }
            FileSaveDto fileSaveDto = (FileSaveDto)SerializationUtils.fromJsonString((String)fileCoreDataVo, FileSaveDto.class);
            AttFileAdjustModel attFileAdjustModel = this.getAttFileAdjustModel(fileSaveDto);
            try (TXHandle txHandle = TX.notSupported();){
                AttFileAdjustUpdateServiceImpl.getInstance().refreshDownBusinessData((List)Lists.newArrayList((Object[])new AttFileAdjustModel[]{attFileAdjustModel}));
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)1);
            map.put("employee", Arrays.stream(dataEntities).map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee")).collect(Collectors.toList()));
            AttendPersonCurrResult attendPersonCurrResult = AttendPersonSynService.getInstance().checkAndGetPersonDataCustom(Collections.singletonList(fileSaveDto.getPersonId()), Collections.singletonList(fileSaveDto.getEmpPosOrgRelId()), null, (Map)map);
            AttendPersonSynService.getInstance().dealEmpPosOrgRel(attendPersonCurrResult.getAttendPersonCurrModels(), true);
            DynamicObject attFile = AttFileQueryServiceImpl.getInstance().queryOneAttFile("", (Object)Long.valueOf(selectAttFileVersionIdStr));
            attFile.set("company", (Object)WTCDynamicObjectUtils.getDy((String)"haos_adminorghr", (Long)fileSaveDto.getCompanyId()));
            attFile.set("adminorg", (Object)WTCDynamicObjectUtils.getDy((String)"haos_adminorghr", (Long)fileSaveDto.getAdminOrgId()));
            attFile.set("position", (Object)WTCDynamicObjectUtils.getDy((String)"hbpm_positionhr", (Long)fileSaveDto.getPositionId()));
            attFile.set("job", (Object)WTCDynamicObjectUtils.getDy((String)"hbjm_jobhr", (Long)fileSaveDto.getJobId()));
            attFile.set("agreedlocation", (Object)WTCDynamicObjectUtils.getDy((String)"hbss_workplace", (Long)fileSaveDto.getAgreedLocation()));
            attFile.set("hrpiempposorgrel", (Object)WTCDynamicObjectUtils.getDy((String)"hrpi_empposorgrel", (Long)fileSaveDto.getEmpPosOrgRelId()));
            attFile.set("empposorgrel", (Object)WTCDynamicObjectUtils.getDy((String)"wtp_depempjob", (Long)fileSaveDto.getEmpPosOrgRelId()));
            attFile.set("depemp", (Object)WTCDynamicObjectUtils.getDy((String)"hrpi_depemp", (Long)fileSaveDto.getDepempId()));
            attFile.set("cmpemp", (Object)WTCDynamicObjectUtils.getDy((String)"hrpi_cmpemp", (Long)fileSaveDto.getCmpempId()));
            AttFileServiceImpl.getInstance().attFileRevise(new DynamicObject[]{attFile});
        }
    }

    private AttFileAdjustModel getAttFileAdjustModel(FileSaveDto fileSaveDto) {
        Map jobTimeSeqBoMap;
        Map positionTimeSeqBoMap;
        Map adminOrgTimeSeqBoMap;
        AttFileAdjustModel adjustModel = new AttFileAdjustModel();
        adjustModel.setBoId(fileSaveDto.getBoId());
        adjustModel.setVersionId(fileSaveDto.getId());
        HAOSMServiceImpl instanceHaos = HAOSMServiceImpl.getInstance();
        Date startDate = WTCDateUtils.getMinEndDate();
        Date endDate = WTCDateUtils.getMaxEndDate();
        Map companyTimeSeqBoMap = AttendPersonServiceImpl.getInstance().getTimeSeqBoMap(instanceHaos.batchGetOrgInfo(startDate, endDate, (List)Lists.newArrayList((Object[])new Long[]{fileSaveDto.getCompanyId()})), (arg_0, arg_1) -> ((AttendPersonServiceImpl)AttendPersonServiceImpl.getInstance()).genCompany(arg_0, arg_1));
        if (companyTimeSeqBoMap != null && companyTimeSeqBoMap.containsKey(fileSaveDto.getCompanyId())) {
            adjustModel.setCompanyModel((TimeSeqBo)companyTimeSeqBoMap.get(fileSaveDto.getCompanyId()));
        }
        if ((adminOrgTimeSeqBoMap = AttendPersonServiceImpl.getInstance().getTimeSeqBoMap(instanceHaos.batchGetOrgInfo(startDate, endDate, (List)Lists.newArrayList((Object[])new Long[]{fileSaveDto.getAdminOrgId()})), (arg_0, arg_1) -> ((AttendPersonServiceImpl)AttendPersonServiceImpl.getInstance()).genAdminOrg(arg_0, arg_1))) != null && adminOrgTimeSeqBoMap.containsKey(fileSaveDto.getAdminOrgId())) {
            adjustModel.setAdminOrgModel((TimeSeqBo)adminOrgTimeSeqBoMap.get(fileSaveDto.getAdminOrgId()));
        }
        if ((positionTimeSeqBoMap = AttendPersonServiceImpl.getInstance().getTimeSeqBoMap(HBPMMServiceImpl.getInstance().queryPositionHisVersion(startDate, endDate, (List)Lists.newArrayList((Object[])new Long[]{fileSaveDto.getPositionId()})), (arg_0, arg_1) -> ((AttendPersonServiceImpl)AttendPersonServiceImpl.getInstance()).genPosition(arg_0, arg_1))) != null && positionTimeSeqBoMap.containsKey(fileSaveDto.getPositionId())) {
            adjustModel.setPositionModel((TimeSeqBo)positionTimeSeqBoMap.get(fileSaveDto.getPositionId()));
        }
        if ((jobTimeSeqBoMap = AttendPersonServiceImpl.getInstance().getTimeSeqBoMap(HBJMMServiceImpl.getInstance().getJobVersionChangeInfoByEventId(startDate, endDate, (List)Lists.newArrayList((Object[])new Long[]{fileSaveDto.getJobId()})), (arg_0, arg_1) -> ((AttendPersonServiceImpl)AttendPersonServiceImpl.getInstance()).genJob(arg_0, arg_1))) != null && jobTimeSeqBoMap.containsKey(fileSaveDto.getJobId())) {
            adjustModel.setJobModel((TimeSeqBo)jobTimeSeqBoMap.get(fileSaveDto.getJobId()));
        }
        return adjustModel;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String selectAttFileVersionIdStr = (String)this.getOption().getVariables().get("selectattfileversionid");
        if (HRStringUtils.isNotEmpty((String)selectAttFileVersionIdStr)) {
            return;
        }
        if (e.getDataEntities() == null || e.getDataEntities().length == 0) {
            return;
        }
        DynamicObject dataEntity = e.getDataEntities()[0];
        long orgId = dataEntity.getLong("org.id");
        Map variablesMap = this.getOption().getVariables();
        String boId = (String)variablesMap.get("op_org_variables");
        if (StringUtils.isEmpty((CharSequence)boId)) {
            return;
        }
        AttFileServiceImpl.getInstance().updateSettleInfo(new HashSet<Long>(Collections.singletonList(Long.parseLong(boId))), Long.valueOf(orgId));
    }
}

