/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.predata.wtp.PreDataAttend;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.attfile.AttFileSyncService;
import kd.wtc.wtp.business.attfile.discard.impl.AttFileDiscardServiceImpl;
import kd.wtc.wtp.common.enums.AttFileTaskCacheInfoEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.file.AttFileDiscardCheckModel;
import kd.wtc.wtp.opplugin.web.attfile.validator.AttFileBaseDiscardValidator;
import kd.wtc.wtp.opplugin.web.attfile.validator.AttFileSynValidator;

public class AttFileBaseDiscardOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("employee.id");
        fieldKeys.add("boid");
        fieldKeys.add("usablestatus");
        fieldKeys.add("atttag");
        fieldKeys.add("person");
    }

    public void onAddValidators(AddValidatorsEventArgs validatorsEventArgs) {
        AttFileDiscardCheckModel attFileDiscardCheckModel = this.getAttFileDiscardCheckModel(null);
        validatorsEventArgs.addValidator((AbstractValidator)new AttFileBaseDiscardValidator(attFileDiscardCheckModel));
        validatorsEventArgs.addValidator((AbstractValidator)new AttFileSynValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        DynamicObject[] dataEntities = beforeOperationArgs.getDataEntities();
        Set boIdSet = Arrays.stream(dataEntities).map(d -> d.getLong("boid")).collect(Collectors.toSet());
        OperateOption option = this.getOption();
        Map boToErrMap = AttFileSyncService.getInstance().cacheAttFileSynAndSetOp(option, boIdSet, AttFileTaskCacheInfoEnum.ATT_FILE_DISCARD, "fileRemoveBoId");
        if (WTCCollections.isNotEmpty((Map)boToErrMap)) {
            AttFileSyncService.getInstance().removeFileSynOpCache(option, "fileRemoveBoId");
            throw new KDBizException(AttFileKDString.existLockFile());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        beginOperationTransactionArgs.setCancelOperation(true);
        List<Long> fileBoIds = Arrays.stream(beginOperationTransactionArgs.getDataEntities()).map(d -> d.getLong("boid")).collect(Collectors.toList());
        AttFileDiscardCheckModel attFileDiscardCheckModel = this.getAttFileDiscardCheckModel(fileBoIds);
        OperateOption option = this.getOption();
        attFileDiscardCheckModel.setOption(option);
        List leavePersonList = Arrays.stream(beginOperationTransactionArgs.getDataEntities()).filter(dy -> PreDataAttend.PD_LEAVE == WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"atttag")).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"person")).collect(Collectors.toList());
        attFileDiscardCheckModel.setLeavePersonIds(leavePersonList);
        List failBoIds = AttFileDiscardServiceImpl.getInstance().discardAttFileHandler(attFileDiscardCheckModel);
        if (WTCCollections.isNotEmpty((Collection)failBoIds)) {
            throw new KDBizException(AttFileKDString.fileDiscardFail());
        }
    }

    public AttFileDiscardCheckModel getAttFileDiscardCheckModel(List<Long> fileBoIds) {
        AttFileDiscardCheckModel attFileDiscardCheckModel = new AttFileDiscardCheckModel();
        attFileDiscardCheckModel.setFileBoIds(fileBoIds);
        if (WTCStringUtils.isNotEmpty((String)((String)this.getOption().getVariables().get("fromcoordination")))) {
            attFileDiscardCheckModel.setFromCoordination(true);
        }
        return attFileDiscardCheckModel;
    }

    public void rollbackOperation(RollbackOperationArgs rollbackOperationArgs) {
        AttFileSyncService.getInstance().removeFileSynOpCache(this.getOption(), "fileRemoveBoId");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs afterOperationArgs) {
        AttFileSyncService.getInstance().removeFileSynOpCache(this.getOption(), "fileRemoveBoId");
    }
}

