/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.business.attfile.AttFileSyncService;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;
import kd.wtc.wtp.common.enums.AttFileTaskCacheInfoEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.opplugin.web.attfile.validator.AttFileBaseEditCertValidator;
import kd.wtc.wtp.opplugin.web.attfile.validator.AttFileBaseModifyValidator;
import kd.wtc.wtp.opplugin.web.attfile.validator.AttFileSynValidator;

public class AttFileBaseModifyOp
extends HRDataBaseOp {
    private StringBuilder sbOfCertMsg = new StringBuilder();

    public void onAddValidators(AddValidatorsEventArgs validatorsEventArgs) {
        validatorsEventArgs.addValidator((AbstractValidator)new AttFileBaseModifyValidator());
        validatorsEventArgs.addValidator((AbstractValidator)new AttFileBaseEditCertValidator(this.sbOfCertMsg));
        validatorsEventArgs.addValidator((AbstractValidator)new AttFileSynValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        DynamicObject[] dataEntities = beforeOperationArgs.getDataEntities();
        Set boIdSet = Arrays.stream(dataEntities).map(d -> d.getLong("boid")).collect(Collectors.toSet());
        OperateOption option = this.getOption();
        Map boToErrMap = AttFileSyncService.getInstance().cacheAttFileSynAndSetOp(option, boIdSet, AttFileTaskCacheInfoEnum.ATT_FILE_UPDATE, "fileRemoveBoId");
        if (WTCCollections.isNotEmpty((Map)boToErrMap)) {
            AttFileSyncService.getInstance().removeFileSynOpCache(option, "fileRemoveBoId");
            throw new KDBizException(AttFileKDString.existLockFile());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        beginOperationTransactionArgs.setCancelOperation(true);
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        this.renamingVersionDataInEffect(dataEntities);
        Arrays.stream(dataEntities).filter(dataEntity -> AttStatusEnum.ATT_STOP.getCode().equals(dataEntity.getString("atttag.attendstatus"))).forEach(dataEntity -> dataEntity.set("bsled", (Object)WTCDateUtils.str2Date((String)"2999-12-31", (String)"yyyy-MM-dd")));
        AttFileServiceImpl instance = AttFileServiceImpl.getInstance();
        Map variables = this.getOption().getVariables();
        boolean synFileVid = variables == null || !"false".equals(variables.get("synFileVid"));
        String eventIdStr = (String)this.getOption().getVariables().get("event");
        long mainBoId = DB.genGlobalLongId();
        if (WTCStringUtils.isNotEmpty((String)eventIdStr)) {
            mainBoId = Long.parseLong(eventIdStr);
        }
        instance.updateAttFile(dataEntities, Long.valueOf(mainBoId), false, synFileVid);
        String key = "schedule_Msg" + mainBoId;
        String cacheKey = WTCCacheUtils.getKey((String)"wtp", (String)key);
        DistributeSessionlessCache redis = WTCCacheUtils.getCache();
        String errMsg = (String)redis.get(cacheKey);
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            this.getOption().setVariableValue("schedule_Msg", errMsg);
            redis.remove(cacheKey);
        }
        Map<Long, Long> fileBoIdAndPersonIdMap = Arrays.stream(dataEntities).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attperson"), (a, b) -> a));
        PerAttPeriodDataService.getInstance().processAndSavePerAttPeriodData(fileBoIdAndPersonIdMap, false, false);
        AttFileServiceImpl.getInstance().saveAttPersonOtherInfoFromFileDy(dataEntities);
    }

    private void renamingVersionDataInEffect(DynamicObject[] dataEntities) {
        Set attFileBoIdSet = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getLong("boid")).collect(Collectors.toSet());
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setSetBoIds(attFileBoIdSet);
        queryParam.setBeCurrent(Boolean.valueOf(false));
        queryParam.setProperties("name, boid, bsed, bsled");
        HashSet hisDataStatus = Sets.newHashSet((Object[])new String[]{"0", "1", "2"});
        queryParam.setHisStatus((Set)hisDataStatus);
        List existsAttFileDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        Map<Long, List<DynamicObject>> existsAttFileMap = existsAttFileDys.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        for (DynamicObject currentDy : dataEntities) {
            List<DynamicObject> existsAttFileDyList = existsAttFileMap.get(currentDy.getLong("boid"));
            if (existsAttFileDyList == null || existsAttFileDyList.size() == 0) continue;
            for (DynamicObject existsAttFileDy : existsAttFileDyList) {
                Date existsAttFileBsed = existsAttFileDy.getDate("bsed");
                Date existsAttFileBsled = existsAttFileDy.getDate("bsled");
                Date currentAttFileBsled = currentDy.getDate("bsled");
                boolean isAllDateIsNotNull = existsAttFileBsed != null && existsAttFileBsled != null && currentAttFileBsled != null;
                if (!isAllDateIsNotNull || currentAttFileBsled.compareTo(existsAttFileBsed) < 0 || currentAttFileBsled.compareTo(existsAttFileBsled) > 0) continue;
                currentDy.set("name", existsAttFileDy.get("name"));
                currentDy.set("textname", existsAttFileDy.get("name"));
            }
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        IOperationResult operationResult = e.getOperationResult();
        if (this.sbOfCertMsg.length() > 10) {
            operationResult.setMessage(this.sbOfCertMsg.toString());
        }
    }

    public void rollbackOperation(RollbackOperationArgs rollbackOperationArgs) {
        AttFileSyncService.getInstance().removeFileSynOpCache(this.getOption(), "fileRemoveBoId");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs afterOperationArgs) {
        AttFileSyncService.getInstance().removeFileSynOpCache(this.getOption(), "fileRemoveBoId");
    }
}

