/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonSynService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.AttModeEnum;
import kd.wtc.wtbs.common.enums.file.FileTypeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileCheckService;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.business.attfile.AttFileSyncService;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleBusiness;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;
import kd.wtc.wtp.common.enums.AttFileTaskCacheInfoEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.opplugin.web.attfile.validator.AttFileBaseAddCertValidator;
import kd.wtc.wtp.opplugin.web.attfile.validator.AttFileBaseSaveValidator;
import kd.wtc.wtp.opplugin.web.attfile.validator.AttFileRulePlanValidator;
import kd.wtc.wtp.opplugin.web.attfile.validator.AttFileSynValidator;
import kd.wtc.wtp.opplugin.web.attfile.validator.AttFileToBeEffectValidator;

public class AttFileBaseSaveOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(AttFileBaseSaveOp.class);
    private StringBuilder sbOfCertMsg = new StringBuilder();
    private static final String ROSTER_SYN_DATA_LIST = "rosterSynDataList";

    public void onAddValidators(AddValidatorsEventArgs validatorsEventArgs) {
        AttFileBaseSaveValidator attFileBaseSaveValidator = new AttFileBaseSaveValidator();
        List validators = validatorsEventArgs.getValidators();
        validators.add(0, attFileBaseSaveValidator);
        validators.add(1, new AttFileRulePlanValidator());
        validatorsEventArgs.addValidator((AbstractValidator)new AttFileBaseAddCertValidator(this.sbOfCertMsg));
        validators.add(validators.size() - 1, new AttFileToBeEffectValidator());
        validators.add(validators.size() - 1, new AttFileSynValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        Map boToErrMap;
        OperateOption option = this.getOption();
        DynamicObject[] dataEntities = beforeOperationArgs.getDataEntities();
        Set employeeIdSet = Arrays.stream(dataEntities).map(d -> d.getLong("employee.id")).collect(Collectors.toSet());
        Map synFileBoIdMap = AttFileCheckService.getInstance().geFileBoToEmployeeMap(employeeIdSet);
        if (WTCCollections.isNotEmpty((Map)synFileBoIdMap) && WTCCollections.isNotEmpty((Map)(boToErrMap = AttFileSyncService.getInstance().cacheAttFileSynAndSetOp(option, synFileBoIdMap.keySet(), AttFileTaskCacheInfoEnum.ATT_FILE_UPDATE, "fileRemoveBoId")))) {
            AttFileSyncService.getInstance().removeFileSynOpCache(option, "fileRemoveBoId");
            throw new KDBizException(AttFileKDString.existLockFile());
        }
    }

    public void rollbackOperation(RollbackOperationArgs rollbackOperationArgs) {
        AttFileSyncService.getInstance().removeFileSynOpCache(this.getOption(), "fileRemoveBoId");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        List rosterSynDataList;
        beginOperationTransactionArgs.setCancelOperation(true);
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        AttFileHelper.handleTextName((DynamicObject[])dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            String modeStr;
            if (FileTypeEnum.VCFILE.getFileType().equals(dataEntity.getString("type")) && HRStringUtils.isEmpty((String)(modeStr = dataEntity.getString("mode")))) {
                dataEntity.set("mode", (Object)AttModeEnum.NO_CARD.getCode());
            }
            dataEntity.set("bsed", dataEntity.get("startdate"));
            dataEntity.set("firstbsed", dataEntity.get("startdate"));
            dataEntity.set("enddate", (Object)WTCHisServiceHelper.getMaxEndDate());
            HRBaseServiceHelper attPersonHelper = new HRBaseServiceHelper("wtp_attendperson");
            DynamicObject attPersonDy = attPersonHelper.generateEmptyDynamicObject();
            attPersonDy.set("id", (Object)dataEntity.getLong("person.id"));
            dataEntity.set("attperson", (Object)attPersonDy);
        }
        List personIds = Arrays.stream(dataEntities).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        List empPosIds = Arrays.stream(dataEntities).map(data -> data.getLong("hrpiempposorgrel.id")).collect(Collectors.toList());
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("employee", Arrays.stream(dataEntities).map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee")).collect(Collectors.toList()));
        AttendPersonCurrResult attendPersonCurrResult = AttendPersonSynService.getInstance().checkAndGetPersonDataCustom(personIds, empPosIds, null, (Map)map);
        AttendPersonSynService.getInstance().setEarliestAndLatestDate(dataEntities, attendPersonCurrResult);
        AttendPersonSynService.getInstance().updateAttPerson(attendPersonCurrResult);
        AttFileServiceImpl instance = AttFileServiceImpl.getInstance();
        DynamicObject dynamicObject = dataEntities[0].getDynamicObject("empposorgrel");
        if (dynamicObject != null) {
            LOG.info("AttFileBaseSave first save dy wtp_depempjob {}", (Object)dynamicObject.toString());
        }
        Arrays.stream(dataEntities).forEach(dynamicObject1 -> {
            if (dynamicObject1.getLong("boid") != 0L) {
                dynamicObject1.set("boid", (Object)0L);
            }
        });
        String eventIdStr = (String)this.getOption().getVariables().get("event");
        long mainBoId = DB.genGlobalLongId();
        if (WTCStringUtils.isNotEmpty((String)eventIdStr)) {
            mainBoId = Long.parseLong(eventIdStr);
        }
        if (WTCCollections.isNotEmpty((Collection)(rosterSynDataList = instance.addAttFile(dataEntities, Long.valueOf(mainBoId))))) {
            this.getOption().setVariableValue(ROSTER_SYN_DATA_LIST, SerializationUtils.toJsonString((Object)rosterSynDataList));
        }
        String key = "schedule_Msg" + mainBoId;
        String cacheKey = WTCCacheUtils.getKey((String)"wtp", (String)key);
        DistributeSessionlessCache redis = WTCCacheUtils.getCache();
        String errMsg = (String)redis.get(cacheKey);
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            this.getOption().setVariableValue("schedule_Msg", errMsg);
            redis.remove(cacheKey);
        }
        Map<Long, Long> fileBoIdAndPersonIdMap = Arrays.stream(dataEntities).filter(dy -> dy.getDynamicObject("period") != null).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"person"), (a, b) -> a));
        boolean batchImport = this.getOption().getVariables().containsKey("importtag_of_datasource");
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setPersonSetIds(Arrays.stream(dataEntities).map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"person")).collect(Collectors.toSet()));
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setProperties("boid,person,person.id");
        Map<Long, Long> existBoData = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"person"), (a, b) -> a));
        fileBoIdAndPersonIdMap.putAll(existBoData);
        PerAttPeriodDataService.getInstance().processPerAttPeriod(batchImport ? "4" : null, fileBoIdAndPersonIdMap, false);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs afterOperationArgs) {
        Map variables = this.getOption().getVariables();
        String variableValue = (String)variables.get(ROSTER_SYN_DATA_LIST);
        if (HRStringUtils.isNotEmpty((String)variableValue)) {
            List rosterSynDataList = SerializationUtils.fromJsonStringToList((String)variableValue, Map.class);
            if (WTCCollections.isNotEmpty((Collection)rosterSynDataList)) {
                try {
                    AttFileScheduleBusiness.fileSyncRoster((rosterSynDataList.size() > 1 ? 1 : 0) != 0, (List)rosterSynDataList, (Map)variables);
                }
                catch (KDBizException kdBizException) {
                    this.getOption().setVariableValue("E2001", "E2001");
                    throw kdBizException;
                }
            }
            this.getOption().removeVariable(ROSTER_SYN_DATA_LIST);
        }
        AttFileSyncService.getInstance().removeFileSynOpCache(this.getOption(), "fileRemoveBoId");
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        IOperationResult operationResult = e.getOperationResult();
        if (operationResult.isSuccess() && this.sbOfCertMsg.length() > 0) {
            if (HRStringUtils.isNotEmpty((String)operationResult.getMessage())) {
                operationResult.setMessage(operationResult.getMessage() + this.sbOfCertMsg.toString());
                operationResult.addErrorInfo(new OperateErrorInfo());
            }
            operationResult.setMessage(this.sbOfCertMsg.toString());
        }
    }
}

